{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            showDetail:false,
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                out_trade_no: '',
                companyNameLike: '',
                createBegin: '',
                createEnd: '',
                amtBegin:'',
                amtEnd: '',
            },
            settleDetail: {},
            itemSearch:{
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                orderId: 0,
            }
        }
    },
    mounted: function () {
        this.getApplyStatusList();
        this.getIdentityTypeList();
        this.getEduTypeList();
        this.resetSearch();
    },
    created: function () {
    },
    methods: {
        getApplyStatusList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "applyStatus"}).then(cfg=>{
                self.applyStatusList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.applyStatusList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getIdentityTypeList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "identityType"}).then(cfg=>{
                self.identityTypeList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.identityTypeList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getEduTypeList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "eduType"}).then(cfg=>{
                self.eduTypeList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.eduTypeList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                out_trade_no: '',
                createBegin: '',
                createEnd: '',
                companyNameLike: '',
                amtBegin:'',
                amtEnd: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            this.$root.postReq("/web/esettleCtl/epartneramtlist", {
                search: this.getParams()
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            return callback();
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        openDetail(row) {
            this.itemSearch = {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                orderId: row.order_id,
            };
            console.log(row.order_id);
            this.settleDetail = row;
            this.showDetail = true;
            this.getItemList();
        },
        getItemList() {
            var self = this;
            var params = {
                currentPage: self.itemSearch.currentPage,
                pageSize: self.itemSearch.pageSize,
                orderId: self.itemSearch.orderId
            };
            console.log(params);
            self.$root.postReq("/web/esettleCtl/settleItemList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.itemSearch.list = d.data.rows || [];
                    self.itemSearch.total = d.data.count || 0;
                } else {
                }
            });
        },
        handleSizeChangeItem(val) {
            this.itemSearch.list = [];
            this.itemSearch.currentPage = 1;
            this.itemSearch.pageSize = val;
            this.itemSearch.total = 0;
            this.getItemList();
        },
        handleCurrentChangeItem(val) {
            this.search.currentPage = val;
            this.getItemList();
        },

    },
    vname: "gsb-epartneramtlist"
}