{
    template: '${tmpl}',
    data: function () {
        return {
            showTotal: false,
            tms: [],
            loopplays: [],
            channels: [],
            myCompanyCount: 0,
            myPartnerCount: 0,
            myCompanyCommssionCount: 0,
            myPartnerCommssionCount: 0,
            totalAmt: 0,
            totalSericeTax: 0,
            totalCompanyCommssionCount: 0,
            totalPartnerCommssionCount: 0,
            btn_focus: "background-color:#54C4A7;color:#FFFFFF;padding:10px;",
            btn_unfocus: "background-color:#FFFFFF;color:#828282;padding:10px;",
            pickerOptions1: {},
            beginTime: '',
            endTime: '',
            currentTab: 1,
            currentUser: null,
        }
    },
    mounted: function () {
        console.log("this is hhrhome.html -------------------------- ");

        this.getLoginUser();
        var self = this;
        this.pickerOptions1 = {
            disabledDate(time) {
                return time.getTime() > Date.now();
            },
            shortcuts: [{
                text: '今天',
                onClick(picker) {
                    picker.$emit('pick', new Date());
                }
            }, {
                text: '昨天',
                onClick(picker) {
                    const date = new Date();
                    date.setTime(date.getTime() - 3600 * 1000 * 24);
                    picker.$emit('pick', date);
                }
            }, {
                text: '一周前',
                onClick(picker) {
                    const date = new Date();
                    date.setTime(date.getTime() - 3600 * 1000 * 24 * 7);
                    picker.$emit('pick', date);
                }
            }]
        };
        this.chooseDateTab(1);
    },
    created: function () {

    },
    methods: {
        getLoginUser() {
            var self = this;
            this.$root.postReq("/web/userCtl/loginUser", {}).then(function (d) {
                if (d.status == 0 && d.data) {
                    self.currentUser = d.data;
                    self.showPage = true;
                    if(d.isDefaultPassword) {
                        self.$confirm("您的密码为系统初始密码，是否去修改密码", {
                            confirmButtonText: '去修改',
                            cancelButtonText: '暂不修改',
                            type: 'warning'
                        }).then(() => {
                            self.$root.pushx({
                                title:"个人中心",
                                name:"/usercenter"
                            });
                        }).catch(() => {
                        });
                    }
                }
            });
        },
        gopay() {
            this.$root.pushx({
                title: "查看订单",
                name: "/epartneramtlist"
            });
        },
        pickTime() {
            this.mystat();
            this.totalstat();
        },
        chooseDateTab(idx) {
            var now = new Date();
            this.currentTab = idx;
            if (idx == 0) {
                this.beginTime = "";
                this.endTime = "";
            } else if (idx == 1) {
                this.setMonthDate();
            } else if (idx == 2) {
                this.setLastMonthDate();
            } else if (idx == 3) {
                this.setYearDate();
            } else {}

            this.mystat();
            this.totalstat();
        },
        mystat() {
            var self = this;
            this.$root.postReq("/web/epartnerCtl/mystat", {
                beginTime: this.beginTime || "",
                endTime: this.endTime || ""
            }).then(function (d) {
                if (d.status == 0) {
                    self.myCompanyCount = d.data.myCompanyCount || 0;
                    self.myPartnerCount = d.data.myPartnerCount || 0;
                    self.myCompanyCommssionCount = d.data.myCompanyCommssionCount || 0;
                    self.myPartnerCommssionCount = d.data.myPartnerCommssionCount || 0;
                }
            });
        },
        totalstat() {
            var self = this;
            this.$root.postReq("/web/epartnerCtl/totalstat", {
                beginTime: this.beginTime || "",
                endTime: this.endTime || ""
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data.auth) {
                        self.showTotal = true;
                        self.totalAmt = d.data.totalAmt || 0;
                        self.totalSericeTax = d.data.totalSericeTax || 0;
                        self.totalCompanyCommssionCount = d.data.totalCompanyCommssionCount || 0;
                        self.totalPartnerCommssionCount = d.data.totalPartnerCommssionCount || 0;
                    }
                    
                }
            });
        },
        setMonthDate() {
            var now = new Date();
            var nowYear = now.getFullYear();
            var nowMonth = now.getMonth() + 1;
            nowMonth = nowMonth < 10 ? "0" + nowMonth : nowMonth;

            this.beginTime = nowYear + "-" + nowMonth;
            this.endTime = nowYear + "-" + nowMonth;
        },

        setLastMonthDate() {
            var now = new Date();
            now.setMonth(now.getMonth() - 1);

            var nowYear = now.getFullYear();
            var nowMonth = now.getMonth() + 1;
            nowMonth = nowMonth < 10 ? "0" + nowMonth : nowMonth;

            this.beginTime = nowYear + "-" + nowMonth;
            this.endTime = nowYear + "-" + nowMonth;
        },

        setYearDate() {
            var now = new Date();
            var nowYear = now.getFullYear();
            this.beginTime = nowYear + "-01";
            this.endTime = nowYear + "-12";
        },
    },
    vname: "gsb-hhrhome"
}