var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcAPI extends APIBase {
    constructor() {
        super();
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "submitNeed"://提交需求
                opResult = await this.needinfoSve.submitNeed(pobj, pobj.actionBody, req);
                break;
            case "submitNeedH5"://工商H5提交需求
                opResult = await this.needinfoSve.submitNeedH5(pobj, pobj.actionBody, req);
                break;
            case "getItemByNeedNo"://获取需求详情
                opResult = await this.needinfoSve.getItemByNeedNo(pobj);
                break;
            case "getItemByChannelNeedNo"://获取需求详情
                opResult = await this.needinfoSve.getItemByChannelNeedNo(pobj);
                break;
            case "needClose"://需求关闭
                opResult = await this.needinfoSve.needClose(pobj, pobj.actionBody, req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcAPI;