var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.userInfo) {
            return system.getResultFail(system.noLogin, "user no login!");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "addOrder"://创建订单
                opResult = await this.addOrder(pobj, pobj.actionBody);
                break;
            case "getOrderInfo"://获取订单列表信息
                opResult = await this.orderinfoSve.getOrderInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDetails"://获取订单详情信息
                opResult = await this.orderinfoSve.getOrderDetails(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryInfo"://获取订单交付信息
                opResult = await this.orderinfoSve.getOrderDeliveryInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowInfo"://获取订单交付流程信息
                opResult = await this.orderinfoSve.getOrderDeliveryFlowInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowList"://获取订单交付流程列表信息
                opResult = await this.orderinfoSve.getOrderDeliveryFlowList(pobj, pobj.actionBody);
                break;
            case "getOrderLogInfo"://获取订单日志信息
                opResult = await this.orderinfoSve.getOrderLogInfo(pobj, pobj.actionBody);
                break;
            case "delOrder"://删除订单
                opResult = await this.orderinfoSve.delOrder(pobj, pobj.actionBody);
                break;
            case "channeldelOrder"://阿里工商注册退款
                opResult = await this.orderinfoSve.channeldelOrder(pobj, pobj.actionBody);
                break;
            //--------------------------------支付相关接口------------开始
            case "getPayOrderInfo"://获取付款订单信息
                opResult = await this.orderinfoSve.getPayOrderInfo(pobj, pobj.actionBody);
                break;
            case "putReceiptVoucherInfo"://修改订单收款信息
                opResult = await this.orderinfoSve.putReceiptVoucherInfo(pobj, pobj.actionBody);
                break;
            //--------------------------------支付相关接口------------结束
            case "tmConfirm"://商标方案确认
                opResult = await this.orderinfoSve.tmConfirm(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


    async addOrder(pobj, actionBody) {
        if (!actionBody.product_info) {
            return system.getResult(null, "产品信息有误，20000");
        }
        var interface_info = null;
        var interface_list = actionBody.product_info.interface_info;
        if (interface_list) {
            var interface_list_temp = interface_list.filter(f => f.op_type == "addOrder")
            if (interface_list_temp && interface_list_temp.length > 0) {
                interface_info = interface_list_temp[0];
            } else { // 2020 0703lin 修改 如果数据库配置没有addorder类型接口 那么走默认创建订单的接口
                interface_info = {
                    interface_type: "bd",
                    interface_url: "service.dbcorder.orderinfoSve",
                    method_name: "createOtherOrder"
                };
            }
        }
        if (!interface_list || interface_list.length == 0) {
            interface_info = {
                interface_type: "bd",
                interface_url: "service.dbcorder.orderinfoSve",
                method_name: "createOtherOrder"
            };
        }//使用默认的其他订单

        if (!interface_info) {
            return system.getResult(null, "产品接口信息有误，20010");
        }
        if (!interface_info.interface_type) {
            return system.getResult(null, "产品接口类型信息有误，20020");
        }
        if (!interface_info.interface_url) {
            return system.getResult(null, "产品接口地址信息有误，20030");
        }
        var refOpResult = await this.reflexAction(interface_info, pobj);
        return refOpResult;
    }
    async reflexAction(interface_info, pobj) {
        var refResult = null;
        pobj.interface_params = interface_info.params;
        if (interface_info.interface_type == "bd") {
            if (!interface_info.method_name) {
                return system.getResult(null, "产品接口参数信息有误，20040");
            }//操作的方法名称
            var invokeObj = system.getObject(interface_info.interface_url);
            if (!invokeObj[interface_info.method_name]) {
                return system.getResult(null, "产品接口参数方法信息有误，20050");
            }
            var params = [pobj];
            refResult = await invokeObj[interface_info.method_name].apply(invokeObj, params);
        }
        else if (interface_info.interface_type == "yc") {

        }
        return refResult;
    }

}
module.exports = OrderAPI;