var APIBase = require("../../api.base");
var system = require("../../../system");
class AskForAPI extends APIBase {
  constructor() {
    super();
    this.askForSve = system.getObject("service.askfor.askForSve");
  }

  async tradeMark (pobj, qobj, req) {
    if (!pobj.userInfo) {
      return system.getResultFail(system.noLogin, "user no login!");
    }
    if (!pobj.actionType) {
      return system.getResult(null, "actionType参数不能为空");
    }
    let result
    switch (pobj.actionType) {
      case "getByUid":
        result = await this.askForSve.getByUid(pobj.userInfo.id, pobj.actionBody.page, pobj.actionBody.offset)
        return system.getResult2(result)
      case 'create':
        let param = {}
        param.user_id = pobj.userInfo.id
        delete pobj.actionBody.type
        param.a_content = JSON.stringify(pobj.actionBody.content)
        param.a_type = 1
        param.a_id = new Date().getTime()
        if (pobj.actionBody.user_name) {
          param.user_name = pobj.actionBody.user_name
        }
        param.a_mobile = pobj.actionBody.mobile || pobj.userInfo.mobile
        if (pobj.actionBody.addr) {
          param.a_addr = pobj.actionBody.addr
        }
        result = await this.askForSve.create(param)
        return system.getResult2(result)
      case 'delete':
        result = await this.askForSve.delete(pobj.actionBody.id)
        return system.getResult2(result)
    }
  }
}
module.exports = AskForAPI;