const Dao = require("../../dao.base");
class CollectDao extends Dao {
  constructor() {
    super(Dao.getModelName(CollectDao));
  }

  async getByUid (uid, page = 1, offset = 9) {
    return await this.model.findAndCountAll({
      where: { user_id: uid, c_type: 1 },
      limit: 9,
      offset: (page - 1) * offset
    })
  }

  async getByUidAndCollections (uid, collections) {
    let selectSql = `SELECT * FROM c_collect WHERE user_id=${uid} and c_type=1 and (`;
    for (let i in collections) {
      if (i == 0) {
        selectSql += `c_content like "%\\"name\\":\\"${collections[i]}\\"%"`
      } else {
        selectSql += ` or c_content like "%\\"name\\":\\"${collections[i]}\\"%"`
      }
    }
    selectSql += ')'
    let list = await this.customQuery(selectSql);
    return list
  }

  async create (param) {
    return await this.model.create(param)
  }

  async delete (id) {
    return await this.model.destroy({
      where: {
        id: id
      }
    })
  }
}
module.exports = CollectDao;