const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderInfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderInfoDao));
  }
  async getItemStatusByOrderNo(orderNo, uapp_id) {
    var sqlWhere = {
      where: {
        orderNo: orderNo
      },
      attributes: [
        "id",
        "uapp_id",
        "orderNo",
        "channelServiceNo",
        "channelOrderNo",
        "channelUserId",
        "ownerUserId",
        "payTime",
        "quantity",
        "serviceQuantity",
        "orderStatusName",
        "orderStatus",
        "totalSum",
        "payTotalSum",
        "refundSum",
        "invoiceApplyStatus",
        "created_at"],
      raw: true
    };
    if (uapp_id) {
      sqlWhere.where.uapp_id = uapp_id;
    }
    return await this.model.findOne(sqlWhere);
  }
  async delOrderByOrderNo(orderNo, uapp_id, channelUserId) {
    var sqlWhere = {
      orderNo: orderNo,
      uapp_id: uapp_id,
      channelUserId: channelUserId
    };
    return await this.delete(sqlWhere);
  }
  async channeldelOrder(channelOrderNo, uapp_id) {
    var sqlWhere = {
      channelOrderNo: channelOrderNo,
      uapp_id: uapp_id,
    };
    return await this.delete(sqlWhere);
  }
}
module.exports = OrderInfoDao;
