const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderProductDao));
  }
  async getItemByOrderNo(orderNo, uapp_id) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo, uapp_id: uapp_id
      },
      attributes: [
        "sourceOrderNo",
        "productType_id",
        "pathCode",
        "itemCode",
        "itemName",
        "channelItemCode",
        "channelItemName",
        "serviceItemCode",
        "payAfterJumpH5Url",
        "payAfterJumpPcUrl",
        "picUrl",
        "price",
        "quantity",
        "serviceItemSnapshot"],
      raw: true
    });
  }
  async getItemInfoByOrderNo(orderNo) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo
      },
      raw: true
    });
  }
}
module.exports = OrderProductDao;
