const system = require("../../../system");
const Dao = require("../../dao.base");
class NeedinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(NeedinfoDao));
  }
  async getItemByNeedNo(needNo) {
    return await this.model.findOne({
      where: {
        needNo: needNo
      },
      attributes: [
        "id",
        "uapp_id",
        "needNo",
        "channelNeedNo",
        "channelUserId",
        "followManUserId",
        "followManMobile",
        "city",
        "province",
        "publishContent",
        "publishName",
        "publishMobile",
        "notes",
        "followContent",
        "disposeNotes",
        "status",
        "typeCode",
        "typeName",
        "channelTypeCode",
        "channelTypeName",
        "publisherOnlyCode",
        "followManName",
        "followManOnlyCode"],
      raw: true
    });
  }
  async getItemByChannelNeedNo(channelNeedNo) {
    return await this.model.findOne({
      where: {
        channelNeedNo: channelNeedNo
      },
      attributes: [
        "id",
        "uapp_id",
        "needNo",
        "channelNeedNo",
        "channelUserId",
        "followManUserId",
        "followManMobile",
        "city",
        "province",
        "publishContent",
        "publishName",
        "publishMobile",
        "notes",
        "followContent",
        "disposeNotes",
        "status",
        "typeCode",
        "typeName",
        "channelTypeCode",
        "channelTypeName",
        "publisherOnlyCode",
        "followManName",
        "followManOnlyCode"],
      raw: true
    });
  }
}
module.exports = NeedinfoDao;
