const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("needinfo", {
    uapp_id: DataTypes.INTEGER,
    channelNeedNo: DataTypes.STRING(128), //渠道需求号（页面中列表中显示该需求号）
    needNo: DataTypes.STRING(128), //需求号--用于服务商或需求表中创建订单
    channelUserId: DataTypes.INTEGER,//发布者id
    publishName: DataTypes.STRING,//发布者姓名
    publisherOnlyCode: DataTypes.STRING(50),//发布者唯一码
    publishContent: DataTypes.STRING,//发布内容
    publishMobile: DataTypes.STRING,//发布者手机号
    followManUserId: DataTypes.INTEGER,//跟进人id
    followManName: DataTypes.STRING,//跟进人姓名 
    followManMobile: DataTypes.STRING,//跟进人手机号（合伙人）
    followManOnlyCode: DataTypes.STRING(50),//跟进者唯一码
    followContent: DataTypes.STRING,//跟进内容
    productOneType_id: DataTypes.STRING,//产品大类Id
    productType_id: DataTypes.STRING,//产品类型Id
    notes: DataTypes.STRING,//备注
    disposeNotes: DataTypes.STRING,//处理的备注
    statusName: DataTypes.STRING,
    status: {
      //wts未推送,yts已推送,ygj已跟进,ycd已成单
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.push_chance_type),
      set: function (val) {
        this.setDataValue("status", val);
        this.setDataValue("statusName", uiconfig.config.pdict.push_chance_type[val]);
      }
    },
    city: DataTypes.STRING(50), // 城市
    province: DataTypes.STRING(50), // 省份
    typeCode: DataTypes.STRING(50), //产品类型编码',
    typeName: DataTypes.STRING(50), //类型产品名称',
    channelTypeCode: DataTypes.STRING(50), //渠道产品类型编码',
    channelTypeName: DataTypes.STRING(255), //渠道产品类型名称',
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'n_need_info',
      validate: {

      },
      indexes: [

      ]
    });
}
