const system = require("../../../system");
const uuidv4 = require('uuid/v4');
//内部通知调用
class InternalCallsNotifyService {
  constructor() {
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.delivery_status={ 
      "dqrfa": "待确认方案", 
      "fabtg": "方案不通过", 
      "dfwsfw": "待服务", 
      "dsccl": "待上传材料", 
      "dsh": "待审核", 
      "ddj": "待递交", 
      "ydj": "已递交", 
      "ywc": "已完成" 
    };
    this.statusContrast={
      "WAITCONFIRM":{name:"待确认方案",value:"dqrfa"},
      "CONFIRMFAIL":{name:"方案不通过",value:"fabtg"},
      "READY":{name:"待上传材料",value:"dsccl"},
      "WAITCOMMIT":{name:"待递交",value:"ddj"},
      "WAITARTIFICIALEXAMINE":{name:"待审核",value:"dsh"},
      "DOCFINISH": {name:"待审核",value:"dsh"},
      "AWAITCHECK": {name:"待审核",value:"dsh"},
      "COMMITED": {name:"已递交",value:"ydj"},
      "ROBOT": {name:"已递交",value:"ydj"},
      "ROBOTPAY": {name:"已递交",value:"ydj"},
      "RECVCOMMIT": {name:"已递交",value:"ydj"},
    };
  }
  //接收辅助、担保商标注册信息
  async receiveAssistTmData(pobj){
    var checkRes = await this.checkParams(pobj);
    if(checkRes.status==0){
      var deliveryData = await this.packagingTmDeliveryData(pobj,null);
      //获取交付信息
      var orderdeliveryRes = await this.getOrderDelivery(pobj.sourceOrderNo,pobj.serviceNo);
      if(orderdeliveryRes && orderdeliveryRes.length>0){
        return system.getResult(null,"保存商标订单交付信息失败，存在重复交付信息，不能重复提交，10300");
      }
      this.addOrderDelivery(deliveryData,deliveryData.sourceOrderNo);
      await this.orderinfoDao.model.update({isSolution:1}, { where: { orderNo: pobj.sourceOrderNo }});
      return system.getResultSuccess();
    }else{
      return checkRes;
    }
  }
  //接收辅助、担保商标注册修改信息
  async receiveEditAssistTmData(pobj){
    var checkRes = await this.checkParams(pobj);
    if(checkRes.status==0){
      //获取交付信息
      var orderdeliveryRes = await this.getOrderDelivery(pobj.sourceOrderNo,pobj.serviceNo);
      if(!orderdeliveryRes || orderdeliveryRes.length<1){
        return system.getResult(null,"未知交付信息，10150");
      }
      var orderdelivery = orderdeliveryRes[0];
      var deliveryData = await this.packagingTmDeliveryData(pobj,orderdelivery.deliveryContent);
      this.putOrderDelivery(deliveryData,deliveryData.sourceOrderNo,deliveryData.serviceNo);
      await this.orderinfoDao.model.update({isSolution:1}, { where: { orderNo: pobj.sourceOrderNo }});
      return system.getResultSuccess();
    }else{
      return checkRes;
    }
  }
//-----------------------------------------------------------------------------------------------------
  async checkParams(pobj){//参数校验
    if (!pobj.serviceNo) {
      return system.getResult(null, "业务单号不能为空不能为空，10100");
    }
    if (!pobj.sourceOrderNo) {
      return system.getResult(null, "来源单号不能为空，10110");
    }
    var orderinfo = await this.orderinfoDao.model.findOne({
      where:{orderNo:pobj.sourceOrderNo},raw:true
    });
    if(!orderinfo || !orderinfo.id){
      return system.getResult(null, "未知订单，10120");
    }
    if (!pobj.tm) {
      return system.getResult(null, "商标信息不能为空，10130");
    }
    if (!pobj.nclones) {
      return system.getResult(null, "商品/服务项不能为空，10140");
    }
    if (!pobj.tm) {
      return system.getResult(null, "商标信息不能为空，10150");
    }
    if (!pobj.tm.tmFormType) {
      return system.getResult(null, "商标类型不能为空，10160");
    }
    if (pobj.tm.tmFormType == "4") {
      pobj.tm.tmName = "图形";
    }
    if (!pobj.tm.tmName) {
      return system.getResult(null, "商标名称不能为空，10170");
    }
    if (!pobj.tm.picUrl) {
      return system.getResult(null, "商标图样不能为空，10180");
    }
    if (!pobj.apply) {
      return system.getResult(null, "申请信息不能为空，10190");
    }
    if (!pobj.apply.code) {
      return system.getResult(null, "申请统一社会信用代码不能为空，10200");
    }
    if (!pobj.apply.zipCode) {
      return system.getResult(null, "申请邮编不能为空，10210");
    }
    if (!pobj.apply.customerType) {
      return system.getResult(null, "申请人类型不能为空，10220");
    }
    if (pobj.apply.customerType != "ent" && pobj.apply.customerType != "person") {
      return system.getResult(null, "申请人类型错误，10230");
    }
    if (!pobj.orderContact) {
      return system.getResult(null, "联系人信息不能为空，10240");
    }
    if (!pobj.orderContact.contactName) {
      return system.getResult(null, "联系人姓名不能为空，10250");
    }
    if (!pobj.orderContact.mobile) {
      return system.getResult(null, "联系人手机号不能为空，10260");
    }
    return system.getResultSuccess(pobj);
  }
  async packagingTmDeliveryData(pobj,deliveryData) {//重新组装商标交付信息
    var deliveryStatusList = [];
    if(deliveryData && deliveryData.deliveryStatusList){
      deliveryStatusList = deliveryData.deliveryStatusList;
    }
    var nclOne = pobj.nclones[0];
    if(nclOne.tmStatus){
      var deliveryStatusObj = this.statusContrast[nclOne.tmStatus];
      if(deliveryStatusObj && deliveryStatusObj.value){
        var deliveryStatus = deliveryStatusObj.value;
        var deliveryStatusName = deliveryStatusObj.name;
        deliveryStatusList.push({
          deliveryStatus: deliveryStatus,
          deliveryStatusName: deliveryStatusName,
          deliveryUpdated: new Date()
        });
        pobj.deliveryStatus = deliveryStatus;
        pobj.deliveryStatusName = deliveryStatusName;
      }else{
        deliveryStatusList.push({
          deliveryStatus: nclOne.tmStatus,
          deliveryStatusName: nclOne.tmStatus,
          deliveryUpdated: new Date()
        });
      }
    }
    pobj.deliveryStatusList = deliveryStatusList;                                                                                                                                                                                             
    pobj.opNotes = ""; //操作备注  
    return pobj;
  }
  putOrderDelivery(data, orderNo, channelOrderNo) {//修改交付信息
    var sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + JSON.stringify(data) + "' where sourceOrderNo='" + orderNo + "'";
    sql = sql + " and deliveryContent->'$.serviceNo' = '"+channelOrderNo+"'";
    this.orderinfoDao.customUpdate(sql);
  }
  addOrderDelivery(data, orderNo) {//新增交付信息
    var sql = "INSERT INTO  `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
      orderNo + "','" + JSON.stringify(data) + "')";
    this.orderinfoDao.customQuery(sql);
  }
  async getOrderDelivery(orderNo,channelOrderNo) {//查询交付信息
    var sql = "select * from `c_order_delivery` where sourceOrderNo='" + orderNo + "'";
    sql = sql + " and deliveryContent->'$.serviceNo' = '"+channelOrderNo+"'";
    return await this.orderinfoDao.customQuery(sql);
  }
  //----------------------------------------------------------------------------------------------------------
}
module.exports = InternalCallsNotifyService;