const system = require("../../../system");
const uuidv4 = require('uuid/v4');
//内部通知调用
class LogoOrderService {
  constructor() {
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.execClient = system.getObject("util.execClient");
  }
  //获取已购买logo
  async getPaidLogoListByUser(pobj){
    var ab = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var userInfo = pobj.userInfo;
    if(!appInfo || !appInfo.uapp_id){
      return system.getResultFail(-101,"未知应用");
    }
    if(!userInfo || !userInfo.id){
      return system.getResultFail(-102,"未知用户");
    }
    var pageSize = Number(ab.pageSize || 100);
    if (pageSize > 100) {
      pageSize = 100;
    }
    var pageIndex = Number(ab.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    var sql = "SELECT o.* ,d.*,p.itemCode FROM "+
    "( SELECT id,orderNo FROM `c_order_info` WHERE uapp_id="+appInfo.uapp_id+" and (orderStatus='2' or orderStatus='4' or orderStatus='8' ) and ownerUserId='"+userInfo.channel_userid+"') AS o "+
    "LEFT JOIN ( SELECT sourceOrderNo , itemCode FROM c_order_product where itemCode='znlogosjcp' and uapp_id="+appInfo.uapp_id+" ) AS p ON o.orderNo = p.sourceOrderNo "+
    "LEFT JOIN ( SELECT sourceOrderNo, deliveryContent FROM c_order_delivery ) AS d ON o.orderNo = d.sourceOrderNo "+
    " where itemCode is not null";
    sql += " order by id desc LIMIT " + pageSize + " OFFSET " + from;
    var sqlCount = "SELECT count(1) as dataCount FROM "+
    "( SELECT id,orderNo FROM `c_order_info` WHERE uapp_id="+appInfo.uapp_id+" and (orderStatus='2' or orderStatus='4' or orderStatus='8' ) and ownerUserId='"+userInfo.channel_userid+"') AS o "+
    "LEFT JOIN ( SELECT sourceOrderNo , itemCode FROM c_order_product where itemCode='znlogosjcp' and uapp_id="+appInfo.uapp_id+" ) AS p ON o.orderNo = p.sourceOrderNo "+
    "LEFT JOIN ( SELECT sourceOrderNo, deliveryContent FROM c_order_delivery ) AS d ON o.orderNo = d.sourceOrderNo "+
    " where itemCode is not null";
    var list = await this.orderinfoDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    var tmpResultCount = await this.orderinfoDao.customQuery(sqlCount);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
  //下载logo素材
  async getLogoMaterial(pobj){
    var ab = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var userInfo = pobj.userInfo;
    if(!appInfo || !appInfo.uapp_id){
      return system.getResultFail(-101,"未知应用");
    }
    if(!userInfo || !userInfo.id){
      return system.getResultFail(-102,"未知用户");
    }
    if(!ab || !ab.orderNo){
      return system.getResultFail(-103,"订单号参数错误");
    }
    var orderinfo = await this.orderinfoDao.model.findOne({
      where:{orderNo:ab.orderNo,ownerUserId:userInfo.channel_userid},
      raw:true
    });
    if(!orderinfo || !orderinfo.id){
      return system.getResultFail(-104,"未知订单");
    }
    // "order_status": { 1: "待付款", 2: "已付款", 4: "服务中", 8: "已完成", 16: "已退款", 32: "已作废" },
    if(!orderinfo.orderStatus || (orderinfo.orderStatus!="2" && orderinfo.orderStatus!="4" && orderinfo.orderStatus!="8")){
      return system.getResultFail(-105,"订单状态错误");
    }
    var orderdeliveryRes = await this.getOrderDelivery(ab.orderNo);
    if(!orderdeliveryRes || orderdeliveryRes.length<1){
      return system.getResultFail(-106,"未知交付信息");
    }
    var orderdelivery = orderdeliveryRes[0];
    var deliveryContent = orderdelivery.deliveryContent;
    if(!deliveryContent){
      return system.getResultFail(-107,"交付信息不存在");
    }
    if(deliveryContent.down_url){
      return system.getResultSuccess(deliveryContent.down_url);
    }else{//从接口返回
      var logodownRes = await this.getLogoDownUrl({
          "id": deliveryContent.logo_id,
          "title": deliveryContent.title,
          "subtitle": deliveryContent.subtitle || ""
      });
      if(logodownRes && logodownRes.status==0 && logodownRes.data && logodownRes.data.down_url){
        deliveryContent.down_url = logodownRes.data.down_url;
        if(deliveryContent.color_description){
          deliveryContent.color_description = deliveryContent.color_description.replace(/\"/g,"\\\"");;
        }
        if(deliveryContent.font_description){
          deliveryContent.font_description = deliveryContent.font_description.replace(/\"/g,"\\\"");;
        }  
        this.putOrderDelivery(deliveryContent,ab.orderNo);
        return system.getResultSuccess(logodownRes.data.down_url);
      }else{
        return system.getResultFail(-109,"获取logo材料失败");
      }
    }
    return system.getResultFail(-110,"获取logo材料失败。");
  }
  async getLogoDownUrl(obj){
    var url = "http://123.57.217.203:4724/api/downloadlogo";//"http://ailogo-service/api/downloadlogo";
    var rtn = await this.execClient.execPost(obj, url);
    var a = JSON.parse(rtn.stdout)
    return a;
  }
  putOrderDelivery(data, orderNo) {//修改交付信息
    var sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + JSON.stringify(data) + "' where sourceOrderNo='" + orderNo + "'";
    this.orderinfoDao.customUpdate(sql);
  }
  addOrderDelivery(data, orderNo) {//新增交付信息
    var sql = "INSERT INTO  `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
      orderNo + "','" + JSON.stringify(data) + "')";
    this.orderinfoDao.customQuery(sql);
  }
  async getOrderDelivery(orderNo) {//查询交付信息
    var sql = "select * from `c_order_delivery` where sourceOrderNo='" + orderNo + "'";
    return await this.orderinfoDao.customQuery(sql);
  }
  //收藏logo
  async collectLogo(pobj){
    var ab = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var userInfo = pobj.userInfo;
    if(!appInfo || !appInfo.uapp_id){
      return system.getResultFail(-101,"未知应用");
    }
    if(!userInfo || !userInfo.id){
      return system.getResultFail(-102,"未知用户");
    }
    if(!ab){
      return system.getResultFail(-103,"参数错误");
    }
    if(!ab.logo_id){
      return system.getResultFail(-104,"logo编号不能为空");
    }
    if(!ab.title){
      return system.getResultFail(-105,"品牌名称不能为空");
    }
    // if(!ab.subtitle){
    //   return system.getResultFail(-106,"品牌标语不能为空");
    // }
    if(!ab.profession){
      return system.getResultFail(-107,"行业名称不能为空");
    }
    // if (!ab.description) {
    //   return system.getResultFail(-108, "描述信息不能为空");
    // }
    if (!ab.pic_url) {
      return system.getResultFail(-109, "图标链接不能为空");
    }
    if (!ab.itemCode) {
      return system.getResultFail(-110, "产品编码不能为空");
    }
    if(ab.color_description){
      ab.color_description = ab.color_description.replace(/\"/g,"\\\"");;
    }
    if(ab.font_description){
      ab.font_description = ab.font_description.replace(/\"/g,"\\\"");;
    }
    this.addCollectInfo(appInfo.uapp_id,userInfo.channel_userid,ab);
    return system.getResultSuccess();
  }
  //取消收藏logo
  async cancelCollectLogo(pobj){
    var ab = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var userInfo = pobj.userInfo;
    if(!appInfo || !appInfo.uapp_id){
      return system.getResultFail(-101,"未知应用");
    }
    if(!userInfo || !userInfo.channel_userid){
      return system.getResultFail(-102,"未知用户");
    }
    if(!ab){
      return system.getResultFail(-103,"参数错误");
    }
    if(!ab.id){
      return system.getResultFail(-104,"收藏编号不能为空");
    }
    var sql = "DELETE FROM `c_collect_info` where id="+ab.id+" and channelUserId='"+userInfo.channel_userid+"'";
    this.orderinfoDao.customQuery(sql);
    return system.getResultSuccess();
  }
  addCollectInfo(uapp_id,channelUserId,data) {//新增收藏信息
    var sql = "INSERT INTO  `c_collect_info` (`uapp_id`,`channelUserId`,`collectContent`) VALUE("+uapp_id+",'" +
    channelUserId + "','" + JSON.stringify(data) + "')";
    this.orderinfoDao.customQuery(sql);
  }
  async getCollectibleLogoListByUser(pobj) {//查询logo收藏信息
    var ab = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var userInfo = pobj.userInfo;
    if(!appInfo || !appInfo.uapp_id){
      return system.getResultFail(-101,"未知应用");
    }
    if(!userInfo || !userInfo.id){
      return system.getResultFail(-102,"未知用户");
    }
    var pageSize = Number(ab.pageSize || 20);
    if (pageSize > 100) {
      pageSize = 100;
    }
    var pageIndex = Number(ab.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    var sql = "select * from `c_collect_info` where uapp_id="+appInfo.uapp_id+" and channelUserId='"+userInfo.channel_userid+"'";
    sql = sql+" and collectContent->'$.itemCode' = 'znlogosjcp'";
    sql += " order by id desc LIMIT " + pageSize + " OFFSET " + from;
    var sqlcount = "select count(1) as dataCount from `c_collect_info` where uapp_id="+appInfo.uapp_id+" and channelUserId='"+userInfo.channel_userid+"'";
    sqlcount = sqlcount+" and collectContent->'$.itemCode' = 'znlogosjcp'";
    var list = await this.orderinfoDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    var tmpResultCount = await this.orderinfoDao.customQuery(sqlcount);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
}
module.exports = LogoOrderService;