const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var moment = require('moment')
class OrderInfoService extends ServiceBase {
  constructor() {
      super("dbcorder", ServiceBase.getDaoName(OrderInfoService));
      this.orderInfoDao = system.getObject("db.dbcorder.orderinfoDao");
      this.needInfoDao = system.getObject("db.dbneed.needinfoDao");
      this.orderRegionDao = system.getObject("db.dbcorder.orderregionDao");
      this.ordercontactsDao = system.getObject("db.dbcorder.ordercontactsDao");
      this.flowlogDao = system.getObject("db.dbcorder.flowlogDao");
  }

  async getOrderInfo(pobj, actionBody) {//获取订单列表信息
    var pageSize = Number(actionBody.pageSize || 20);
    if (pageSize > 50) {
      pageSize = 50;
    }
    var pageIndex = Number(actionBody.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);

    var paramWhere = {};
    // var sql = "select `isSolution`,`orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`,"
    //   + " `invoiceApplyStatus`,`opNotes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,created_at from v_order where uapp_id=:uapp_id";
    // var sqlCount = "select count(1) as dataCount from v_order where uapp_id=:uapp_id";
    var sql = "select `orderNo`,`channelUserId`,`payTime`,`quantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`totalDiscounts`,`refundSum`,`refundTime`,"
      + " `channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,`serviceItemCode`,`picUrl`,v_order.`created_at`,v_order.`updated_at`,"
      + " c_order_contacts.contactName,c_order_contacts.mobile from v_order left join c_order_contacts on v_order.orderNo=c_order_contacts.sourceOrderNo where v_order.uapp_id=:uapp_id";
    var sqlCount = "select count(1) as dataCount from v_order where uapp_id=:uapp_id";

    paramWhere.uapp_id = pobj.appInfo.uapp_id;

    if (actionBody.orderStatus) {
      sql += " and orderStatus=:orderStatus";
      sqlCount += " and orderStatus=:orderStatus";
      paramWhere.orderStatus = actionBody.orderStatus;
    }
    if (actionBody.startTime && actionBody.entTime) {
      var startTime = actionBody.startTime.trim() + " 00:00:00";
      var entTime = actionBody.entTime + " 23:59:59";
      sql += " and v_order.updated_at >=:startTime and  v_order.updated_at<=:entTime";
      sqlCount += " and v_order.updated_at >=:startTime and  v_order.updated_at<=:entTime";
      paramWhere.startTime = startTime;
      paramWhere.entTime = entTime;
    }

    sql += " order by v_order.id desc LIMIT " + pageSize + " OFFSET " + from;
 
    var list = await this.customQuery(sql, paramWhere);
    var result = system.getResultSuccess(list);

    var tmpResultCount = await this.customQuery(sqlCount, paramWhere);

    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

    return result;

  }

  // ----------------------------------------------uk运营后台  开始
  // uk运营后台 业务统计
  async getStatistics(pobj, actionBody) {
    // 需求量sql 查询关于渠道的需求订单
    var needsCountSql = "select count(1) as count from n_need_info where uapp_id= " + actionBody.uappId
    
    // 转换率sql 查询需求表并且有需求方案
    var conversionRateListSql = "SELECT DISTINCT need.needNo,count(1) as count "
    + " FROM n_need_info AS need LEFT JOIN n_need_solution AS solution ON need.needNo = solution.needNo "
    + " where solution.orderNo is not null and need.uapp_id = " + actionBody.uappId;

    // 订单相关sql 查询订单量/订单交易额/公司宝结算额/渠道毛利
    var payObjSql = "select sum(totalSum) as totalSum,sum(pfProfitSum) as parentProfit,sum(channelProfitSum) as grossProfit, count(1) as count "
    + " from c_order_info where uapp_id=" + actionBody.uappId + " and orderStatus!=1";

    // 整合起始时间/截止时间
    var paramWhere = {}
    if(actionBody.startTime && actionBody.entTime) {
        var startTime = actionBody.startTime.trim() + " 00:00:00";
        var entTime = actionBody.entTime + " 23:59:59";
        needsCountSql += " and updated_at >=:startTime and updated_at<=:entTime";// 关于需求用了uupdate_at，订单用的created_at
        conversionRateListSql += " and need.updated_at >=:startTime and  need.updated_at<=:entTime";
        payObjSql += " and created_at >=:startTime and  created_at<=:entTime";
        paramWhere.startTime = startTime;
        paramWhere.entTime = entTime;
    }
    // 需求量
    var needsCountList = await this.needInfoDao.customQuery(needsCountSql,paramWhere);
    var needsCount = needsCountList[0]["count"];
    if(needsCountList.length != 0) {
        needsCount = 0;
    }

    // 需求订单转化为订单的数量 保留两位 成为订单的需求 / 需求数量
    var conversionRateList = await this.needInfoDao.customQuery(conversionRateListSql,paramWhere);
    var conversionRate = (conversionRateList[0]["count"] / needsCount).toFixed(2);
    if(conversionRateList.length != 1 || conversionRateList[0]["count"] == 0) {
        conversionRate = 0;
    }

    // 订单量/交易总额/公司宝结算额/对方毛利
    var payObj = await this.customQuery(payObjSql,paramWhere);
    payObj = payObj[0];

    let resultObj = {
        needsCount: needsCount,
        payCount: payObj.count ? payObj.count : 0,
        conversionRate: conversionRate,
        totalSum: payObj.totalSum ? payObj.totalSum : 0,
        parentProfit: payObj.parentProfit ? payObj.parentProfit : 0,
        grossProfit: payObj.grossProfit ? payObj.grossProfit : 0
    }
    var result = system.getResultSuccess(resultObj);
    return result;
  }

  // 趋势分析
  async getTrend(pobj, actionBody) {
    var startTime = moment().subtract(1, "years").format("YYYY-MM-DD HH:mm:ss");
    var entTime = moment().format("YYYY-MM-DD HH:mm:ss");
    // date
    var monthList = [];
    for(var i = 11;i >= 0;i--) {
        monthList.push(moment().subtract(i, "month").format("YYYY-MM"))
    }
    var paramWhere = {
        uappId:actionBody.uappId,
        startTime: startTime,
        entTime: entTime
    }
    // 根据月份分组需求订单
    var needListSql = "SELECT DATE_FORMAT(created_at, '%Y-%m') AS month,count(*) as count "
    + " FROM n_need_info where uapp_id=:uappId and created_at >=:startTime and created_at<=:entTime GROUP BY month"
    var needList = await this.needInfoDao.customQuery(needListSql,paramWhere);
    // 根据月份分组支付订单
    var orderListSql = "SELECT DATE_FORMAT(created_at, '%Y-%m') AS month,count(*) as count "
    + " FROM c_order_info where orderStatus=2 and uapp_id=:uappId and created_at >=:startTime and created_at<=:entTime GROUP BY month"
    var orderList = await this.customQuery(orderListSql,paramWhere);
    // 处理数据
    for(var i =0;i < monthList.length;i++) {
        var needMonthList = []
        for(var j = 0;j < needList.length;j++) {
            needMonthList.push(needList[j]["month"])
        }
        if(needMonthList.indexOf(monthList[i]) < 0) {
            var obj = {
                month: monthList[i],
                count:0
            }
            needList.push(obj)
        }
        var orderMonthList = []
        for(var j = 0;j < orderList.length;j++) {
            orderMonthList.push(orderList[j]["month"])
        }
        if(orderMonthList.indexOf(monthList[i]) < 0) {
            var obj = {
                month: monthList[i],
                count:0
            }
            orderList.push(obj)
        }
    }
    function sortByKey(array, key) {
        return array.sort(function(a, b) {
            var x = a[key]; var y = b[key];
            return ((x < y) ? -1 : ((x > y) ? 1 : 0));
        });
    }
    orderList = sortByKey(orderList,'month')
    needList = sortByKey(needList,'month')
    let resultObj = {
        date: monthList,
        pay: orderList,
        need: needList
    }
    var result = system.getResultSuccess(resultObj);
    return result;
  }
  
  // 概览-产品销售分布
  async getProductTypesales(pobj, actionBody) {
    var startTime = moment().subtract(1, "years").format("YYYY-MM-DD HH:mm:ss");
    var entTime = moment().format("YYYY-MM-DD HH:mm:ss");
    
    var paramWhere = {
        uappId:actionBody.uappId,
        startTime: startTime,
        entTime: entTime
    }
    // 根据月份分组支付订单
    var productCounSql = "SELECT product.itemName as productName,count(1) as count "
    + " FROM c_order_product AS product LEFT JOIN c_order_info AS orde ON product.sourceOrderNo = orde.orderNo "
    + " WHERE product.uapp_id = :uappId  and orde.orderStatus != 1 and product.created_at >=:startTime and product.created_at<=:entTime"
    + " GROUP BY product.itemName" 
    var productCountList = await this.customQuery(productCounSql,paramWhere);

    var result = system.getResultSuccess(productCountList);
    return result;
  }

  // 客户地域分布
  async getCustomerArea(pobj, actionBody) {
    var paramWhere = {
        uappId:actionBody.uappId,
    }
    // 根据月份分组支付订单
    var customerAreaSql = "select province as name, count as value from c_order_region where uapp_id=:uappId" 
    var customerAreaList = await this.orderRegionDao.customQuery(customerAreaSql,paramWhere);

    var result = system.getResultSuccess(customerAreaList);
    return result;
  }

  // 交付单列表
  async getOrderDeliveryInfo(pobj, actionBody) {
    var pageSize = Number(actionBody.pageSize || 10);
    if (pageSize > 50) {
      pageSize = 50;
    }
    var pageIndex = Number(actionBody.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);

    var paramWhere = {};
    var sql = "SELECT `orderNo`,`channelItemName` AS produuctName,`quantity`,`payTotalSum` AS totalSum,`updated_at` AS updateAt, " 
    + " json_extract ( delivery.deliveryContent, '$.tm.tmName' ) AS tmName ,"
    + " json_extract ( delivery.deliveryContent, '$.apply.name' ) AS contactName ,"
    + " json_extract ( delivery.deliveryContent, '$.deliveryStatusName' ) AS deliveryStatusName "
    + " FROM v_order LEFT JOIN c_order_delivery as delivery ON v_order.orderNo = delivery.sourceOrderNo "
    + " WHERE v_order.uapp_id =:uappId AND v_order.orderStatus != 1";
    var sqlCount = "select count(1) as dataCount from v_order LEFT JOIN c_order_delivery as delivery ON v_order.orderNo = delivery.sourceOrderNo "
    + " where uapp_id=:uappId AND v_order.orderStatus != 1";

    paramWhere.uappId = pobj.appInfo.uapp_id;

    if(actionBody.orderNo) {
        sql += " and orderNo=:orderNo";
        sqlCount += " and orderNo=:orderNo";
        paramWhere.orderNo = actionBody.orderNo;
    }
    if(actionBody.tmName) {
        sql += " and json_extract(delivery.deliveryContent,'$.tm.tmName') =:tmName";
        sqlCount += " and json_extract(delivery.deliveryContent,'$.tm.tmName') =:tmName";
        paramWhere.tmName = actionBody.tmName;
    }
    if(actionBody.contactName) {
        sql += " and json_extract(delivery.deliveryContent,'$.apply.name') =:contactName";
        sqlCount += " and json_extract(delivery.deliveryContent,'$.apply.name') =:contactName";
        paramWhere.contactName = actionBody.contactName;
    }
    if (actionBody.startTime && actionBody.entTime) {
      var startTime = actionBody.startTime.trim() + " 00:00:00";
      var entTime = actionBody.entTime + " 23:59:59";
      sql += " and updated_at >=:startTime and  updated_at<=:entTime";
      sqlCount += " and updated_at >=:startTime and  updated_at<=:entTime";
      paramWhere.startTime = startTime;
      paramWhere.entTime = entTime;
    }

    sql += " order by v_order.id desc LIMIT " + pageSize + " OFFSET " + from;
 
    var list = await this.customQuery(sql, paramWhere);
    var result = system.getResultSuccess(list);

    var tmpResultCount = await this.customQuery(sqlCount, paramWhere);

    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

    return result;
  }

  async getOrderLogInfo(pobj, actionBody) {//获取订单日志信息
    var list = await this.flowlogDao.getlogListBySourceOrderNo(actionBody.orderNo);
    return list;
  }
  // 交付单详情
  async getOrderDelivery(pobj, actionBody) {
    var sql = "select * from c_order_delivery where sourceOrderNo=:sourceOrderNo";
    var paramWhere = { sourceOrderNo: actionBody.orderNo };
    var list = await this.customQuery(sql, paramWhere);
    var result = system.getResultSuccess();
    result.data = {};
    if (list && list.length > 0) {
      if (list[0].deliveryContent) {
        result.data = list[0].deliveryContent;
      }
    }
    result.data.orderContact = null;
    if (!actionBody.isGetContact) {
      var item = await this.ordercontactsDao.getItemByOrderNo(actionBody.orderNo);
      if (item) {
        result.data.orderContact = item;
      }
    }//是否获取联系人，isGetContact有值则不获取

    // 操作明细
    result.data.deliveryFlowLog = await this.getOrderLogInfo(pobj, actionBody);
    return result;
  }

  // ----------------------------------------------uk运营后台  结束
}
module.exports = OrderInfoService;
