const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class NeedinfoService extends ServiceBase {
  constructor() {
    super("dbneed", ServiceBase.getDaoName(NeedinfoService));
    this.execlient = system.getObject("util.execClient");
    this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
  }
  async getItemByNeedNo(pobj) {
    var item = await this.dao.getItemByNeedNo(pobj.actionBody.needNo);
    console.log(system.getResultSuccess(item));
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  async getItemByChannelNeedNo(pobj) {
    var item = await this.dao.getItemByChannelNeedNo(pobj.actionBody.needNo);
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  async needinfo2fq(pobj) {
    pobj.actionBody.needNo = await this.getBusUid("n");
    pobj.actionBody.uapp_id = pobj.appInfo.id;
    var needinfo = await this.dao.create(pobj.actionBody);
    var pobj = {
      "idempotentId": needinfo.needNo,
      "idempotentSource": needinfo.chanceType_code,
      "idempotentSourceName": pobj.appInfo.app_name + "_" + pobj.actionBody.chanceTypeName,
      "phone": needinfo.publishMobile,
      "remark": needinfo.notes,
      "customerName": needinfo.publishName
    };

    var rc = system.getObject("util.aliyunClient");
    var rtn = await rc.post("https://yunfuapi.gongsibao.com/crm/opportunity/submit", pobj);
    console.log(rtn)
    return system.getResultSuccess();
    // var opResultstr = await this.execlient.execPost(pobj, "https://yunfuapi-dev.gongsibao.com/crm/opportunity/submit");
    // opResult = JSON.parse(opResultstr.stdout)
    // if (opResultstr) {
    //   return system.getResultSuccess();
    // }
  }

  // intentionBizId
  // mobile
  // userName
  // description
  // area
  // type
  // ext
  async submitNeed(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5001, "intentionBizId不能为空");
    }
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    if (!actionBody.type) {
      return system.getResultFail(-5003, "type不能为空");
    }
    var ninfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (ninfo) {
      return system.getResultSuccess();
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: actionBody.intentionBizId,
      needNo: needNo,
      channelUserId: actionBody.mobile,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      city: actionBody.area,
      // disposeNotes: actionBody.ext,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      status: "wts"
    }
    if(nobj.channelTypeCode==7||nobj.channelTypeCode==5){
      nobj.province=nobj.city,
      nobj.city="";
    }
    await this.dao.create(nobj);
    return system.getResultSuccess();
  }

  /**
   * 工商H5 免费咨询
   * @param pobj
   * @param actionBody
   * @param req
   * @returns {Promise<{msg: *, data: *, status: *}|{msg: *, data: (*|null), status: number}>}
   */
  async submitNeedH5(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    var channelNeedNo = await this.getBusUid("i");
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    if (!actionBody.type) {
      return system.getResultFail(-5003, "type不能为空");
    }
    var ninfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (ninfo) {
      return system.getResultSuccess();
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: channelNeedNo,
      needNo: needNo,
      channelUserId: actionBody.mobile,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      city: actionBody.area,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      status: "wts"
    }
    if(nobj.channelTypeCode==7||nobj.channelTypeCode==5){
      nobj.province=nobj.city,
          nobj.city="";
    }
    await this.dao.create(nobj);
    return system.getResultSuccess();
  }

  async needClose(pobj, actionBody, req) {
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5005, "intentionBizId不能为空");
    }
    var needinfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (!needinfo) {
      return system.getResultFail(-5004, "需求不存在");
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultSuccess();
    } else {
      needinfo.status = "ygb";
      var self = this;
      await self.update(needinfo.dataValues);
      await self.needsolutionSve.abolishProgrammeByNeed(pobj);
      return system.getResultSuccess();
    }
  }

  async flowinfo(obj) {

  }

}
module.exports = NeedinfoService;

// var a=new NeedinfoService();
// var b=a.getItemByNeedNo({actionBody:{needNo:"N202004132334EjurnEr"}});