//工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
class RegAPI extends APIBase {
    constructor() {
        super();
        this.regCenterOrderSve = system.getObject("service.qcutils.regCenterOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        console.log("pobj",pobj)
        var opResult = null;
        switch (action_type) {
            case "regReceiveSolutionPayInfo"://接收reg方案状态及支付信息(方案支付后创建订单时调用)
                opResult = await this.regCenterOrderSve.regReceiveSolutionPayInfo(pobj);
                break;
            case "selectNeedInfo"://查询需求信息
                opResult = await this.regCenterOrderSve.selectNeedInfo(pobj);
                break;
            case "regOrderClose"://关闭订单
                opResult = await this.regCenterOrderSve.regOrderClose(pobj);
                break;
                
            case "regFeedbackSubmit"://接收需求反馈 百度reg 2.2
                opResult = await this.regCenterOrderSve.regFeedbackSubmit(pobj);
                break;
            case "getItemByChannelSolutionNo"://渠道方案号获取需求详情
                opResult = await this.regCenterOrderSve.getItemByChannelSolutionNo(pobj, pobj.actionBody, req);
                break;
            case "regOrderStatus"://接收订单状态推送 百度reg 2.3
                opResult = await this.regCenterOrderSve.regOrderStatus(pobj);
                break;
            case "addRegSalesmanInfo"://添加业务员信息，用于直接下单的reg订单
                opResult = await this.regCenterOrderSve.addRegSalesmanInfo(pobj);
                break;
            case "submitRegNeed"://提交需求 2.1
                opResult = await this.regCenterOrderSve.submitRegNeed(pobj, pobj.actionBody, req);
                break;
            case "getSolutionByChannelOrderNo"://根据渠道订单获取方案信息
                opResult = await this.regCenterOrderSve.getSolutionByChannelOrderNo(pobj, pobj.actionBody, req);
                break;
            case "regSubmitSolution"://方案提交
                opResult = await this.regCenterOrderSve.regSubmitSolution(pobj);
                break;
            case "updateSolution"://方案更新
                opResult = await this.regCenterOrderSve.updateSolution(pobj);
                break;
                
            case "regWriteCommunicationLog"://新增沟通记录
                opResult = await this.regCenterOrderSve.regWriteCommunicationLog(pobj);
                break;
            case "regQueryExpertCommunicationLogs"://获取沟通记录
                opResult = await this.regCenterOrderSve.regQueryExpertCommunicationLogs(pobj);
                break;
            case "regUpdateOrderStatus"://提交交付信息/修改订单状态
                opResult = await this.regCenterOrderSve.regUpdateOrderStatus(pobj);
                break;
            case "regNeedClose"://前端关闭reg需求及方案
                opResult = await this.regCenterOrderSve.regNeedClose(pobj);
                break;
            case "saveReginfo"://保存渠道方案及url
                opResult = await this.regCenterOrderSve.saveReginfo(pobj);
                break;
                
            case "getRegInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.regCenterOrderSve.reqCenterOrderApi(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = RegAPI;