const system = require("../system");
const moment = require('moment')
const settings = require("../../config/settings");
const md5 = require("MD5");
class AppServiceBase {
  constructor() {
    this.execClientNew = system.getObject("util.execClientNew");
    this.restClient = system.getObject("util.restClient");
    this.execClient = system.getObject("util.execClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  /**
   * 验证签名
   * @param {*} params 要验证的参数 
   * @param {*} app_key 应用的校验key
   */
  async verifySign(params, app_key) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
  }
  async restPostUrl(pobj, url) {
    var rtn = await this.restClient.execPost(pobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "restPost data is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  async execPostUrl(pobj, url) {
    var rtn = await this.execClient.execPost(pobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost data is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  /**
   * 带超时时间的post请求
   * @param {*} req 请求信息
   * @param {*} params 请求数据-json格式
   * @param {*} url 请求地址
   * @param {*} ContentType 请求头类型，默认application/json
   * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
   * @param {*} timeOut 超时时间
   */
  async execPostByTimeOut(req, params, url, ContentType, headData, timeOut = 60) {
    const result = await this.execClientNew.execPostTimeOutByBusiness('app.base', params, url, ContentType, headData, timeOut, req);
    return result;
  }
}
module.exports = AppServiceBase;
