const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
var moment = require('moment')
class DiagnosisService extends ServiceBase {
  constructor () {
    super("dbneed", ServiceBase.getDaoName(DiagnosisService));
  }

  async manualEvaluation (pobj) {
    var actionBody = pobj.actionBody;
    var diagnosisNeedNo = await this.getBusUid("n");
    if (!actionBody.mobile) {
      return system.getResultFail(-5004, "联系电话不能为空");
    }
    if (!actionBody.enterprise) {
      return system.getResultFail(-5005, "企业名称不能为空");
    }
    if (!actionBody.corporateType) {
      return system.getResultFail(-5006, "店铺类型不能为空");
    }
    if (!actionBody.diagnosisType) {
      return system.getResultFail(-5007, "诊断类型不能为空");
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      diagnosis_no: diagnosisNeedNo, // uuid
      channel_user_id: pobj.userInfo.channel_userid, // 用户id
      corporate_name: actionBody.enterprise, // 公司名称
      publish_mobile: actionBody.mobile, // 联系电话
      corporate_type: actionBody.corporateType, // 店铺类型
      diagnosis_type: actionBody.diagnosisType, // 诊断类型
      diagnosis_mode: actionBody.diagnosisMode, // 诊断方式，这里由channel项目调用带参数
      diagnosis_result: "rgshz", // 创建订单时 人工审核中 前台用
      status: "dcl", // 创建订单时 待处理 后台用
      main_class: actionBody.mainClass, // 运营后台-诊断详情-主营类目
      whether_company: actionBody.whetherCompany ? 1 : 0,
      qualifications_pic: actionBody.qualificationsPic,
      brand_pic: actionBody.brandPic,
      industry_pic: actionBody.industryPic
    }
    if (actionBody.diagnosisMode == "zn") {
      nobj.diagnosis_result = actionBody.checkResult.data.isPass == false ? "wtg" : "tg";
      nobj.status = "ywc"
      nobj.diagnosis_result_data = actionBody.checkResult;// 诊断方式为智能时 channel会传来诊断结果，记录快照
    }
    await this.dao.create(nobj);
    return system.getResultSuccess({ diagnosis_no: diagnosisNeedNo });
  }

  async diagnosisInfo (pobj) {
    var actionBody = pobj.actionBody;
    let query = {
      offset: ((actionBody.page - 1) * actionBody.pageSize) || 0,
      limit: actionBody.pageSize || 10,
      attributes: [
        "diagnosis_no",// 申请编号
        "corporate_name",// 公司名称
        "publish_mobile",// 联系人手机号
        "diagnosis_type_name",// 诊断类型
        "diagnosis_mode_name",// 诊断方式
        "diagnosis_result_name",// 诊断结果
        "updated_at"],// 修改时间
      order: [
        ["updated_at", "desc"]
      ]
    }
    let where = {}
    if (pobj.userInfo.channel_userid) {
      where.channel_user_Id = pobj.userInfo.channel_userid
    }
    if (actionBody.diagnosisNo) {
      where.diagnosis_no = { [this.db.Op.like]: `%${actionBody.diagnosisNo}%` }
    }
    if (actionBody.diagnosisTypeName) {
      where.diagnosis_type_name = { [this.db.Op.like]: `%${actionBody.diagnosisTypeName}%` }
    }
    if (actionBody.publishMobile) {
      where.publish_mobile = { [this.db.Op.like]: `%${actionBody.publishMobile}%` }
    }
    if (actionBody.status) {
      where.status = actionBody.status
    }
    if (actionBody.publishName) {
      where.publish_name = { [this.db.Op.like]: `%${actionBody.publishName}%` }
    }
    if (actionBody.corporateName) {
      where.corporate_name = { [this.db.Op.like]: `%${actionBody.corporateName}%` }
    }
    if (actionBody.stdate && actionBody.endate) {
      where.updated_at = { [this.db.Op.between]: [actionBody.stdate, actionBody.endate] }
    }
    if (actionBody.corporateTypeName) {
      where.corporate_type_name = actionBody.corporateTypeName
    }
    if (Object.keys(where).length > 0) {
      query.where = where
    }
    let res = await this.dao.findAndCountAll(query)
    return system.getResultSuccess(res);
  }
  // 过滤数组 筛选出选择过的资质
  checkIsChoice(arr) {
    if(!arr) {
        return [];
    }
    // 返回经过处理 为客户选中的数组
    var newArr =  arr.filter((obj) => {
        let flag = true
        return obj.isChoice == false;
    });
    // 删掉原来数组中选选过的
    for(var i = 0;i < arr.length;) {
        console.log(arr[i])
        if(arr[i].isChoice == false) {
            arr.splice(i,1)
        } else {
            ++i
        }
    }
    return newArr;
  }
  async diagnosisDetail(pobj) {
    if(!pobj.actionBody.diagnosisNo) {
        return system.getResultFail(-5008, "诊断单号不能为空 ");
    }
    let diagnosisResult = await this.dao.findOneByDiagnosisNo(pobj.actionBody.diagnosisNo)
    diagnosisResult.needQualifications_pic = this.checkIsChoice(diagnosisResult.qualifications_pic);
    diagnosisResult.needBrand_pic = this.checkIsChoice(diagnosisResult.brand_pic);
    diagnosisResult.needIndustry_pic = this.checkIsChoice(diagnosisResult.industry_pic);
    return system.getResultSuccess(diagnosisResult);
  }

  async enterpriseInfo (pobj) {
    let diagnosisResult = await this.dao.findOneOrderByCreateAt(pobj.userInfo.channel_userid)
    if (diagnosisResult) {
      // 2020 0817 lin 新增注释 这里做判断的目的 因为diagnosis_result字段可能还包含rgshz（人工审核中）。所以返回前端要做下处理
      diagnosisResult.auth_result_name = "未认证"
      if (diagnosisResult.diagnosis_result == "tg") {
        diagnosisResult.auth_result_name = "已认证"
      }
      return system.getResultSuccess(diagnosisResult);
    } else {
      return system.getResultSuccess();
    }
  }
}
module.exports = DiagnosisService;