const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
var moment = require('moment')
class NeedinfoService extends ServiceBase {
  constructor () {
    super("dbneed", ServiceBase.getDaoName(NeedinfoService));
    this.execlient = system.getObject("util.execClient");
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.needinfofqDao = system.getObject("db.dbneed.needinfofqDao");
  }
  async getItemByNeedNo (pobj) {
    var item = await this.dao.getItemByNeedNo(pobj.actionBody.needNo);
    console.log(system.getResultSuccess(item));
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    return system.getResultSuccess(item);
  }

  async opSubmitNeed (pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    // if (!actionBody.type) {
    //   return system.getResultFail(-5003, "type不能为空");
    // }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: needNo, // 2020 0807 lin 修改内容 渠道需求号改为企服通需求号 不再单独获取新的uuid
      needNo: needNo,
      channelUserId: pobj.userInfo.channel_userid,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      notes: actionBody.description,// 2020 0814 lin新增 插入备注，格式：公司注册，商标注册。目前用来作为抖音的打包下需求功能。用来展示在个人中心/运营后台需求列表
      city: actionBody.area,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      appName: actionBody.appName,
      serviceProductId: actionBody.service_product_id,
      status: "wts"
    }
    var r = await this.dao.create(nobj);
    return system.getResultSuccess(r);
  }

  async opNeedList (pobj, actionBody, req) {
    // 时间段，分页，排序，需求状态 条件展示未做
    let statusDic = ['wts', 'yts', 'ygj', 'ygb', 'ycd']
    console.log(pobj);
    console.log(pobj.actionBody);
    var sobj = {
      search: {
        channelUserId: pobj.userInfo.channel_userid
      },
      pageInfo: {
        pageNo: Number(actionBody.pageNumber) || 1,
        pageSize: Number(actionBody.pageSize) || 10
      }
    }
    // if (actionBody.consultType) {
    //   sobj.search.consult_type = actionBody.consultType;
    // }
    // 2020 0924 lin 修改之前查询条件consultType 为 channelTypeCode
    // 注意这里 对应数据库的是typeCode 但传来的参数是consultType
    if (actionBody.consultType) {
      sobj.search.typeCode = actionBody.consultType;
    }
    // liang  追加筛选条件
    if (actionBody.status && statusDic.indexOf(actionBody.status) != -1) {
      sobj.search.status = actionBody.status;
    }
    if (actionBody.needNo) {
      sobj.search.needNo = actionBody.needNo
    }
    if (actionBody.publishName) {
      sobj.search.publishName = actionBody.publishName
    }
    if (actionBody.publishMobile) {
      sobj.search.publishMobile = actionBody.publishMobile
    }
    console.log(actionBody)
    if (actionBody.stdate && actionBody.endate) {
      sobj.search.updated_at = [actionBody.stdate, actionBody.endate]
    }
    var r = await this.dao.findAndCountAll(sobj);
    return system.getResultSuccess(r);
  }

  async opNeedListBak (pobj, actionBody, req) {
    let statusDic = ['wts', 'yts', 'ygj', 'ygb', 'ycd']
    var sobj = {
      search: {
      },
      pageInfo: {
        pageNo: Number(actionBody.pageNo) || 1,
        pageSize: Number(actionBody.pageSize) || 10
      }
    }
    if (pobj.appInfo.uapp_id) {
      sobj.search.uapp_id = pobj.appInfo.uapp_id
    }
    if (actionBody.typeCode) {
      sobj.search.typeCode = actionBody.typeCode;
    }
    if (actionBody.status && statusDic.indexOf(actionBody.status) != -1) {
      sobj.search.status = actionBody.status;
    }
    if (actionBody.needNo) {
      sobj.search.needNo = actionBody.needNo
    }
    if (actionBody.publishName) {
      sobj.search.publishName = actionBody.publishName
    }
    if (actionBody.publishMobile) {
      sobj.search.publishMobile = actionBody.publishMobile
    }
    if (actionBody.stdate && actionBody.endate) {
      sobj.search.updated_at = [actionBody.stdate, actionBody.endate]
    }
    var r = await this.dao.findAndCountAll(sobj);
    return system.getResultSuccess(r);
  }

  async opNeedClose (pobj, actionBody, req) {
    var needinfo = await this.findOne({ channelNeedNo: actionBody.needNo });
    if (!needinfo) {
      return system.getResultFail(-5004, "需求不存在");
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultSuccess();
    } else {
      needinfo.status = "ygb";
      var self = this;
      await self.update(needinfo.dataValues);
      return system.getResultSuccess();
    }
  }

  /**
   * 各渠道需求统计
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByUappId(pobj){
    let ac = pobj.actionBody;
    let sql = `SELECT uapp_id,count(*) count,DATE_FORMAT(DATE_ADD(created_at,INTERVAL 8 HOUR),'%Y-%m-%d') time FROM n_need_info WHERE deleted_at is null AND (channelTypeName <> "商标交易" or channelTypeName is not null)`;
    let whereParam = {};
    if(ac.start&&ac.end){
      sql += ` AND created_at >= :start AND created_at <= :end`;
      whereParam.start =await this.getTimeSubtraction(ac.start);
      whereParam.end =await this.getTimeSubtraction(ac.end);
    }
    if(ac.type_name){
      sql += ` AND typeName = :type_name`;
      whereParam.type_name = ac.type_name;
    }
    if(ac.status){
      sql += ` AND status = :status`;
      whereParam.status = ac.status;
    }
    sql += ` GROUP BY uapp_id,DATE_FORMAT(DATE_ADD(created_at,INTERVAL 8 HOUR),'%Y-%m-%d') ORDER BY created_at ASC`
    let result = await this.customQuery(sql,whereParam);
    return system.getResultSuccess(result);
  }

  /**
   * 需求统计漏斗图
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedFunnelStatistics(pobj){
      let ac = pobj.actionBody;
      let sql = `select count(*) count from n_need_info where deleted_at is null AND (channelTypeName <> "商标交易" or channelTypeName is not null) `;
      let sql2 = sql + ` and status in('ygj','ygb','ycd')`;
      let sql3 = sql + ` and status = 'ycd'`;
      let whereParams = {};
      if (ac.start&&ac.end){
        sql += ` AND created_at >= :start and created_at <= :end`;
        sql2 += ` AND created_at >= :start and created_at <= :end`;
        sql3 += ` AND created_at >= :start and created_at <= :end`;
        whereParams.start =await this.getTimeSubtraction(ac.start);
        whereParams.end =await this.getTimeSubtraction(ac.end);
      }
      if(ac.uapp_id){
        sql += ` and uapp_id = :uapp_id`;
        sql2 +=  ` and uapp_id = :uapp_id`;
        sql3 +=  ` and uapp_id = :uapp_id`;
        whereParams.uapp_id = ac.uapp_id;
      }
      if(ac.type_name){
        sql += ` and typeName = :type_name`;
        sql2 += ` and typeName = :type_name`;
        sql3 += ` and typeName = :type_name`;
        whereParams.type_name = ac.type_name;
      }
      let total = await this.customQuery(sql,whereParams);
      let middle = await this.customQuery(sql2,whereParams);
      let finish = await this.customQuery(sql3,whereParams);
      let result = {
        total:total[0].count,
        middle:middle[0].count,
        finish:finish[0].count
      }
      return system.getResult(result);
  }

  /**
   * 需求统计（产品类型）
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByProduct(pobj){
    let ac = pobj.actionBody;
    let sql = `select typeName typeCode,uapp_id,count(*) count from n_need_info where typeName is not null AND (channelTypeName <> "商标交易" or channelTypeName is not null) `;
    let whereParams = {};
    if(ac.start&&ac.end){
      sql += ` and created_at >= :start and created_at <= :end `;
      whereParams.start = await this.getTimeSubtraction(ac.start);
      whereParams.end = await this.getTimeSubtraction(ac.end);
    }
    sql += ` GROUP BY typeName,uapp_id`;
    let result = await this.customQuery(sql,whereParams);
    return system.getResultSuccess(result);
  }

  /**
   * 需求统计（产品类型） 总数
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByChannel(pobj){
    let ac = pobj.actionBody;
    let sql = `select typeName typeCode,uapp_id,count(*) count from n_need_info where typeName is not null AND (channelTypeName <> "商标交易" or channelTypeName is not null) `;
    let whereParams = {};
    if(ac.start&&ac.end){
      sql += ` and created_at >= :start and created_at <= :end `;
      whereParams.start = await this.getTimeSubtraction(ac.start);
      whereParams.end = await this.getTimeSubtraction(ac.end);
    }
    sql += ` GROUP BY uapp_id,typeName`;
    let result = await this.customQuery(sql,whereParams);
    return system.getResultSuccess(result);
  }

  /**
   * 需求统计（获取产品类型）
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedProductType(pobj){
    let sql = `select typeName,count(*) count from n_need_info where typeName is not null AND (channelTypeName <> "商标交易" or channelTypeName is not null)  GROUP BY typeName`;
    let result = await this.customQuery(sql);
    let typeNames = result.map(item =>{
      return item.typeName;
    })
    return system.getResultSuccess(typeNames);
  }

  /**
   * 需求统计（区域维度）
   * @param pobj
   * @returns {Promise<void>}
   */
  async getStatisticsByCity(pobj){
    let ac = pobj.actionBody;
    let sql = `select typeName typeCode,province,count(*) count from n_need_info where province is not null and typeCode is not null AND (channelTypeName <> "商标交易" or channelTypeName is not null) `;
    let whereParams = {};
    if(ac.start&&ac.end){
      sql += ` and created_at >= :start and created_at <= :end `;
      whereParams.start = await this.getTimeSubtraction(ac.start);
      whereParams.end = await this.getTimeSubtraction(ac.end);
    }
    if(ac.type_name){
      sql += ` and typeName = :typeName`;
      whereParams.typeName = ac.type_name;
    }
    if(ac.uapp_id){
      sql += ` and uapp_id = :uapp_id`;
      whereParams.uapp_id = ac.uapp_id;
    }
    sql += ` GROUP BY province,typeName`;
    let result = await this.customQuery(sql,whereParams);
    return system.getResultSuccess(result);
  }

  /**
   * 需求对比
   * @param pobj
   * @returns {Promise<void>}
   */
  async getNeedComparison(pobj){
    let ab =pobj.actionBody;
    let sql1 = `select count(DISTINCT(channelNeedNo)) count from n_need_info where deleted_at is null AND (channelTypeName <> "商标交易" or channelTypeName is not null) `;
    let sql2 = `select count(DISTINCT(b.channelNeedNo)) count from n_need_info b  where b.deleted_at is null and b.status = 'ycd' AND (b.channelTypeName <> "商标交易" or b.channelTypeName is not  null)`;
    let whereParams = {};
    if(ab.startNow&&ab.endNow){
      sql1 += ` and created_at >= :start and created_at <= :end`;
      sql2 += ` and b.created_at >= :start and b.created_at <= :end`;
      whereParams.start = await this.getTimeSubtraction(ab.startNow);
      whereParams.end = await this.getTimeSubtraction(ab.endNow);
    }
    if(ab.uapp_id){
      sql1 += ` and uapp_id = :uapp_id`;
      sql2 +=  ` and b.uapp_id = :uapp_id`;
      whereParams.uapp_id = ab.uapp_id;
    }
    if(ab.type_name){
      sql1 += ` and typeName = :type_name`;
      sql2 += ` and b.typename = :type_name`;
      whereParams.type_name = ab.type_name;
    }
    let totalRet1 = await this.customQuery(sql1,whereParams);
    let orderRet1 = await this.customQuery(sql2,whereParams);
    if(ab.startLast&&ab.endLast){
      whereParams.start = await this.getTimeSubtraction(ab.startLast);
      whereParams.end = await this.getTimeSubtraction(ab.endLast);
    }
    let totalRet2 = await this.customQuery(sql1,whereParams);
    let orderRet2 = await this.customQuery(sql2,whereParams);
    let result ={
      now:{
        total:totalRet1[0].count,
        order:orderRet1[0].count
      },
      last:{
        total:totalRet2[0].count,
        order:orderRet2[0].count
      }
    }
    return system.getResultSuccess(result);
  }

  /**
   * 获取需求列表 启服通展板
   * @param pobj
   * @param actionBody
   * @returns {Promise<void>}
   */
  async getNeedComparisonList(pobj,actionBody){
    let pageSize = Number(actionBody.pageSize || 20);
    let pageIndex = Number(actionBody.pageIndex || 1);
    let from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    if (pageSize > 50) {
      pageSize = 50;
    }
    let tag = actionBody.tag;
    //需求列表
    let needSql = `select DISTINCT(a.channelNeedNo),b.app_name,a.needNo,a.typeName,a.province,a.city,a.publishContent,a.publishName,a.publishMobile,a.statusName,a.created_at from center_order.n_need_info a left join center_app.p_app b on a.uapp_id = b.uapp_id where a.deleted_at is null AND (a.channelTypeName <> "商标交易" or a.channelTypeName is not null) `;
    //需求总数
    let needTotalSql = `select count(DISTINCT(a.channelNeedNo)) count from center_order.n_need_info a left join center_app.p_app b on a.uapp_id = b.uapp_id where a.deleted_at is null AND (a.channelTypeName <> "商标交易" or a.channelTypeName is not null) `;
    //需求成单
    let needToOrderSql = `select DISTINCT(b.channelNeedNo),c.app_name,b.channelNeedNo,b.province,b.city,b.typeName,b.publishContent,b.publishName,b.publishMobile,b.statusName,b.created_at from center_order.n_need_info b inner join center_app.p_app c on b.uapp_id = c.uapp_id  where b.deleted_at is null and b.status = 'ycd' AND (b.channelTypeName <> "商标交易" or b.channelTypeName is not null) `;
    //需求成单总数
    let needToOrderTotalSql = `select count(DISTINCT(b.channelNeedNo)) count from n_need_info b  where b.deleted_at is null and b.status = 'ycd' AND (b.channelTypeName <> "商标交易" or b.channelTypeName is not null) `;
    let whereParams = {};
    if(actionBody.start&&actionBody.end){
      needSql += ` and a.created_at >= :start and a.created_at <= :end`;
      needTotalSql += ` and a.created_at >= :start and a.created_at <= :end`;
      needToOrderSql += ` and b.created_at >= :start and b.created_at <= :end`;
      needToOrderTotalSql += ` and b.created_at >= :start and b.created_at <= :end`;
      whereParams.start = await this.getTimeSubtraction(actionBody.start);
      whereParams.end = await this.getTimeSubtraction(actionBody.end);
    }

    if(actionBody.uapp_id){
      needSql += ` and a.uapp_id = :uapp_id`;
      needTotalSql +=  ` and a.uapp_id = :uapp_id`;
      needToOrderSql +=  ` and b.uapp_id = :uapp_id`;
      needToOrderTotalSql +=  ` and b.uapp_id = :uapp_id`;
      whereParams.uapp_id = actionBody.uapp_id;
    }
    if(actionBody.type_name){
      needSql += ` and a.typeName = :type_name`;
      needTotalSql += ` and a.typeName = :type_name`;
      needToOrderSql += ` and b.typeName = :type_name`;
      needToOrderTotalSql += ` and b.typeName = :type_name`;
      whereParams.type_name = actionBody.type_name;
    }
    if(actionBody.status){
      needSql += ` and a.status = :status`;
      needTotalSql += ` and a.status = :status`;
      needToOrderSql += ` and b.status = :status`;
      needToOrderTotalSql += ` and b.status = :status`;
      whereParams.status = actionBody.status;
    }
    if(actionBody.fuzzy_code){
      needSql += ` and ( a.needNo like :fuzzy_code or a.channelNeedNo like :fuzzy_code or a.publishMobile like :fuzzy_code)`;
      needTotalSql += ` and ( a.needNo like :fuzzy_code or a.channelNeedNo like :fuzzy_code or a.publishMobile like :fuzzy_code)`;
      needToOrderSql += ` and ( b.needNo like :fuzzy_code or b.channelNeedNo like :fuzzy_code or b.publishMobile like :fuzzy_code)`;
      needToOrderTotalSql += ` and ( b.needNo like :fuzzy_code or b.channelNeedNo like :fuzzy_code or b.publishMobile like :fuzzy_code)`;
      whereParams.fuzzy_code = "%"+actionBody.fuzzy_code+"%";
    }
    needSql += `  order by a.created_at desc`;
    needToOrderSql += `  order by b.created_at desc`;
    if(pageSize != -1){
      needSql += ` limit ${pageSize} offset ${from}`;
      needToOrderSql += ` limit ${pageSize} offset ${from}`;
    }
    let result,total;
    if(tag == 'need'){
      result = await this.customQuery(needSql,whereParams);
      total = await this.customQuery(needTotalSql,whereParams);
    }
    if(tag == 'needToOrder'){
      result = await this.customQuery(needToOrderSql,whereParams);
      total = await this.customQuery(needToOrderTotalSql,whereParams);
    }
    let data = {
      total:total[0].count,
      rows:result
    }
    return system.getResult(data);
  }

  /**
   * 修改需求商机推送状态
   * @param actionBody
   * @returns {Promise<void>}
   */
  async updateNeedPushStatus(actionBody) {
        let channelNeedNo = actionBody.intentionBizId;
        let setObj = {
            status: 'yts',
            statusName: "已推送"
        }
        let whereObj = {
            where: {
                channelNeedNo: channelNeedNo
            }
        }
        if (channelNeedNo) {
            this.dao.updateByWhere(setObj, whereObj);
        }
        return system.getResultSuccess();
    }

  /**
   * 同步蜂擎需求商机
   * @returns {Promise<void>}
   */
  async syncNeedBusiness() {
    //获取 need_info_fq 未处理的需求
    let fqNeeds = await this.needinfofqDao.getAllNeeds()
    let ids = [];
    let needDict = {};
    for (let i = 0; i < fqNeeds.length; i++) {
      ids.push(fqNeeds[i].channelNeedNo);
      needDict[fqNeeds[i].channelNeedNo] =  fqNeeds[i].status;
    }
    //根据ids 获取企服通需求
    let needs = await this.needinfoDao.getNeedsByIds(ids);
    let setObj = [];
    let existIds = [];
    let ids1 = [];
    let ids2 = [];
    let ids3 = [];
    //已经存在的需求，更改状态
    for(let i = 0;i < needs.length; i++){
      let need = needs[i];
      let obj = {
        id:need.id,
      }
      if(needDict[need.channelNeedNo] == 1){
        obj.status = 'ygj';
        obj.statusName = '已跟进';
        ids1.push(need.channelNeedNo);
      }
      if(needDict[need.channelNeedNo] == 2){
        obj.status = 'ygb';
        obj.statusName = '已关闭';
        ids2.push(need.channelNeedNo);
      }
      if(needDict[need.channelNeedNo] == 3){
        obj.status = 'ycd';
        obj.statusName = '已成单';
        ids3.push(need.channelNeedNo);
      }
      setObj.push(obj);
      existIds.push(need.channelNeedNo);
    }
    // 不存在的订单 添加到企服通
    let createObj = [];
    let setFqObj1 = [];
    let setFqObj2 = [];
    for(let i =0;i<fqNeeds.length;i++){
      let fqNeed = fqNeeds[i];
      if(!existIds.includes(fqNeed.channelNeedNo)){
        let obj = {
          channelNeedNo:fqNeed.channelNeedNo,
          city:fqNeed.city || "",
          province:fqNeed.province,
          publishMobile:fqNeed.publishMobile,
          disposeNotes:fqNeed.disposeNotes,
          typeCode:fqNeed.typeCode,
          created_at:fqNeed.created_at
        }
        if(fqNeed.status == 1){
          obj.status = 'ygj';
          obj.statusName = '已跟进';
        }
        if(fqNeed.status == 2){
          obj.status = 'ygb';
          obj.statusName = '已关闭';
        }
        if(fqNeed.status == 3){
          obj.status = 'ycd';
          obj.statusName = '已成单';
        }
        if(fqNeed.status == 4 || fqNeed.status == 0){
          obj.status = 'yts';
          obj.statusName = '已推送';
        }
        if(['360_icp ','360_edi','360_sbzc'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 50;
        }
        if(['baidu_edi','baidu_gsreg','baidu_icp','baidu_radiotv','baidu_wangwen'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 44;
        }
        if(['edi_ali','ic_ali','icp_ali','tm_ali','tmd_ali'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 18;
        }
        if(['youke'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 40;
        }
        if(['tm_jdyun'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 31;
        }
        if(['tm_bw'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 35;
        }
        if(['tm_1688'].includes(fqNeed.sourceCode)){
          obj.uapp_id = 0;
        }
        if(!setFqObj2.includes(fqNeed.channelNeedNo)){
          createObj.push(obj);
          setFqObj2.push(fqNeed.channelNeedNo);
        }
      }else {
        setFqObj1.push(fqNeed.channelNeedNo);
      }
    }

    //企服通 批量更新状态
    let updateRet =null;
    if(setObj.length>0){
      // updateRet = await this.needinfoDao.bulkUpdate(setObj);
      if(ids1.length>0){
        updateRet = await this.needinfoDao.bulkUpdateStatus('ygj','已跟进',ids1);
      }
      if(ids2.length>0){
        updateRet = await this.needinfoDao.bulkUpdateStatus('ygb','已关闭',ids2);
      }
      if(ids3.length>0){
        updateRet = await this.needinfoDao.bulkUpdateStatus('ycd','已成单',ids3);
      }
      if(updateRet.length > 0){
        updateRet = await this.needinfofqDao.bulkUpdate(setFqObj1);
      }
    }
    //企服通 批量添加
    if(createObj.length>0){
      updateRet = await this.needinfoDao.bulkCreate(createObj);
      if(updateRet.length >0 ){
        updateRet = await this.needinfofqDao.bulkUpdate(setFqObj2);
      }
    }
    return system.getResult(updateRet)
  }
}
module.exports = NeedinfoService;

// var a=new NeedinfoService();
// var b=a.getItemByChannelSolutionNo({actionBody:{bizId:"1593141330846"}});