var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcpAPI extends APIBase {
    constructor() {
        super();
        // this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
        this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            // case "submitIcpProgramme"://icp方案提交
            //     opResult = await this.needsolutionSve.submitIcpProgramme(pobj);
            //     break;
            // case "submitIcpMaterial"://icp材料提交
            //     opResult = await this.needsolutionSve.submitIcpMaterial(pobj);
            //     break;
            // case "acceptIcpPartnerNotification"://icp通知状态变更
            //     opResult = await this.needsolutionSve.acceptIcpPartnerNotification(pobj);
            //     break;
            // case "abolishIcpProgramme"://服务商icp方案关闭
            //     opResult = await this.needsolutionSve.abolishIcpProgramme(pobj);
            //     break;
            // case "getIcpProgrammeDetail"://获取icp方案
            //     opResult = await this.needsolutionSve.getIcpProgrammeDetail(pobj);
            //     break;
            // case "getNeedSolutionDetailByUser"://获取方案详情
            //     opResult = await this.needsolutionSve.getNeedSolutionDetailByUser(pobj);
            //     break;
            // case "receiveIcpStatusNotify"://接收渠道方案状态变更通知
            //     opResult = await this.needsolutionSve.receiveIcpStatusNotify(pobj);
            //     break;
            // case "receiveIcpFeedback"://接收icp用户方案反馈
            //     opResult = await this.needsolutionSve.receiveIcpFeedback(pobj);
            //     break;
            // case "getIcpProgrammeDetail"://获取方案详情（内部调用）
            //     opResult = await this.needsolutionSve.getIcpProgrammeDetail(pobj);
            //     break;
            // case "getProgrammeInfoByChannelNeedNo"://获取需求方案列表
            //     opResult = await this.needsolutionSve.getProgrammeInfoByChannelNeedNo(pobj);
            //     break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcpAPI;