var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcAPI extends APIBase {
    constructor() {
        super();
        this.opNeedInfoSve = system.getObject("service.dbneed.opneedinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "opSubmitNeed"://提交需求 2020 0807 lin 新增 
                opResult = await this.opNeedInfoSve.opSubmitNeed(pobj, pobj.actionBody, req);
                break;
            case "opNeedList"://需求列表
                opResult = await this.opNeedInfoSve.opNeedList(pobj, pobj.actionBody);
                break;
            case "opNeedClose"://关闭需求
                opResult = await this.opNeedInfoSve.opNeedClose(pobj, pobj.actionBody, req);
                break;
            case "opGetItemByNeedNo"://获取需求详情
                opResult = await this.needinfoSve.getItemByNeedNo(pobj);
                break;
            case "getStatisticsByUappId":
                opResult = await this.opNeedInfoSve.getStatisticsByUappId(pobj);
                break;
            case "getStatisticsByProduct":
                opResult = await this.opNeedInfoSve.getStatisticsByProduct(pobj);
                break;
            case "getNeedProductType":
                opResult = await this.opNeedInfoSve.getNeedProductType(pobj);
                break;
            case "getStatisticsByArea":
                opResult = await this.opNeedInfoSve.getStatisticsByCity(pobj);
                break;
            case "getNeedFunnelStatistics":
                opResult = await this.opNeedInfoSve.getNeedFunnelStatistics(pobj);
                break;
            case "getNeedComparison":
                opResult = await this.opNeedInfoSve.getNeedComparison(pobj);
                break;
            case "getNeedComparisonList":
                opResult = await this.opNeedInfoSve.getNeedComparisonList(pobj,pobj.actionBody);
                break;
            case "updateNeedPushStatus":
                opResult = await this.opNeedInfoSve.updateNeedPushStatus(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcAPI;