const system = require("../../../system");
const Dao = require("../../dao.base");
class FlowLogDao extends Dao {
  constructor() {
    super(Dao.getModelName(FlowLogDao));
  }
  async getlogListBySourceOrderNo(sourceOrderNo) {
    return await this.model.findAll({
      where: {
        sourceOrderNo: sourceOrderNo,
        isShow: 1
      },
      order: [["id", 'desc']],
      attributes: [
        "opContent",
        "created_at"],
      raw: true
    });
  }
}
module.exports = FlowLogDao;
