const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderinfo", {                                                                                                                                                                      
    uapp_id             :DataTypes.INTEGER,//     
    // solutionId          :DataTypes.STRING(128),//  方案ID 
    orderNo             :DataTypes.STRING(128),//  订单号         
    channelServiceNo    :DataTypes.STRING(128),//  渠道服务单号     
    serviceOrderNo      :DataTypes.STRING(128),//  服务单号                                                                                                                                                                               
    channelOrderNo      :DataTypes.STRING(128),//  渠道订单号（页面中列表中显示该单号）
    channelNeedNo       :DataTypes.STRING(128), //渠道需求号（页面中列表中显示该需求号）
    needNo              :DataTypes.STRING(128), //需求号--用于服务商或需求表中创建订单
    channelUserId       :DataTypes.STRING(64),         //  渠道用户ID   
    ownerUserId         :DataTypes.STRING(20),//   拥有渠道用户ID   
    payTime             :DataTypes.DATE,//  渠道有支付时间则用渠道的支付时间
    quantity            :DataTypes.INTEGER,//  订单数量（即产品的倍数，默认值为1）                                                                                                                          
    serviceQuantity     :DataTypes.INTEGER,//  订单服务数量（即与订单数量相对应）         
    orderStatusName  :DataTypes.STRING(50),//                                                                                                                                
    orderStatus      :{
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("orderStatus", val);
        this.setDataValue("orderStatusName", uiconfig.config.pdict.order_status[val]);
      }
    },// 订单状态: 1: 待付款, 2: 已付款, 4: 服务中, 8: 已完成, 16: 已退款, 32: 已作废
    totalSum            :DataTypes.DECIMAL(12, 2),//  订单总额(产品价格×优惠费率×订单件数)                                                                                                                                    
    payTotalSum         :DataTypes.DECIMAL(12, 2),//  订单付款总额
    refundSum           :DataTypes.DECIMAL(12, 2),//  退款金额
    refundTime          :DataTypes.DATE, //2020/6/17 lin新增 退款时间 
    totalServiceCharge  :DataTypes.DECIMAL(12, 2),//  服务费总额（产品配置的服务费*订单件数）                                                                                                                                
    totalPublicExpense  :DataTypes.DECIMAL(12, 2),//  官费总额（产品配置的官费*订单件数）   
    totalProfitSum      :DataTypes.DECIMAL(12, 2),//  订单毛利润总额（订单总额-官费总额）  
    totalDiscounts      :DataTypes.DECIMAL(12, 2),//  优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                                                                                                                                                               
    pfProfitSum         :DataTypes.DECIMAL(12, 2),//  订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                  
    channelProfitSum    :DataTypes.DECIMAL(12, 2),//  订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)                                                                                               
    pfSettleProfit      :DataTypes.INTEGER,//  平台结算渠道利润,0否，1是  
    invoiceApplyStatus  :DataTypes.STRING(10),//  发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                          
    opNotes             :DataTypes.STRING,//  备注                                                                                                                                                                                    
    notes               :DataTypes.STRING,//  备注     
    isSolution          :DataTypes.INTEGER,// 是否有方案，0无，1有
    isPushNum            :DataTypes.INTEGER,//  推送次数   
    pushStatus            :DataTypes.INTEGER,//  推送状态0待推送2推送失败3已成功推送   
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updated_at: true,// 2020 0618 lin修改 
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_info',
      validate: {

      },
      indexes: [      
      ]
    });
}
