const system = require("../../../system");
const AppBase = require("../../app.base");
var settings = require("../../../../config/settings");

class Push360Service extends AppBase{
    constructor() {
        super()
        this.ordercontactsDao = system.getObject("db.dbcorder.ordercontactsDao");
        this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
        this.push360Url = settings.push360Url();
        this.auth360Url = settings.auth360Url();
    }

    //推送数据至360
    async pushTmStatus(actionBody,req) {
        let status = 30;
        let sub_status = 5;
        //待递交
        if (actionBody.tmStatus == "WAITCOMMIT" || actionBody.tmStatus == "ddj") {
            sub_status = 6;
        }
        //已递交
        if (actionBody.tmStatus == "ROBOT" || actionBody.tmStatus == "ROBOTPAY" || actionBody.tmStatus == "ydj") {
            sub_status = 7;
        }
        if (['1','2','3','5','6','9'].includes(actionBody.tmStatus)) {
            sub_status = 7;
        }
        //已完成
        if (actionBody.tmStatus == "RECVCOMMIT" || ['4','7','8','12','13'].includes(actionBody.tmStatus) ) {
            sub_status = 8;
            status = 40;
        }
        let order_id = actionBody.orderNo;
        var result, pushObj, url;
        try {
            let rtn = await this.execClient.exec360GetToken(this.auth360Url)
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "restPost data is empty");
            }
            let tokenResult = JSON.parse(rtn.stdout);
            let token = tokenResult.access_token;
            url = this.push360Url + 'api/v1/eshop/GsbOrderUpdate?token=' + token;
            pushObj = {
                order_id: order_id,
                status: status,
                sub_status:sub_status || 5
            }
            result = await this.execPostByTimeOut(null,pushObj, url);
            if (result.status != 0) {
                return result;
            }
            if (result.data.code != 200) {
                return result.data;
            }
            return system.getResultSuccess(result.data.data);
        } catch (e) {
            this.execClientNew.execLogs({
                opTitle:"360订单状态推送",
                params:actionBody.orderNo,
                identifyCode: "360TmStatus",
                resultInfo:"",
                errorInfo: e.stack
            })
            return system.getResultFail(-500, JSON.stringify(e.stack));
        }
    }

    //发送短信
    async sendMessage(actionBody) {
        try {
            let orderNo = actionBody.orderNo;
            if(!actionBody.registNumInfo){
                return system.getResultFail(-1,'')
            }
            if(!actionBody.officialInfo){
                return system.getResultFail(-1,'')
            }
            //获取联系人信息
            let item = await this.ordercontactsDao.getItemByOrderNo(actionBody.orderNo);
            let deliveryInfo = actionBody.deliveryInfo;
            if (!item) {
                return system.getResultFail(-1, '获取联系人信息失败');
            }
            let mobile = item.mobile;//联系人手机号
            let tmRegistNum = actionBody.registNumInfo.tmRegistNum;//申请号
            let tmName = deliveryInfo.tm.tmName;//商标名称
            let uploadFileName = actionBody.officialInfo.uploadFileName;//文件名
            let oneNcl = deliveryInfo.nclones[0].code;//大类
            let templateId = 1;
            // let failType = {
            //     "2": "商标注册申请补正通知书",
            //     "4": "商标注册申请不予受理通知书",
            //     "5": "商标注册同日申请补送使用证据通知书",
            //     "7": "商标驳回通知书",
            //     "8": "商标部分驳回通知书",
            //     "201": "超时未补正"
            // }
            //
            // if (failType.hasOwnProperty(actionBody.tmStatus)) {
            //     templateId = 2;
            // }

            let rtn = await this.execClient.exec360GetToken(this.auth360Url)
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "restPost data is empty");
            }
            let tokenResult = JSON.parse(rtn.stdout);
            let token = tokenResult.access_token;
            let url = this.push360Url + 'api/v1/GsbSendsms';
            let params = tmName + "|" + oneNcl + "|" + tmRegistNum + "|" + uploadFileName;
            let subData = "token=" + token + "&mobile=" + mobile + "&templated=" + templateId + "&replaceContent=" + params;
            let result = await this.execClient.execGet(subData, url);
            this.execClientNew.execLogs({
                opTitle:"360短信推送",
                params:params,
                identifyCode: "360Message",
                resultInfo:result.data,
                errorInfo: ""
            })
            return system.getResultSuccess()
        } catch (e) {
            this.execClientNew.execLogs({
                opTitle:"360短信推送",
                params:actionBody.orderNo,
                identifyCode: "360Message",
                resultInfo:"",
                errorInfo: e.stack
            })
            return system.getResultFail(-500, JSON.stringify(e.stack));
        }
    }
}

module.exports = Push360Service;
