const system = require("../../../system");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
//内部通知调用
class InternalCallsNotifyService {
  constructor() {
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.delivery_status = {
      "dqrfa": "待确认方案",
      "fabtg": "方案不通过",
      "dfwsfw": "待服务",
      "dsccl": "待上传材料",
      "dsh": "待审核",
      "ddj": "待递交",
      "ydj": "已递交",
      "ywc": "已完成"
    };
    this.statusContrast = {
      "WAITCONFIRM": { name: "待确认方案", value: "dqrfa" },
      "CONFIRMFAIL": { name: "方案不通过", value: "fabtg" },
      "READY": { name: "待上传材料", value: "dsccl" },
      "WAITCOMMIT": { name: "待递交", value: "ddj" },
      "WAITARTIFICIALEXAMINE": { name: "待审核", value: "dsh" },
      "DOCFINISH": { name: "待审核", value: "dsh" },
      "AWAITCHECK": { name: "待审核", value: "dsh" },
      "COMMITED": { name: "已递交", value: "ydj" },
      "ROBOT": { name: "已递交", value: "ydj" },
      "ROBOTPAY": { name: "已递交", value: "ydj" },
      "RECVCOMMIT": { name: "已递交", value: "ydj" },
    };
  }
  //接收辅助、担保商标注册信息
  async receiveAssistTmData(pobj) {
    var checkRes = await this.checkParams(pobj);
    if (checkRes.status == 0) {
      var deliveryData = await this.packagingTmDeliveryData(pobj, null);
      //获取交付信息
      var orderdeliveryRes = await this.getOrderDelivery(pobj.sourceOrderNo, pobj.serviceNo);
      if (orderdeliveryRes && orderdeliveryRes.length > 0) {
        return system.getResult(null, "保存商标订单交付信息失败，存在重复交付信息，不能重复提交，10300");
      }
      await this.orderinfoDao.addOrderDelivery(deliveryData, deliveryData.sourceOrderNo);
      await this.orderinfoDao.model.update({ isSolution: 1 }, { where: { orderNo: pobj.sourceOrderNo } });
      return system.getResultSuccess();
    } else {
      return checkRes;
    }
  }
  //接收辅助、担保商标注册修改信息
  async receiveEditAssistTmData(pobj) {
    var checkRes = await this.checkParams(pobj);
    if (checkRes.status == 0) {
      //获取交付信息
      var orderdeliveryRes = await this.getOrderDelivery(pobj.sourceOrderNo, pobj.serviceNo);
      if (!orderdeliveryRes || orderdeliveryRes.length < 1) {
        return system.getResult(null, "未知交付信息，10150");
      }
      var orderdelivery = orderdeliveryRes[0];
      var deliveryData = await this.packagingTmDeliveryData(pobj, orderdelivery.deliveryContent);
      this.putOrderDelivery(deliveryData, deliveryData.sourceOrderNo, deliveryData.serviceNo);
      await this.orderinfoDao.model.update({ isSolution: 1 }, { where: { orderNo: pobj.sourceOrderNo } });
      return system.getResultSuccess();
    } else {
      return checkRes;
    }
  }
  //-----------------------------------------------------------------------------------------------------
  async checkParams(pobj) {//参数校验
    if (!pobj.serviceNo) {
      return system.getResult(null, "业务单号不能为空不能为空，10100");
    }
    if (!pobj.sourceOrderNo) {
      return system.getResult(null, "来源单号不能为空，10110");
    }
    var orderinfo = await this.orderinfoDao.model.findOne({
      where: { orderNo: pobj.sourceOrderNo }, raw: true
    });
    if (!orderinfo || !orderinfo.id) {
      return system.getResult(null, "未知订单，10120");
    }
    if (!pobj.tm) {
      return system.getResult(null, "商标信息不能为空，10130");
    }
    if (!pobj.nclones) {
      return system.getResult(null, "商品/服务项不能为空，10140");
    }
    if (!pobj.tm) {
      return system.getResult(null, "商标信息不能为空，10150");
    }
    if (!pobj.tm.tmFormType) {
      return system.getResult(null, "商标类型不能为空，10160");
    }
    if (pobj.tm.tmFormType == "4") {
      pobj.tm.tmName = "图形";
    }
    if (!pobj.tm.tmName) {
      return system.getResult(null, "商标名称不能为空，10170");
    }
    if (!pobj.tm.picUrl) {
      return system.getResult(null, "商标图样不能为空，10180");
    }
    if (!pobj.apply) {
      return system.getResult(null, "申请信息不能为空，10190");
    }
    if (!pobj.apply.code) {
      return system.getResult(null, "申请统一社会信用代码不能为空，10200");
    }
    if (!pobj.apply.zipCode) {
      return system.getResult(null, "申请邮编不能为空，10210");
    }
    if (!pobj.apply.customerType) {
      return system.getResult(null, "申请人类型不能为空，10220");
    }
    if (pobj.apply.customerType != "ent" && pobj.apply.customerType != "person") {
      return system.getResult(null, "申请人类型错误，10230");
    }
    if (!pobj.orderContact) {
      return system.getResult(null, "联系人信息不能为空，10240");
    }
    if (!pobj.orderContact.contactName) {
      return system.getResult(null, "联系人姓名不能为空，10250");
    }
    if (!pobj.orderContact.mobile) {
      return system.getResult(null, "联系人手机号不能为空，10260");
    }
    return system.getResultSuccess(pobj);
  }
  async packagingTmDeliveryData(pobj, deliveryData) {//重新组装商标交付信息
    var deliveryStatusList = [];
    if (deliveryData && deliveryData.deliveryStatusList) {
      deliveryStatusList = deliveryData.deliveryStatusList;
    }
    var nclOne = pobj.nclones[0];
    if (nclOne.tmStatus) {
      var deliveryStatusObj = this.statusContrast[nclOne.tmStatus];
      if (deliveryStatusObj && deliveryStatusObj.value) {
        var deliveryStatus = deliveryStatusObj.value;
        var deliveryStatusName = deliveryStatusObj.name;
        deliveryStatusList.push({
          deliveryStatus: deliveryStatus,
          deliveryStatusName: deliveryStatusName,
          deliveryUpdated: new Date()
        });
        pobj.deliveryStatus = deliveryStatus;
        pobj.deliveryStatusName = deliveryStatusName;
      } else {
        deliveryStatusList.push({
          deliveryStatus: nclOne.tmStatus,
          deliveryStatusName: nclOne.tmStatus,
          deliveryUpdated: new Date()
        });
      }
    }
    pobj.deliveryStatusList = deliveryStatusList;
    pobj.opNotes = ""; //操作备注  
    return pobj;
  }
  putOrderDelivery(data, orderNo, channelOrderNo) {//修改交付信息
    var sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + JSON.stringify(data) + "' where sourceOrderNo='" + orderNo + "'";
    sql = sql + " and deliveryContent->'$.serviceNo' = '" + channelOrderNo + "'";
    this.orderinfoDao.customUpdate(sql);
  }
  addOrderDelivery(data, orderNo) {//新增交付信息--废弃，调用dao中的,20201102-sy
    var sql = "INSERT INTO  `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
      orderNo + "','" + JSON.stringify(data) + "')";
    this.orderinfoDao.customQuery(sql);
  }
  async getOrderDelivery(orderNo, channelOrderNo) {//查询交付信息
    var sql = "select * from `c_order_delivery` where sourceOrderNo='" + orderNo + "'";
    sql = sql + " and deliveryContent->'$.serviceNo' = '" + channelOrderNo + "'";
    return await this.orderinfoDao.customQuery(sql);
  }
  //----------------------------------------------------------------------------------------------------------

  async checkParams2(pobj) {//参数校验
    if (!pobj.proxyCode) {
      return system.getResult(null, "proxyCode不能为空");
    }
    if (!pobj.IntentionBizId) {
      return system.getResult(null, "渠道需求号不能为空");
    }
    pobj.IntentionBizId ="20201217132620000001";
    var needInfo = await this.needinfoDao.model.findOne({
      attributes:["id","needNo","channelNeedNo","uapp_id"],
      where:{channelNeedNo:pobj.IntentionBizId,channelTypeCode:2},
      raw:true
    });
    if(!needInfo || !needInfo.needNo){
      return system.getResult(null, "未知需求信息，10280");
    }
    pobj.needInfo = needInfo;
    return system.getResultSuccess(pobj);
  }
  //接收辅助、担保商标注册信息
  async receiveAssistTmSolutionData(pobj) {
    var checkRes = await this.checkParams2(pobj);
    if (checkRes.status == 0) {
      var needInfo = pobj.needInfo;
      //获取方案信息
      var ns = await this.needsolutionDao.model.findOne({
        where:{needNo:needInfo.needNo,channelNeedNo:needInfo.channelNeedNo,solutionNo:pobj.proxyCode,isInvalid:0}
      });
      if (ns) {
        return system.getResult(null, "保存商标方案信息失败，存在重复方案信息，不能重复提交，10300");
      }
      //方案流程
      var flowList=[{
        date:new Date(),flowName:"提交方案"
      }];
      pobj.flowList = flowList;
      var nsObj = {
        needNo:needInfo.needNo,channelNeedNo:needInfo.channelNeedNo,solutionNo:pobj.proxyCode,orderNo:pobj.serviceNo,
        solutionContent:JSON.stringify(pobj)
      }
      var needSolution  = await this.needsolutionDao.create(nsObj);
      return system.getResultSuccess(needSolution);
    } else {
      return checkRes;
    }
  }
  //接收辅助、担保商标注册修改信息
  async receiveEditAssistTmSolutionData(pobj) {
    if (!pobj.BizId) {
      return system.getResult(null, "BizId不能为空");
    }
    var checkRes = await this.checkParams2(pobj);
    if (checkRes.status == 0) {
      var needInfo = pobj.needInfo;
      //获取方案信息
      var ns = await this.needsolutionDao.model.findOne({
        where:{channelNeedNo:needInfo.channelNeedNo,channelSolutionNo:pobj.BizId}
      });
      if (!ns) {
        return system.getResult(null, "渠道方案号："+pobj.BizId+"的方案不存在，10300");
      }else{
        var flowObj={
          date:new Date(),flowName:"方案修改"
        };
        var oldSolutionContent = ns.solutionContent;
        if(oldSolutionContent){
          if(typeof oldSolutionContent === 'string'){
            oldSolutionContent = JSON.parse(oldSolutionContent)
          } 
          var flowList = oldSolutionContent.flowList || [];
          flowList.push(flowObj);
          pobj.flowList = flowList;
        }else{
          pobj.flowList = [flowObj];
        }
        var nsUpdateObj = {
          id:ns.id,solutionNo:pobj.proxyCode,
          solutionContent:JSON.stringify(pobj)
        }
        await this.needsolutionDao.update(nsUpdateObj);
        var needSolution  = await this.needsolutionDao.model.findOne({
          where:{channelNeedNo:needInfo.channelNeedNo,channelSolutionNo:pobj.BizId}
        });
        return system.getResultSuccess(needSolution);
      }
    } else {
      return checkRes;
    }
  }

  /*
	返回20位业务订单号
	prefix：业务前缀
	*/
	async getBusUid(prefix) {
		prefix = (prefix || "");
		if (prefix) {
			prefix = prefix.toUpperCase();
		}
		var prefixlength = prefix.length;
		var subLen = 8 - prefixlength;
		var uidStr = "";
		if (subLen > 0) {
			uidStr = await this.getUidInfo(subLen, 60);
		}
		var timStr = moment().format("YYYYMMDDHHmm");
		return prefix + timStr + uidStr;
	}
	/*
	len：返回长度
	radix：参与计算的长度，最大为62
	*/
	async getUidInfo(len, radix) {
		var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
		var uuid = [], i;
		radix = radix || chars.length;
		if (len) {
			for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
		} else {
			var r;
			uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
			uuid[14] = '4';
			for (i = 0; i < 36; i++) {
				if (!uuid[i]) {
					r = 0 | Math.random() * 16;
					uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
				}
			}
		}
		return uuid.join('');
  }
  
  //提交方案确认
  async submitTmConfirm(pobj) {
    if (!pobj.IntentionBizId) {
        return self.getResultFail("IntentionBizId不能为空");
    }
    //获取方案信息
    var nsList = await this.needsolutionDao.model.findAll({
      attributes:["id","status","solutionContent"],
      where:{channelNeedNo:pobj.IntentionBizId}
    });
    if (!nsList || nsList.length<1) {
      return system.getResult(null, "渠道需求号："+pobj.IntentionBizId+"的方案不存在，10300");
    }else{
      var flowObj={
        date:new Date(),flowName:"提交确认注册⽅案，待用户确认"
      };
      await this.db.transaction(async function (t) {
        await this.updateSolution(nsList, flowObj,2, t);
      })
      return system.getResultSuccess();
    }
  }

  async updateSolution(nsList, flowObj,needStatus, t) {
    var intentionStatusList = ["未知", "⽅案待服务商确认", "⽅案待⽤户确认", "处理中", "已完成", "已关闭"];
    for (var i = 0; i < nsList.length; i++) {
      var ns = nsList[i];
      if (ns && ns.id) {
        var updateObj = {
          id: ns.id
        };
        var solutionContent = ns.solutionContent || {};
        if (typeof ns.solutionContent === 'string') {
          ns.solutionContent = JSON.parse(ns.solutionContent);
        }
        solutionContent.needStatus = needStatus;
        solutionContent.needStatusName = intentionStatusList[needStatus];
        if(needStatus==2){
          // updateObj["status"] = "ybh";
        }
        if(needStatus==5){
          updateObj["status"] = "yzf";
        }
        var flowList = ns.solutionContent.flowList || [];
        flowList.push(flowObj);
        ns.solutionContent.flowList = flowList;

        ns.solutionContent = JSON.stringify(ns.solutionContent);
        await this.needsolutionDao.update(ns, t);
      }
    }
  }

  /**
   * 关闭注册⽅案
   */
  async closeSolution(pobj){
    if (!pobj.BizId) {
      return system.getResult(null, "BizId不能为空");
    }
    if (!pobj.IntentionBizId) {
        return self.getResultFail("IntentionBizId不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      attributes:["id","status","solutionContent"],
      where:{channelNeedNo:pobj.IntentionBizId,channelSolutionNo:pobj.BizId}
    });
    if (!ns) {
      return system.getResult(null, "渠道方案号："+pobj.BizId+"的方案不存在，10300");
    }else{
      var flowObj={
        date:new Date(),flowName:"关闭方案"
      };
      ns.solutionContent = ns.solutionContent || {};
      if(typeof ns.solutionContent === 'string'){
        ns.solutionContent = JSON.parse(ns.solutionContent)
      } 
      var flowList = ns.solutionContent.flowList || [];
      flowList.push(flowObj);
      ns.solutionContent.needStatus = 5;
      ns.solutionContent.needStatusName = "已关闭";
      ns.solutionContent.flowList = flowList;
      ns.solutionContent = JSON.stringify(ns.solutionContent);
      ns.status="yzf";
      await this.needsolutionDao.update(ns);
      return system.getResultSuccess();
    }
  }
}
module.exports = InternalCallsNotifyService;