const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
const ServiceBase = require("../../sve.base");
const uuidv4 = require('uuid/v4');
const sequelize = require('sequelize');
const platformConfig = require("../../../db/metadata/apps/platform.js");

class OrderInfoService extends ServiceBase {
    constructor() {
        super("dbcorder", ServiceBase.getDaoName(OrderInfoService));
        this.execClientNew = system.getObject("util.execClientNew");
        this.flowlogDao = system.getObject("db.dbcorder.flowlogDao");
        this.orderproductDao = system.getObject("db.dbcorder.orderproductDao");
        this.ordercontactsDao = system.getObject("db.dbcorder.ordercontactsDao");
        this.orderReceiptVoucherDao = system.getObject("db.dbcpay.orderreceiptvoucherDao");
        this.moneyJourneyDao = system.getObject("db.dbcpay.moneyjourneyDao");
        this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
        this.orderRegionDao = system.getObject("db.dbcorder.orderregionDao");
        this.push360Sve = system.getObject('service.common.push360Sve');
        this.orderinfoDao = system.getObject('db.dbcorder.orderinfoDao');
        this.orderinfofqDao = system.getObject('db.dbcorder.orderinfofqDao');
    }

    async getOrderInfoByChannelOrderNo(channelOrderNo, uapp_id) {
        var item = await this.dao.getItemStatusByChannelOrderNo(channelOrderNo, uapp_id)
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus < 2) {
            return system.getResult(null, "order status is not pay!");
        }
        var resultParams = {
            order_info: item,
            delivery_content: null,//包含订单联系人orderContact
            product_info: null
        };
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, {orderNo: item.orderNo});
        if (deliveryInfoResult && deliveryInfoResult.status == 0) {
            resultParams.delivery_content = deliveryInfoResult.data;
        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(item.orderNo);
        if (orderProductItem) {
            resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }
        return system.getResultSuccess(resultParams);


    }

    /**
     * 修改订单商机推送状态
     * @param actionBody
     * @returns {Promise<void>}
     */
    async updateOrderPushStatus(actionBody) {
        let channelOrderNo = actionBody.orderNo;
        let setObj = {
            pushStatus: actionBody.pushStatus
        }
        if (actionBody.pushNumber && actionBody.pushNumber > 0) {
            setObj.isPushNum = actionBody.pushNumber;
        }
        let whereObj = {
            where: {
                channelOrderNo: channelOrderNo
            }
        }
        if (channelOrderNo) {
            this.dao.updateByWhere(setObj, whereObj);
        }
        return system.getResultSuccess();
    }

    //----------------------订单创建-----------start----------------
    async createOrder(pobj, orderNo, t) {
        this.execClientNew.execLogs("center-order-createOrder-3", pobj, "center-order-doexecMethod-info", null, null);
        var actionBody = pobj.actionBody;
        var channelOrder = actionBody.channelOrder;
        var orderContact = actionBody.orderContact;
        var price_item = actionBody.product_info.price_item;
        var totalServiceCharge = Number(price_item.service_charge || 0) * Number(actionBody.quantity || 0);
        var totalPublicExpense = Number(price_item.public_expense || 0) * Number(actionBody.quantity || 0);
        var totalSupplyPrice = Number(price_item.supply_price || 0) * Number(actionBody.quantity || 0);//统计供货价格

        var price_additions_item = actionBody.product_info.price_additions_item;
        if (price_additions_item && actionBody.additions.quantity) {
            totalServiceCharge = totalServiceCharge + Number(price_additions_item.service_charge || 0) * Number(actionBody.additions.quantity || 0);
            totalPublicExpense = totalPublicExpense + Number(price_additions_item.public_expense || 0) * Number(actionBody.additions.quantity || 0);
            totalSupplyPrice = totalSupplyPrice + Number(price_additions_item.supply_price || 0) * Number(actionBody.additions.quantity || 0);//统计供货价格
        }
        var totalProfitSum = Number(actionBody.totalSum) - Number(totalSupplyPrice || 0);//利润
        var pfProfitSum = (100 - Number(price_item.channel_profit_rate || 0)) / 100 * totalProfitSum;
        if (pfProfitSum < 0) {
            pfProfitSum = 0;
        }
        var channelProfitSum = Number(totalProfitSum) - Number(pfProfitSum);
        var payTime = channelOrder.payTime || new Date();
        var params = {
            uapp_id: pobj.appInfo.uapp_id,//int(11)       //
            orderNo: orderNo,//varchar(64)   //订单号
            channelServiceNo: channelOrder.channelServiceNo || orderNo,//varchar(64)   //渠道服务单号
            channelOrderNo: channelOrder.channelOrderNo || orderNo,//varchar(1024) //渠道订单号列表，多个以,隔开
            needNo: channelOrder.needNo || "",//需求号--用于服务商或需求表中创建订单
            channelUserId: pobj.userInfo.channel_userid,//varchar(64)   //
            ownerUserId: pobj.userInfo.channel_userid,//varchar(20)   //
            payTime: channelOrder.orderStatus && channelOrder.orderStatus == 2 ? payTime : null,//datetime      //
            quantity: actionBody.quantity,//int(11)       //项目订单数量（即服务项目的倍数，默认值为1）
            serviceQuantity: 0,//int(11)       //项目订单交付数量（即与项目订单数量相对应）
            orderStatus: channelOrder.orderStatus || 1,//int          //订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
            totalSum: actionBody.totalSum,//decimal(12,2) //订单总额(产品价格×优惠费率×订单件数)
            payTotalSum: actionBody.payTotalSum || actionBody.totalSum,//decimal(12,2) //
            refundSum: 0,//decimal(12,2) //退款总额
            totalServiceCharge: totalServiceCharge,//decimal(12,2) //服务费总额（产品配置的服务费*订单件数）
            totalPublicExpense: totalPublicExpense,//decimal(12,2) //官费总额（产品配置的官费*订单件数）
            totalProfitSum: totalProfitSum,//decimal(12,2) //订单毛利润总额（产品价格-供货价格））
            pfProfitSum: pfProfitSum,//decimal(12,2) //订单平台毛利润总额（(100-渠道利润分成比例)/100 * 订单毛利润总额）
            channelProfitSum: channelProfitSum,//decimal(12,2) //订单渠道分成毛利润总额(订单毛利润总额-平台毛利润总额)

            totalDiscounts: 0,//decimal(12,2) //优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）暂时没有用到
            pfSettleProfit: 0,//int(11)       //平台结算渠道利润,0否，1是
            invoiceApplyStatus: "00",//varchar(10)   //发票状态:00: 未申请, 10: 已申请,20:已开票
            notes: actionBody.notes || "",//varchar(255)  //
            opNotes: "",//varchar(255)  //操作备注
        };
        var order = await this.dao.create(params, t);//创建订单
        var orderLog = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,
            opContent: "您提交了订单，请及时支付",
            isShow: 1
        };
        await this.flowlogDao.create(orderLog, t);
        if (["zzsbzc"].indexOf(actionBody.product_info.item_code) < 0) {
            delete actionBody.product_info["price_list"];
        }
        var orderProductObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            productType_id: actionBody.product_info.productType_id,//产品类型Id
            pathCode: actionBody.product_info.path_code,//产品路径
            itemCode: actionBody.product_info.item_code,//产品编码
            itemName: actionBody.product_info.item_name,//产品名称
            channelItemCode: actionBody.product_info.channel_item_code,//  渠道产品编码
            channelItemName: actionBody.product_info.channel_item_name,//  渠道产品名称
            channelItemAppendName: actionBody.channelItemAppendName || "",//服务商产品附加名称
            serviceItemCode: actionBody.product_info.service_item_code,//  服务商产品编码
            payAfterJumpH5Url: actionBody.product_info.pay_after_jump_h5url || "",
            payAfterJumpPcUrl: actionBody.product_info.pay_after_jump_pcurl || "",
            picUrl: actionBody.product_info.pic_url,//  产品图片地址
            price: actionBody.product_info.price_item.price,//定价
            priceDesc: actionBody.product_info.price_item.price_desc,//定价描述
            priceTypeName: actionBody.product_info.price_item.price_type_name,//定价类型名称
            quantity: actionBody.quantity,//  订单数量（即产品的倍数，默认值为1）
            opPayType: "00",//  操作付款类型:00: 创建订单, 10: 补单
            serviceItemSnapshot: JSON.stringify(actionBody.product_info),      //产品快照
            orderSnapshot: JSON.stringify(actionBody)// 2020 1110 lin 新增 增加订单快照
        };
        var orderProduct = await this.orderproductDao.create(orderProductObj, t);//订单产品
        var orderReceiptVoucherObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            accountType: "other",
            payDate: payTime,//支付时间
            totalSum: actionBody.payTotalSum || actionBody.totalSum,//订单总额
            auditStatus: "dsh",
            wxPayOrderCode: orderNo,//业务微信支付订单号
            aliPayOrderCode: orderNo,//业务支付宝支付订单号
            busPayOrderCode: orderNo,//业务支付订单号

            // payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号
            // buyerOpenId: DataTypes.STRING,//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
            // passTradeNo: DataTypes.STRING,//通道的统一订单号
            // buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
            // certifyFileUrl: order.orderNo, //支付证明文件Url
        };
        if (channelOrder.orderStatus && channelOrder.orderStatus == 2) {//订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
            var moneyObj = {
                uapp_id: pobj.appInfo.uapp_id,
                sourceOrderNo: orderNo,   // 来源单号
                channelUserId: pobj.userInfo.channel_userid,
                ownerUserId: pobj.userInfo.channel_userid,
                accountType: "other",//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: payTime,//凭单时间
                recvAmount: actionBody.payTotalSum || actionBody.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            var moneyJourney = await this.moneyJourneyDao.create(moneyObj, t);
            orderReceiptVoucherObj.auditStatus = "tg";
        }
        if (orderContact && orderContact.mobile) {
            var customerContactObj = {
                uapp_id: pobj.appInfo.uapp_id,//int(11)       //
                sourceOrderNo: orderNo,//交付订单号
                contactName: orderContact.contacts || "",//手机号
                mobile: orderContact.mobile,//手机号
                email: orderContact.email || "",
                tel: orderContact.tel || "", //座机
                fax: orderContact.fax || "" //传真
            };
            await this.ordercontactsDao.create(customerContactObj, t);
        }//渠道购买存在购买者手机号
        var orderReceiptVoucher = await this.orderReceiptVoucherDao.create(orderReceiptVoucherObj, t);
    }

    /**
     * 创建商标订单
     * @param {*} pobj
     * {
          "actionType": "addOrder",
          "actionBody": {
            "channelItemCode":"zzsbzc",
            "id":1,
            "quantity":1,
            "totalSum":300,
            "channelOrder":null,
            "deliveryData":null
          }
      }
     */

    /**
     * 工商H5 创建订单
     * @param pobj
     * @param orderNo
     * @param t
     * @returns {Promise<void>}
     */
    async createOrderH5(pobj, orderNo, t) {
        var actionBody = pobj.actionBody;
        var channelOrder = actionBody.channelOrder;
        var orderContact = actionBody.orderContact;
        var price_item = actionBody.product_info.price_item;
        var totalServiceCharge = Number(price_item.service_charge || 0) * Number(actionBody.quantity || 0);
        var totalPublicExpense = Number(price_item.public_expense || 0) * Number(actionBody.quantity || 0);
        var totalSupplyPrice = Number(price_item.supply_price || 0) * Number(actionBody.quantity || 0);//统计供货价格

        var price_additions_item = actionBody.product_info.price_additions_item;
        if (price_additions_item && actionBody.additions.quantity) {
            totalServiceCharge = totalServiceCharge + Number(price_additions_item.service_charge || 0) * Number(actionBody.additions.quantity || 0);
            totalPublicExpense = totalPublicExpense + Number(price_additions_item.public_expense || 0) * Number(actionBody.additions.quantity || 0);
            totalSupplyPrice = totalSupplyPrice + Number(price_additions_item.supply_price || 0) * Number(actionBody.additions.quantity || 0);//统计供货价格
        }
        var totalProfitSum = Number(actionBody.totalSum) - Number(totalSupplyPrice || 0);//利润
        var pfProfitSum = (100 - Number(price_item.channel_profit_rate || 0)) / 100 * totalProfitSum;
        if (pfProfitSum < 0) {
            pfProfitSum = 0;
        }
        var channelProfitSum = Number(totalProfitSum) - Number(pfProfitSum);
        var payTime = channelOrder.payTime || new Date();
        var params = {
            uapp_id: pobj.appInfo.uapp_id,//int(11)       //
            orderNo: orderNo,//varchar(64)   //订单号
            channelServiceNo: channelOrder.channelServiceNo || orderNo,//varchar(64)   //渠道服务单号
            channelOrderNo: channelOrder.channelOrderNo || orderNo,//varchar(1024) //渠道订单号列表，多个以,隔开
            needNo: channelOrder.needNo || "",//需求号--用于服务商或需求表中创建订单
            channelUserId: pobj.userInfo.channel_userid,//varchar(64)   //
            ownerUserId: pobj.userInfo.channel_userid,//varchar(20)   //
            payTime: channelOrder.orderStatus && channelOrder.orderStatus == 2 ? payTime : null,//datetime      //
            quantity: actionBody.quantity,//int(11)       //项目订单数量（即服务项目的倍数，默认值为1）
            serviceQuantity: 0,//int(11)       //项目订单交付数量（即与项目订单数量相对应）
            orderStatus: channelOrder.orderStatus || 1,//int          //订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
            totalSum: actionBody.totalSum,//decimal(12,2) //订单总额(产品价格×优惠费率×订单件数)
            payTotalSum: actionBody.payTotalSum || actionBody.totalSum,//decimal(12,2) //
            refundSum: 0,//decimal(12,2) //退款总额
            totalServiceCharge: totalServiceCharge,//decimal(12,2) //服务费总额（产品配置的服务费*订单件数）
            totalPublicExpense: totalPublicExpense,//decimal(12,2) //官费总额（产品配置的官费*订单件数）
            totalProfitSum: totalProfitSum,//decimal(12,2) //订单毛利润总额（产品价格-供货价格））
            pfProfitSum: pfProfitSum,//decimal(12,2) //订单平台毛利润总额（(100-渠道利润分成比例)/100 * 订单毛利润总额）
            channelProfitSum: channelProfitSum,//decimal(12,2) //订单渠道分成毛利润总额(订单毛利润总额-平台毛利润总额)
            totalDiscounts: 0,//decimal(12,2) //优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）暂时没有用到
            pfSettleProfit: 0,//int(11)       //平台结算渠道利润,0否，1是
            invoiceApplyStatus: "00",//varchar(10)   //发票状态:00: 未申请, 10: 已申请,20:已开票
            notes: actionBody.notes || "",//varchar(255)  //
            opNotes: "",//varchar(255)  //操作备注
        };
        var order = await this.dao.create(params, t);//创建订单
        var orderLog = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,
            opContent: "您提交了订单，请及时支付",
            isShow: 1
        };
        await this.flowlogDao.create(orderLog, t);
        if (["zzsbzc"].indexOf(actionBody.product_info.item_code) < 0) {
            delete actionBody.product_info["price_list"];
        }
        var orderProductObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            productType_id: actionBody.product_info.productType_id,//产品类型Id
            pathCode: actionBody.product_info.path_code,//产品路径
            itemCode: actionBody.product_info.item_code,//产品编码
            itemName: actionBody.product_info.item_name,//产品名称
            channelItemCode: actionBody.product_info.channel_item_code,//  渠道产品编码
            channelItemName: actionBody.product_info.channel_item_name,//  渠道产品名称
            channelItemAppendName: actionBody.channelItemAppendName || "",//服务商产品附加名称
            serviceItemCode: actionBody.product_info.service_item_code,//  服务商产品编码
            payAfterJumpH5Url: actionBody.product_info.pay_after_jump_h5url || "",
            payAfterJumpPcUrl: actionBody.product_info.pay_after_jump_pcurl || "",
            picUrl: actionBody.product_info.pic_url,//  产品图片地址
            price: actionBody.product_info.price_item.price,//定价
            priceDesc: actionBody.product_info.price_item.price_desc,//定价描述
            priceTypeName: actionBody.product_info.price_item.price_type_name,//定价类型名称
            quantity: actionBody.quantity,//  订单数量（即产品的倍数，默认值为1）
            opPayType: "00",//  操作付款类型:00: 创建订单, 10: 补单
            serviceItemSnapshot: JSON.stringify(actionBody.product_info),//产品快照
            orderSnapshot: JSON.stringify(actionBody.registerData)
        };
        var orderProduct = await this.orderproductDao.create(orderProductObj, t);//订单产品
        var orderReceiptVoucherObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            accountType: "other",
            payDate: payTime,//支付时间
            totalSum: actionBody.payTotalSum || actionBody.totalSum,//订单总额
            auditStatus: "dsh",
            wxPayOrderCode: orderNo,//业务微信支付订单号
            aliPayOrderCode: orderNo,//业务支付宝支付订单号
            busPayOrderCode: orderNo,//业务支付订单号
        };
        if (channelOrder.orderStatus && channelOrder.orderStatus == 2) {//订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
            var moneyObj = {
                uapp_id: pobj.appInfo.uapp_id,
                sourceOrderNo: orderNo,   // 来源单号
                channelUserId: pobj.userInfo.channel_userid,
                ownerUserId: pobj.userInfo.channel_userid,
                accountType: "other",//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: payTime,//凭单时间
                recvAmount: actionBody.payTotalSum || actionBody.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            var moneyJourney = await this.moneyJourneyDao.create(moneyObj, t);
            orderReceiptVoucherObj.auditStatus = "tg";
        }
        if (orderContact && orderContact.mobile) {
            var customerContactObj = {
                uapp_id: pobj.appInfo.uapp_id,//int(11)       //
                sourceOrderNo: orderNo,//交付订单号
                contactName: orderContact.contacts || "",//联系人
                mobile: orderContact.mobile,//手机号
                email: orderContact.email || ""
            };
            await this.ordercontactsDao.create(customerContactObj, t);
        }//渠道购买存在购买者手机号
        var orderReceiptVoucher = await this.orderReceiptVoucherDao.create(orderReceiptVoucherObj, t);
    }


    // async createTmOrder(pobj) {
    //     var packagingTmResult = await this.packagingTmDeliveryData(pobj, pobj.actionBody);
    //     if (packagingTmResult.status != 0) {
    //         return packagingTmResult;
    //     }
    //     var self = this;
    //     return await self.db.transaction(async function (t) {
    //         var orderNo = await self.getBusUid("tm" + pobj.appInfo.uapp_id);
    //         var item = await self.createOrder(pobj, orderNo, t);
    //         await self.dao.addOrderDelivery(pobj.actionBody.deliveryData, orderNo, t);
    //         return system.getResultSuccess({
    //             orderNo: orderNo,
    //             channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
    //             channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
    //             channelParams: pobj.actionBody.channelOrder.channelParams || ""
    //         });
    //     });
    // }

    async packagingTmDeliveryData(pobj, actionBody) {//重新组装商标交付信息
        if (!actionBody.deliveryData || Object.keys(actionBody.deliveryData).length == 0) {
            return system.getResult(null, "交付数据不能为空，20135");
        }
        var deliveryData = actionBody.deliveryData;
        if (!deliveryData.nclones) {
            return system.getResult(null, "商品/服务项不能为空，20150");
        }
        if (!deliveryData.tm) {
            return system.getResult(null, "商标信息不能为空，20180");
        }
        if (!deliveryData.tm.tmFormType) {
            return system.getResult(null, "商标类型不能为空，20183");
        }
        if (["3", "4", "5"].indexOf(deliveryData.tm.tmFormType) < 0) {
            return system.getResult(null, "商标类型值错误，20185");
        }
        if (deliveryData.tm.tmFormType == "4") {
            pobj.actionBody.deliveryData.tm.tmName = "图形";
            deliveryData.tm.tmName = "图形";
            pobj.actionBody.channelItemAppendName = "图形";
        }
        if (!deliveryData.tm.tmName) {
            return system.getResult(null, "商标名称不能为空，20180");
        }
        if (!deliveryData.tm.picUrl) {
            return system.getResult(null, "商标图样不能为空，20210");
        }
        if (pobj.appInfo.uapp_id != 22) {
            if (!deliveryData.apply) {
                return system.getResult(null, "申请信息不能为空，20230");
            }
            if (!deliveryData.apply.code) {
                return system.getResult(null, "申请统一社会信用代码不能为空，20250");
            }
            if (!deliveryData.apply.zipCode) {
                return system.getResult(null, "申请邮编不能为空，20280");
            }
            if (!deliveryData.apply.customerType) {
                return system.getResult(null, "申请人类型不能为空，20310");
            }
            if (deliveryData.apply.customerType != "ent" && deliveryData.apply.customerType != "person") {
                return system.getResult(null, "申请人类型错误，20330");
            }
        }
        var deliveryStatus = "dsccl";
        var deliveryStatusName = "待上传材料";
        var deliveryStatusList = [{
            deliveryStatus: "dsccl",
            deliveryStatusName: "待上传材料",
            deliveryUpdated: new Date()
        }];
        if (deliveryData.apply.customerType == "ent") {
            if (deliveryData.apply.businessLicensePdf && deliveryData.apply.gzwtsUrl) {
                deliveryStatus = "dsh";
                deliveryStatusName = "待审核";
                deliveryStatusList.push({
                    deliveryStatus: deliveryStatus,
                    deliveryStatusName: deliveryStatusName,
                    deliveryUpdated: new Date()
                });
            }
        } else {
            if (deliveryData.apply.businessLicensePdf && deliveryData.apply.gzwtsUrl && deliveryData.apply.identityCardPdf) {
                deliveryStatus = "dsh";
                deliveryStatusName = "待审核";
                deliveryStatusList.push({
                    deliveryStatus: deliveryStatus,
                    deliveryStatusName: deliveryStatusName,
                    deliveryUpdated: new Date()
                });
            }
        }
        actionBody.quantity = deliveryData.nclones.length;
        var price_item = actionBody.product_info.price_item;
        var self = this;
        var extraNclCount = 0;//计算多余的尼斯数量
        var totalNclPublicExpense = 0;//重新计算尼斯官费
        for (let index = 0; index < deliveryData.nclones.length; index++) {
            var nclThree = deliveryData.nclones[index].nclThree;
            deliveryData.nclones[index].nclCount = nclThree.length;
            deliveryData.nclones[index].nclPublicExpense = Number(price_item.public_expense);
            totalNclPublicExpense = totalNclPublicExpense + Number(price_item.public_expense);//一个大类的官费
            deliveryData.nclones[index].tmStatus = deliveryStatus;//商标交付状态
            deliveryData.nclones[index].tmStatusName = deliveryStatusName;
            deliveryData.nclones[index].submitTime = "";
            deliveryData.nclones[index].deliveryType = pobj.appInfo.delivery_type;//应用数据操作类型：00独立，10全委托
            deliveryData.nclones[index].tbCode = await self.getBusUid("tb" + pobj.appInfo.uapp_id);//提报号(自动生成)
            deliveryData.nclones[index].tmRegistNum = "";
            extraNclCount = extraNclCount + (nclThree.length > 10 ? (nclThree.length - 10) : 0);
        }
        if (extraNclCount > 0) {
            if (!actionBody.additions) {
                return system.getResult(null, "附加购买项目不能为空，20335");
            }
            if (!actionBody.product_info.price_additions_item) {
                return system.getResult(null, "没有查询到附加购买项目信息，20336");
            }
            //重新计算尼斯官费
            totalNclPublicExpense = totalNclPublicExpense + extraNclCount * Number(actionBody.product_info.price_additions_item.public_expense);
        }
        if (Number(actionBody.totalSum) < Number(totalNclPublicExpense)) {
            return system.getResult(null, "总价有误，总价不能小于" + totalNclPublicExpense + "，20140");
        }
        pobj.actionBody.deliveryData.deliveryStatus = deliveryStatus;
        pobj.actionBody.deliveryData.deliveryStatusName = deliveryStatusName;
        pobj.actionBody.deliveryData.deliveryStatusList = deliveryStatusList;
        pobj.actionBody.deliveryData.notes = actionBody.notes || ""; //  订单备注
        pobj.actionBody.deliveryData.opNotes = ""; //操作备注
        return system.getResultSuccess();
    }


    //-------------------------------------工商H5 创建订单结束-----------------------------------------

    /**
     * 创建商标订单
     * @param {*} pobj
     * {
          "actionType": "addOrder",
          "actionBody": {
            "orderNo":"orderNo"
            "channelItemCode":"zzsbzc",
            "id":1,
            "quantity":1,
            "totalSum":300,
            "channelOrder":null,
            "deliveryData":null
          }
      }
     */
    async createTmOrder(pobj) {
        let packagingTmResult = await this.packagingTmDeliveryData(pobj, pobj.actionBody);
        if (packagingTmResult.status != 0) {
            return packagingTmResult;
        }
        let self = this;
        return await self.db.transaction(async function (t) {
            if (pobj.actionBody.channelOrder && pobj.actionBody.channelOrder.channelOrderNo) {
                let rtn = await self.dao.findOne({channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo}, t);
                if (rtn) {
                    return system.getResultSuccess({
                        orderNo: rtn.orderNo,
                        channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || rtn.orderNo,
                        channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || rtn.orderNo,
                        channelParams: pobj.actionBody.channelOrder.channelParams || "",
                        opType: "query"
                    });
                }
            }
            const orderNo = (await self.getBusUid((pobj.actionBody.quantity > 1 ? "cntm" : "tm") + pobj.appInfo.uapp_id)).toUpperCase();
            await self.createOrder(pobj, orderNo, t);
            await self.dao.addOrderDelivery(pobj.actionBody.deliveryData, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || "",
                opType: "add"
            });
        });
    }

    async packagingLogoDeliveryData(pobj, actionBody) {//重新组装Logo交付信息
        if (!actionBody.deliveryData || Object.keys(actionBody.deliveryData).length == 0) {
            return system.getResult(null, "交付数据不能为空，20135");
        }
        var deliveryData = actionBody.deliveryData;
        if (!deliveryData.logo_id) {
            return system.getResult(null, "logo_Id不能为空，20150");
        }
        deliveryData.logo_id = deliveryData.logo_id.toString();
        // if (!deliveryData.description) {
        //   return system.getResult(null, "描述信息不能为空，20180");
        // }
        if (!deliveryData.pic_url) {
            return system.getResult(null, "图标链接不能为空，20183");
        }
        if (!deliveryData.title) {
            return system.getResult(null, "品牌名称不能为空，20184");
        }
        // if (!deliveryData.subtitle) {
        //   return system.getResult(null, "品牌标语不能为空，20183");
        // }
        return system.getResultSuccess(deliveryData);
    }

    async createLogoOrder(pobj) {
        var packagingTmResult = await this.packagingLogoDeliveryData(pobj, pobj.actionBody);
        if (packagingTmResult.status != 0) {
            return packagingTmResult;
        }
        if (pobj.actionBody.deliveryData.color_description) {
            pobj.actionBody.deliveryData.color_description = pobj.actionBody.deliveryData.color_description.replace(/\"/g, "\\\"");
            ;
        }
        if (pobj.actionBody.deliveryData.font_description) {
            pobj.actionBody.deliveryData.font_description = pobj.actionBody.deliveryData.font_description.replace(/\"/g, "\\\"");
            ;
        }
        pobj.actionBody.deliveryData.itemCode = "znlogosjcp";
        var sql = "SELECT *  FROM " +
            "( SELECT sourceOrderNo FROM `c_order_delivery` WHERE deliveryContent -> '$.logo_id' = " + pobj.actionBody.deliveryData.logo_id +
            " or deliveryContent -> '$.logo_id' = '" + pobj.actionBody.deliveryData.logo_id + "' ) AS delivery " +
            "LEFT JOIN " +
            "( SELECT orderNo, orderStatus FROM `c_order_info` WHERE orderStatus = '2' or orderStatus='4' or orderStatus='8') AS orderinfo " +
            " ON delivery.sourceOrderNo = orderinfo.orderNo";
        var deliveryList = await this.customQuery(sql);
        if (deliveryList && deliveryList.length > 0) {
            return system.getResult(null, "该品牌已售出，20200");
        }
        var self = this;
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("logo" + pobj.appInfo.uapp_id);
            var item = await self.createOrder(pobj, orderNo, t);
            await self.dao.addOrderDelivery(pobj.actionBody.deliveryData, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || ""
            });
        });
    }

    /**
     * 创建其他订单
     * @param {*} pobj
     */
    async createOtherOrder(pobj) {
        var self = this;
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("ot" + pobj.appInfo.uapp_id);
            if (pobj.actionBody.channelOrder && pobj.actionBody.channelOrder.channelOrderNo) {
                var rtn = await self.dao.findOne({channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo}, t);
                if (rtn) {
                    return system.getResultSuccess({
                        orderNo: rtn.orderNo,
                        channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || rtn.orderNo,
                        channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || rtn.orderNo,
                        channelParams: pobj.actionBody.channelOrder.channelParams || "",
                        opType: "query"
                    });
                }
            }
            // 2020 0810 lin 修改 把插入订单语句移出判断，对于没有渠道号的订单 也要插入
            var item = await self.createOrder(pobj, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || "",
                opType: "add"
            });
        });

    }

    async createH5Order(pobj) {
        var self = this;
        if (!pobj.actionBody.registerData) {
            return system.getResult(null, "注册信息为空");
        }
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("ot" + pobj.appInfo.uapp_id);
            if (pobj.actionBody.channelOrder && pobj.actionBody.channelOrder.channelOrderNo) {
                var count = await self.dao.findCount({where: {channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo}});
                if (count > 0) {
                    return system.getResultFail(-1, "订单不能重复创建s");
                }
            }
            var item = await self.createOrderH5(pobj, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || ""
            });
        });
    }

    //   orderNo
    // orderPrice
    // phone
    // companyName
    // city
    // area
    // companyCategory
    // companyType
    // orgType
    // industryType
    // scope
    // remark
    // solutionBizid
    async createsolutionOrder(pobj) {
        if (pobj.actionBody.orderNo) {
            return system.getResult(null, "orderNo不能为空");
        }
        if (actionBody.orderPrice) {
            return system.getResult(null, "orderPrice不能为空");
        }
        if (actionBody.phone) {
            return system.getResult(null, "phone不能为空");
        }
        if (actionBody.companyName) {
            return system.getResult(null, "companyName不能为空");
        }
        if (actionBody.city) {
            return system.getResult(null, "city不能为空");
        }
        if (actionBody.companyCategory) {
            return system.getResult(null, "companyCategory不能为空");
        }
        if (actionBody.orgType) {
            return system.getResult(null, "orgType不能为空");
        }
        if (actionBody.industryType) {
            return system.getResult(null, "industryType不能为空");
        }
        if (actionBody.scope) {
            return system.getResult(null, "scope不能为空");
        }
        var producesql = "SELECT pc.pay_code payCode FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_name LIKE '%" + city
            + "%' AND pc.price_desc LIKE '%" + area
            + "%' and pc.additions_desc LIKE '%" + companyCategory + "%' ;"
        var produceinfo = await this.customQuery(producesql);
        if (produceinfo) {
            pobj.actionBody.payCode = produceinfo[0].payCode;
        }
        pobj.actionBody.totalSum = Number(pobj.actionBody.orderPrice || "0");
        pobj.actionBody.payTotalSum = Number(pobj.actionBody.orderPrice || "0");
        var self = this;
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("ic" + pobj.appInfo.uapp_id);
            var needsolutioninfo = await self.needsolutionDao.findOne({channelSolutionNo: pobj.actionBody.solutionBizId}, t)
            pobj.actionBody.channelOrder = {
                channelServiceNo: pobj.actionBody.orderNo,
                channelOrderNo: pobj.actionBody.orderNo,
                needNo: needsolutioninfo.needNo,
                orderStatus: 2
            }
            var item = await self.createOrder(pobj, orderNo, t);
            // needsolutioninfo.status = "ywc";
            await self.needsolutionDao.update({id: needsolutioninfo.id, status: "dqr"}, t);
            self.dao.addOrderDelivery(pobj.actionBody.deliveryData, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || ""
            });
        });


    }

    //接收方案状态及支付信息
    async receiveSolutionPayInfo(channelSolutionNo, status, orderPrice, self, t) {
        var needsolutioninfo = await self.needsolutionDao.findOne({channelSolutionNo: channelSolutionNo}, t);
        if (!needsolutioninfo || !needsolutioninfo.id) {
            return system.getResultFail(-400, "未知方案");
        }
        var solutionContent = needsolutioninfo.solutionContent;
        solutionContent = JSON.parse(solutionContent);
        solutionContent["totalSum"] = Number(orderPrice || "0");
        needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
        needsolutioninfo.status = status;
        await self.needsolutionDao.update(needsolutioninfo, t);
        return system.getResultSuccess();
    }

    async createChannelSource(pobj) {//创建渠道来源订单
        var orderNo = await self.getBusUid("oc" + pobj.appInfo.uapp_id);
        // var beforeOrder = await this.dao.model.findOne({
        //   where: { channelServiceNo: channelOrder.channelServiceNo, uapp_id: app.uAppId },
        //   raw: true
        // });
        // if (beforeOrder) {//订单已存在
        //   return system.getResultFail(2, "订单已存在", beforeOrder.orderNo);
        // }
    }

    //----------------------订单创建-----------end----------------------


    //=================================修改订单信息==============end======================================

    async updateContacts(pobj, actionBody) {//修改订单联系人
        if (!actionBody.orderContact) {
            return system.getResult(null, "联系人信息不能为空，30130");
        }
        if (!actionBody.orderContact.contacts) {
            return system.getResult(null, "联系人不能为空，30140");
        }
        if (!actionBody.orderContact.mobile) {
            return system.getResult(null, "手机号不能为空，30150");
        }
        var orderItem = await this.dao.getItemStatusByOrderNo(actionBody.orderNo, pobj.appInfo.uapp_id);
        if (!orderItem) {
            return system.getResult(null, "修改失败，修改的数据为空，30100");
        }
        if (orderItem.orderStatus == 4) {
            return system.getResult(null, "服务中的订单不能进行修改，30110");
        }
        if (orderItem.orderStatus == 8) {
            return system.getResult(null, "已完成的订单不能进行修改，30120");
        }
        var updateFields = {
            contactName: actionBody.orderContact.contacts || "",
            mobile: actionBody.orderContact.mobile,//手机号
            email: actionBody.orderContact.email || ""
        };
        if (actionBody.orderContact.tel) {
            updateFields['tel'] = actionBody.orderContact.tel
        }
        if (actionBody.orderContact.fax) {
            updateFields['fax'] = actionBody.orderContact.fax
        }
        this.ordercontactsDao.updateByWhere(updateFields, {where: {sourceOrderNo: actionBody.orderNo}});
        if (actionBody.notes) {
            actionBody.isGetContact = 0;
            var itemResult = await this.getOrderDeliveryInfo(pobj, actionBody);
            if (itemResult.status == 0) {
                if (actionBody.notes != itemResult.data.notes) {
                    itemResult.data.notes = actionBody.notes;
                    this.putOrderDelivery(itemResult.data, actionBody.orderNo);
                }
            }
        }//修改备注
        var resultParams = {orderStatus: orderItem.orderStatus};
        if (orderItem.orderStatus < 4) {
            var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(actionBody.orderNo);
            if (orderProductItem) {
                resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
            }
        }
        return system.getResultSuccess(resultParams);
    }

    async updateTmOrder(pobj, actionBody) {//修改商标订单信息
        var orderItem = await this.dao.getItemStatusByOrderNo(actionBody.orderNo, pobj.appInfo.uapp_id);
        if (!orderItem) {
            return system.getResult(null, "修改失败，修改的数据为空，30100");
        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(actionBody.orderNo);
        if (!orderProductItem) {
            return system.getResult(null, "修改失败，订单对应的产品数据为空，30105");
        }
        var product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        if (orderItem.orderStatus == 4) {
            return system.getResult(null, "服务中的订单不能进行修改，30110");
        }
        if (orderItem.orderStatus == 8) {
            return system.getResult(null, "已完成的订单不能进行修改，30120");
        }
        actionBody.isGetContact = 0;
        var itemResult = await this.getOrderDeliveryInfo(pobj, actionBody);
        if (itemResult.status != 0) {
            return itemResult;
        }
        if (!itemResult.data || Object.keys(itemResult.data).length == 0) {
            return system.getResult(null, "修改失败，修改的数据为空，30020");
        }
        var self = this;
        var tipsMsg = "";
        var apply = actionBody.apply;
        var dbApply = itemResult.data.apply;
        if (apply) {
            var applyKeys = Object.keys(apply);
            if (dbApply && applyKeys.length > 0) {
                for (let index = 0; index < applyKeys.length; index++) {
                    const aKey = applyKeys[index];
                    if (apply[aKey] != dbApply[aKey]) {
                        itemResult.data.apply[aKey] = apply[aKey];
                    }
                }
                var deliveryStatus = "dsccl";
                var deliveryStatusName = "待上传材料";
                if (itemResult.data.apply.customerType == "ent") {
                    if (itemResult.data.apply.businessLicensePdf && itemResult.data.apply.gzwtsUrl) {
                        deliveryStatus = "dsh";
                        deliveryStatusName = "待审核";
                    }
                } else {
                    if (itemResult.data.apply.businessLicensePdf && itemResult.data.apply.gzwtsUrl && itemResult.data.apply.identityCardPdf) {
                        deliveryStatus = "dsh";
                        deliveryStatusName = "待审核";
                    }
                }
                if (itemResult.data.deliveryStatus != deliveryStatus) {
                    itemResult.data.deliveryStatus = deliveryStatus;
                    itemResult.data.deliveryStatusName = deliveryStatusName;
                    for (let j = 0; j < itemResult.data.nclones.length; j++) {
                        itemResult.data.nclones[j].tmStatus = deliveryStatus;//商标交付状态
                        itemResult.data.nclones[j].tmStatusName = deliveryStatusName;
                    }
                    var deliveryStatusList = itemResult.data.deliveryStatusList;
                    if (deliveryStatusList && deliveryStatusList.length > 0) {
                        var deliveryStatusIndex = deliveryStatusList.findIndex(f => f.deliveryStatus == deliveryStatus);
                        if (deliveryStatusIndex < 0) {
                            deliveryStatusList.push({
                                deliveryStatus: deliveryStatus,
                                deliveryStatusName: deliveryStatusName,
                                deliveryUpdated: new Date()
                            });
                            itemResult.data.deliveryStatusList = deliveryStatusList;
                        }
                    }
                }
                //作为推送商标状态进行推送
                actionBody.deliveryStatus = deliveryStatus;
                actionBody.deliveryStatusName = deliveryStatusName;
            }
        }
        var tm = actionBody.tm;
        if (tm) {
            var dbTm = itemResult.data.tm;
            var tmKeys = Object.keys(tm);
            if (dbTm && tmKeys.length > 0) {
                for (let i = 0; i < tmKeys.length; i++) {
                    const iKey = tmKeys[i];
                    if (!tm[iKey]) {
                        tipsMsg = "修改失败，" + iKey + "不能为空，30030";
                    }
                    if (tm[iKey] && tm[iKey] != dbTm[iKey]) {
                        itemResult.data.tm[iKey] = tm[iKey].toString();
                    }
                }
            }
            if (["3", "4", "5"].indexOf(tm.tmFormType.toString()) < 0) {
                return system.getResult(null, "商标类型值错误，20185");
            }
            var putOrderProductItem = {};
            if (tm.tmFormType.toString() == "4") {
                itemResult.data.tm.tmName = "图形";
                putOrderProductItem.channelItemAppendName = "图形";
            } else {
                if (tm.channelItemAppendName && tm.channelItemAppendName != orderProductItem.channelItemAppendName) {
                    putOrderProductItem.channelItemAppendName = tm.channelItemAppendName;
                }
            }

            if (putOrderProductItem.channelItemAppendName) {
                self.orderproductDao.updateByWhere(putOrderProductItem, {where: {sourceOrderNo: actionBody.orderNo}});
            }
        }
        if (tipsMsg) {
            return system.getResult(null, tipsMsg);
        }
        var tempNclList = actionBody.nclones;
        if (tempNclList && tempNclList.length > 0) {
            var nclThreeCount = 0;
            var extraNclCount = 0;//计算多余的尼斯数量
            for (let h = 0; h < tempNclList.length; h++) {
                const nclThree = tempNclList[h].nclThree;
                tempNclList[h].nclCount = nclThree.length;
                tempNclList[h].nclPublicExpense = Number(product_info.price_item.public_expense);
                tempNclList[h].tmStatus = itemResult.data.deliveryStatus || "";//商标交付状态
                tempNclList[h].tmStatusName = itemResult.data.deliveryStatusName || "";
                tempNclList[h].submitTime = "";
                tempNclList[h].deliveryType = pobj.appInfo.delivery_type;//应用数据操作类型：00独立，10全委托
                tempNclList[h].tbCode = await self.getBusUid("tb" + pobj.appInfo.uapp_id);//提报号(自动生成)
                tempNclList[h].tmRegistNum = "";
                tempNclList[h].nclThree = nclThree;
                nclThreeCount = nclThreeCount + nclThree.length;
                extraNclCount = extraNclCount + (nclThree.length - 10);
            }
            if (extraNclCount > 0) {
                if (!actionBody.additions) {
                    return system.getResult(null, "附加购买项目不能为空，20338");
                }
            }
            if (orderItem.orderStatus == 2) {
                var dbNclList = itemResult.data.nclones;
                if (dbNclList.length < tempNclList.length) {
                    return system.getResult(null, "修改失败，尼斯大类应该为：" + dbNclList.length + "个大类，当前选择了" + tempNclList.length + "个大类，30040");
                }
                var dbNclThreeCount = 0;
                for (let k = 0; k < dbNclList.length; k++) {
                    const kItem = dbNclList[k];
                    dbNclThreeCount = dbNclThreeCount + Number(kItem.nclCount);
                }
                if (dbNclThreeCount < nclThreeCount) {
                    var tempDbNclThreeCount = dbNclList.length * 10;
                    if (tempDbNclThreeCount < nclThreeCount) {
                        return system.getResult(null, "修改失败，尼斯应该为：" + dbNclThreeCount + "个小项，当前选择了" + nclThreeCount + "个小项，30050");
                    }
                }
            }//已付款进行修改尼斯数据

            if (orderItem.orderStatus == 1) {
                actionBody.quantity = tempNclList.length;
                var isUpdateProduct = 0;
                var price_item = product_info.price_item;
                var price_additions_item = product_info.price_additions_item;
                var totalSum = Number(price_item.price) * Number(actionBody.quantity);
                var totalServiceCharge = Number(price_item.service_charge || 0) * Number(actionBody.quantity || 0);
                var totalPublicExpense = Number(price_item.public_expense || 0) * Number(actionBody.quantity || 0);
                var totalSupplyPrice = Number(price_item.supply_price || 0) * Number(actionBody.quantity || 0);//统计供货价格
                if (extraNclCount > 0) {
                    if (!price_additions_item) {
                        var additionsIndex = product_info.price_list.findIndex(f => f.pay_code == actionBody.additions.payCode && f.is_show == 0);
                        if (additionsIndex >= 0) {
                            isUpdateProduct++;
                            price_additions_item = product_info.price_list[additionsIndex];
                            product_info.price_additions_item = price_additions_item;
                        }
                    }
                    totalSum = totalSum + Number(price_additions_item.price) * extraNclCount;
                    totalServiceCharge = totalServiceCharge + Number(price_additions_item.service_charge || 0) * extraNclCount;
                    totalPublicExpense = totalPublicExpense + Number(price_additions_item.public_expense || 0) * extraNclCount;
                    totalSupplyPrice = totalSupplyPrice + Number(price_additions_item.supply_price || 0) * extraNclCount;//统计供货价格
                    //重新计算尼斯官费
                    for (let g = 0; g < tempNclList.length; g++) {
                        const nclThree = tempNclList[g].nclThree;
                        tempNclList[g].nclPublicExpense = Number(tempNclList[g].nclPublicExpense) + (nclThree.length - 10) * Number(price_additions_item.public_expense);
                    }
                } else {
                    if (price_additions_item) {
                        isUpdateProduct++;
                        delete product_info["price_additions_item"];
                    }
                }
                var totalProfitSum = Number(totalSum) - Number(totalSupplyPrice || 0);//利润
                var pfProfitSum = (100 - Number(price_item.channel_profit_rate || 0)) / 100 * totalProfitSum;
                if (pfProfitSum < 0) {
                    pfProfitSum = 0;
                }
                var channelProfitSum = Number(totalProfitSum) - Number(pfProfitSum);
                await self.db.transaction(async function (t) {
                    if (Number(orderItem.totalSum) != totalSum) {
                        var putOrderFields = {
                            totalSum: totalSum,//decimal(12,2) //订单总额(产品价格×优惠费率×订单件数)
                            payTotalSum: totalSum,//decimal(12,2) //
                            refundSum: 0,//decimal(12,2) //退款总额
                            totalServiceCharge: totalServiceCharge,//decimal(12,2) //服务费总额（产品配置的服务费*订单件数）
                            totalPublicExpense: totalPublicExpense,//decimal(12,2) //官费总额（产品配置的官费*订单件数）
                            totalProfitSum: totalProfitSum,//decimal(12,2) //订单毛利润总额（产品价格-供货价格））
                            pfProfitSum: pfProfitSum,//decimal(12,2) //订单平台毛利润总额（(100-渠道利润分成比例)/100 * 订单毛利润总额）
                            channelProfitSum: channelProfitSum//decimal(12,2) //订单渠道分成毛利润总额(订单毛利润总额-平台毛利润总额)
                        }
                        self.updateByWhere(putOrderFields, {where: {orderNo: actionBody.orderNo}}, t);
                        self.orderReceiptVoucherDao.updateByWhere({totalSum: totalSum}, {where: {sourceOrderNo: actionBody.orderNo}}, t);
                    }
                    if (isUpdateProduct > 0) {
                        self.orderproductDao.updateByWhere({serviceItemSnapshot: JSON.stringify(product_info)}, {where: {sourceOrderNo: actionBody.orderNo}}, t);
                    }
                });
            }//未付款进行订单金额修改
            itemResult.data.nclones = tempNclList;
            actionBody.nclones = tempNclList;
        }
        let tmSelectType = actionBody.tmSelectType;
        if (tmSelectType) {
            var dbTm = itemResult.data.tmSelectType;
            var tmKeys = Object.keys(tmSelectType);
            if (dbTm && tmKeys.length > 0) {
                for (let i = 0; i < tmKeys.length; i++) {
                    const iKey = tmKeys[i];
                    if (!tmSelectType[iKey]) {
                        tipsMsg = "修改失败，" + iKey + "不能为空，30030";
                    }
                    if (tmSelectType[iKey] && tmSelectType[iKey] != dbTm[iKey]) {
                        itemResult.data.tmSelectType[iKey] = tmSelectType[iKey].toString();
                    }
                }
            }
        }
        this.putOrderDelivery(itemResult.data, actionBody.orderNo);
        delete actionBody["isGetContact"];
        actionBody.orderStatus = orderItem.orderStatus;

        actionBody.gzwtsUrl = dbApply.gzwtsUrl;//供阿里渠道委托书绑定
        if (orderItem.orderStatus < 4) {
            actionBody.product_info = product_info;
        }
        return system.getResultSuccess(actionBody);
    }

    putOrderDelivery(data, orderNo) {//修改交付信息
        var sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + JSON.stringify(data) + "' where sourceOrderNo='" + orderNo + "'";
        sql = sql.replace('\n', '');
        this.customQuery(sql);
    }

    async addOrderDelivery(data, orderNo, t) {//新增交付信息
        await this.dao.addOrderDelivery(data, orderNo, t);
    }

    async getOrderDelivery(orderNo) {//查询交付信息
        var sql = "select * from `c_order_delivery` where sourceOrderNo='" + orderNo + "'";
        return await this.customQuery(sql);
    }

    async delOrder(pobj, actionBody) {//删除订单
        await this.dao.delOrderByOrderNo(actionBody.orderNo, pobj.appInfo.uapp_id, pobj.userInfo.channel_userid);
        return system.getResultSuccess();
    }

    async delENameOrder(pobj, actionBody) {//删除易名订单
        let res = await this.dao.delOrderByOrderNoEname(actionBody.orderNo);
        console.log("delENameOrder res----", system.getResultSuccess(res))
        return system.getResultSuccess(res);
    }

    //baidureg关闭订单 2020-12-20
    async delOrders(pobj, actionBody) {//删除订单
        var i;
        var len = actionBody.orderNo.length
        for (i = 0; i < len; i++) {
            await this.dao.delOrderByOrderNo(actionBody.orderNo[i], pobj.appInfo.uapp_id, pobj.userInfo.channel_userid);
        }
        return system.getResultSuccess();
    }

    // 2020 0918 lin 新增 根据OrderStatus查询订单
    async queryVOrderByOrderStatusAndItemCode(pobj, actionBody) {
        var sql = "select `id`,`isSolution`,`orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`,"
            + " `invoiceApplyStatus`,`opNotes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,created_at from v_order "
            + " where v_order.uapp_id=:uapp_id";
        var paramWhere = {};
        paramWhere.uapp_id = pobj.appInfo.uapp_id;
        if (actionBody.orderStatus) {
            sql += " and orderStatus=:orderStatus";
            paramWhere.orderStatus = actionBody.orderStatus;
        }
        if (actionBody.itemCode) {
            sql += " and itemCode=:itemCode";
            paramWhere.itemCode = actionBody.itemCode;
        }
        var orderInfo = await this.customQuery(sql, paramWhere);
        // var orderInfo = await this.dao.model.findAll({
        //   where:{
        //     uapp_id: pobj.appInfo.uapp_id,
        //     orderStatus: actionBody.orderStatus,
        //     itemCode: actionBody.itemCode
        //   }
        // });
        return system.getResultSuccess(orderInfo);
    }

    // 2020 0923 lin 新增 根据id修改orderStatus，目前用来商标交易更新订单状态
    async updateOrderStatusById(pobj, actionBody) {
        var orderInfo = await this.dao.model.update({orderStatus: actionBody.orderStatus}, {where: {id: actionBody.orderId}})
        if (!orderInfo) {
            return system.getResult(null, "修改失败");
        }
        return system.getResultSuccess(orderInfo);
    }

    //=================================修改订单信息==============end======================================


    /**
     * 获取付款订单信息
     * @param {*} pobj
     * @param {*} actionBody {orderNo:XXXX}
     */
    async getPayOrderInfo(pobj, actionBody) {
        var productItem = await this.orderproductDao.getItemByOrderNo(actionBody.orderNo, pobj.appInfo.uapp_id);
        if (!productItem) {
            return system.getResult(null, "订单产品数据为空，30090");
        }
        var item = await this.orderReceiptVoucherDao.getItemByOrderNo(actionBody.orderNo, pobj.appInfo.uapp_id);
        if (!item) {
            return system.getResult(null, "订单已经付款成功，请勿重复支付，30000");
        }
        var produceinfo = JSON.parse(productItem.serviceItemSnapshot);
        productItem.id = produceinfo.id;
        productItem.serviceItemSnapshot = null;
        var param = {
            receiptVoucher: item,
            orderProduct: productItem
        }
        return system.getResultSuccess(param);
    }

    /**
     * 修改订单收款信息
     * @param {*} pobj
     * @param {*} actionBody {orderNo:XXXX,trxid:XXX--支付流水号,isPut:1---大于0则进行修改操作,setField:{XXXXX}---修改的字段,receiptVoucherId:XX--收款Id,opType:"wx"}---"wx":"微信","alipay":"支付宝"
     */
    async putReceiptVoucherInfo(pobj, actionBody) {
        var isPut = actionBody.isPut || "";
        if (isPut > 0) {
            await this.orderReceiptVoucherDao.updateByWhere(actionBody.setField, {where: {id: actionBody.receiptVoucherId}});
        }
        return system.getResultSuccess();
    }

    //**************************************获取订单信息**********start**************************************

    async getOrderProductDeliveryByOrderNo(actionBody) {//获取订单产品及交付信息--用于钉钉商标推送
        var result = system.getResultSuccess();
        result.data = {
            actionBody:
                {
                    delivery_content: {},
                    order_info: {orderStatus: 2},
                    product_info: {}
                }
        };

        var sql = "select * from c_order_delivery where sourceOrderNo=:sourceOrderNo";
        var paramWhere = {sourceOrderNo: actionBody.orderNo};
        var list = await this.customQuery(sql, paramWhere);
        if (list && list.length > 0) {
            if (list[0].deliveryContent) {
                result.data.actionBody.delivery_content = list[0].deliveryContent;
            }
        }

        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(actionBody.orderNo);
        if (orderProductItem) {
            result.data.actionBody.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }

        var item = await this.ordercontactsDao.getItemByOrderNo(actionBody.orderNo);
        if (item) {
            result.data.actionBody.delivery_content.orderContact = item;
        }

        return result;
    }

    async getOrderInfo(pobj, actionBody) {//获取订单列表信息
        var pageSize = Number(actionBody.pageSize || 20);
        if (pageSize > 50) {
            pageSize = 50;
        }
        var pageIndex = Number(actionBody.pageIndex || 1);
        var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);

        var paramWhere = {};

        // var sql = "select `isSolution`,`orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`,"
        //   + " `invoiceApplyStatus`,`opNotes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,created_at from v_order where uapp_id=:uapp_id";
        // 2020 0714 lin修改 关联交付表 查询交付信息，用来确认是否已确认方案
        var sql = "select `isSolution`,`orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`,"
            + " `invoiceApplyStatus`,`opNotes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,created_at,c_order_delivery.deliveryContent from v_order "
            + " LEFT JOIN c_order_delivery ON v_order.orderNo = c_order_delivery.sourceOrderNo where v_order.uapp_id=:uapp_id";
        var sqlCount = "select count(1) as dataCount from v_order where uapp_id=:uapp_id";

        paramWhere.uapp_id = pobj.appInfo.uapp_id;
        if (pobj.userInfo.channel_userid) {
            if (pobj.appInfo.app_code == "jd") {
                if (!["syaify", "jd_613f2fd04340f", "13501054442"].includes(pobj.userInfo.channel_userid) && pobj.userInfo.is_admin != 1) {
                    sql += " and channelUserId=:channelUserId";
                    sqlCount += " and channelUserId=:channelUserId";
                    paramWhere.channelUserId = pobj.userInfo.channel_userid;
                }
            } else {
                sql += " and channelUserId=:channelUserId";
                sqlCount += " and channelUserId=:channelUserId";
                paramWhere.channelUserId = pobj.userInfo.channel_userid;
            }
        }
        if (actionBody.channelItemName) {
            sql += " and channelItemName like :channelItemName";
            sqlCount += " and channelItemName like :channelItemName";
            paramWhere.channelItemName = "%" + actionBody.channelItemName.trim() + "%";
        }
        if (actionBody.typeCode) {
            sql += " and pathCode like :typeCode";
            sqlCount += " and pathCode like :typeCode";
            paramWhere.typeCode = "/" + actionBody.typeCode.trim() + "/%";
        }
        if (actionBody.channelServiceNo) {
            sql += " and channelServiceNo like :channelServiceNo";
            sqlCount += " and channelServiceNo like :channelServiceNo";
            paramWhere.channelServiceNo = "%" + actionBody.channelServiceNo.trim() + "%";
        }
        if (actionBody.orderStatus) {
            sql += " and orderStatus=:orderStatus";
            sqlCount += " and orderStatus=:orderStatus";
            paramWhere.orderStatus = actionBody.orderStatus;
        }
        if (actionBody.startTime && actionBody.entTime) {
            var startTime = actionBody.startTime.trim() + " 00:00:00";
            var entTime = actionBody.entTime + " 23:59:59";
            sql += " and created_at >=:startTime and  created_at<=:entTime";
            sqlCount += " and created_at >=:startTime and  created_at<=:entTime";
            paramWhere.startTime = startTime;
            paramWhere.entTime = entTime;
        }

        // sql += " order by id desc LIMIT " + pageSize + " OFFSET " + from;
        // 2020 0714 lin修改 关联交付表 查询交付信息，用来确认是否已确认方案
        sql += " order by v_order.id desc LIMIT " + pageSize + " OFFSET " + from;

        var list = await this.customQuery(sql, paramWhere);
        // 2020 0714 lin 新增 用来处理订单列表的进入详情权限
        for (let i = 0; i < list.length; i++) {
            // 如果没有交付信息跳出
            if (!list[i]["deliveryContent"]) {
                list[i]["isDetail"] = 0;
                delete list[i]["deliveryContent"];
                continue;
            }
            // 如果交付信息状态不等于 待确认方案 || 方案不通过 判断为可进入详情
            if (list[i]["deliveryContent"]["deliveryStatus"] != "dqrfa" && list[i]["deliveryContent"]["deliveryStatus"] != "fabtg") {
                list[i]["isDetail"] = 1;
                delete list[i]["deliveryContent"];
                continue;
            }
            list[i]["isDetail"] = 0;
            delete list[i]["deliveryContent"];
        }
        var result = system.getResultSuccess(list);

        var tmpResultCount = await this.customQuery(sqlCount, paramWhere);

        result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

        return result;

    }

    /**
     * 订单统计（产品维度）
     * @param pobj
     * @returns {Promise<void>}
     */
    async getOrdersStatisticsByUappId(pobj) {
        let ac = pobj.actionBody;
        let sql = `SELECT uapp_id,count(*) count,DATE_FORMAT(created_at,'%Y-%m-%d') time FROM c_order_info WHERE deleted_at is null `;
        let whereParam = {};
        if (ac.start && ac.end) {
            sql += ` AND created_at >= :start AND created_at <= :end`;
            whereParam.start = ac.start;
            whereParam.end = ac.end;
        }
        if (ac.type_code) {
            sql += ` AND typeCode = :type_code`;
            whereParam.type_code = ac.type_code;
        }
        if (ac.status) {
            sql += ` AND orderStatus = :status`;
            whereParam.status = ac.status;
        }
        sql += ` GROUP BY uapp_id,DATE_FORMAT(created_at,'%Y-%m-%d') ORDER BY created_at ASC`
        let result = await this.customQuery(sql, whereParam);
        return system.getResultSuccess(result);
    }

    /**
     * 订单统计（产品维度）
     * @param pobj
     * @returns {Promise<void>}
     */
    async getOrdersStatisticsByProduct(pobj) {
        let ac = pobj.actionBody;
        let sql = `SELECT b.channelItemName typeCode,a.uapp_id,count( DISTINCT(a.orderNo)) count FROM c_order_info a left join c_order_product b on a.orderNo = b.sourceOrderNo WHERE a.deleted_at is null and  b.itemCode is not null `;
        let whereParams = {};
        if (ac.start && ac.end) {
            sql += ` and a.created_at >= :start and a.created_at <= :end `;
            whereParams.start = ac.start;
            whereParams.end = ac.end;
        }
        sql += ` GROUP BY b.channelItemName,a.uapp_id`;
        let result = await this.customQuery(sql, whereParams);
        return system.getResultSuccess(result);
    }

    /**
     * 订单对比
     * @param pobj
     * @returns {Promise<void>}
     */
    async getOrdersComparison(pobj) {
        let ab = pobj.actionBody;
        let sql1 = `select count(DISTINCT(a.orderNo)) count from c_order_info a left join c_order_product b on a.orderNo = b.sourceOrderNo where a.deleted_at is null `;
        let whereParams = {};
        if (ab.startNow && ab.endNow) {
            sql1 += ` and a.created_at >= :start and a.created_at <= :end`;
            whereParams.start = ab.startNow;
            whereParams.end = ab.endNow;
        }
        if (ab.uapp_id) {
            sql1 += ` and a.uapp_id = :uapp_id`;
            whereParams.uapp_id = ab.uapp_id;
        }
        if (ab.type_code) {
            sql1 += ` and b.itemCode = :type_code`;
            whereParams.type_code = ab.type_code;
        }
        let totalRet1 = await this.customQuery(sql1, whereParams);
        if (ab.startLast && ab.endLast) {
            whereParams.start = ab.startLast;
            whereParams.end = ab.endLast;
        }
        let totalRet2 = await this.customQuery(sql1, whereParams);
        let result = {
            now: {
                total: totalRet1[0].count,
            },
            last: {
                total: totalRet2[0].count,
            }
        }
        return system.getResultSuccess(result);
    }

    /**
     * 启服通展板 订单列表
     * @param pobj
     * @returns {Promise<void>}
     */
    async getOrdersComparisonList(pobj) {
        let ab = pobj.actionBody;
        let pageSize = Number(ab.pageSize || 20);
        let pageIndex = Number(ab.pageIndex || 1);
        let from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
        if (pageSize > 50) {
            pageSize = 50;
        }
        let listSql = `SELECT
                  DISTINCT(a.orderNo),
                  a.id,
                  a.channelOrderNo,
                  d.app_name,
                  b.itemName,
                  a.totalSum,
                  a.orderStatusName,
                  c.contactName,
                  c.mobile,
                  a.isPushNum,
                  a.pushStatus,
                  a.created_at
                  FROM
                  center_order.c_order_info a
                  LEFT JOIN center_order.c_order_product b ON a.orderNo = b.sourceOrderNo
                  LEFT JOIN center_order.c_order_contacts c on a.orderNo = c.sourceOrderNo
                  LEFT JOIN center_app.p_app d on a.uapp_id = d.uapp_id
                  WHERE
                  a.deleted_at IS NULL`;
        let totalSql = `select count(DISTINCT(a.orderNo)) count from c_order_info a left join c_order_product b on a.orderNo = b.sourceOrderNo LEFT JOIN center_order.c_order_contacts c on a.orderNo = c.sourceOrderNo where a.deleted_at is null `
        let whereParams = {};
        if (ab.start && ab.end) {
            listSql += ` and a.created_at >= :start and a.created_at <= :end`;
            totalSql += ` and a.created_at >= :start and a.created_at <= :end`;
            whereParams.start = ab.start;
            whereParams.end = ab.end;
        }
        if (ab.uapp_id) {
            listSql += ` and a.uapp_id = :uapp_id`;
            totalSql += ` and a.uapp_id = :uapp_id`;
            whereParams.uapp_id = ab.uapp_id;
        }
        if (ab.status) {
            listSql += ` and a.orderStatus = :status`;
            totalSql += ` and a.orderStatus = :status`;
            whereParams.status = ab.status;
        }
        if (ab.type_code) {
            listSql += ` and b.itemCode = :type_code`;
            totalSql += ` and b.itemCode = :type_code`;
            whereParams.type_code = ab.type_code;
        }
        if (ab.fuzzy_code) {
            listSql += ` and ( a.orderNo like :fuzzy_code or a.channelOrderNo like :fuzzy_code or c.mobile like :fuzzy_code)`;
            totalSql += ` and ( a.orderNo like :fuzzy_code or a.channelOrderNo like :fuzzy_code or c.mobile like :fuzzy_code)`;
            whereParams.fuzzy_code = "%" + ab.fuzzy_code + "%";
        }
        listSql += ` order by a.created_at desc`;
        if (pageSize != -1) {
            listSql += ` limit ${pageSize} offset ${from}`;
        }
        let result = await this.customQuery(listSql, whereParams);
        let total = await this.customQuery(totalSql, whereParams);
        result = result.map(t => {
            if (t.itemName && t.itemName.endsWith('市')) {
                t.itemName = '公司注册';
            }
            if (t.itemName && t.itemName.endsWith('区')) {
                t.itemName = '云上园区注册';
            }
            return t;
        })
        let data = {
            total: total[0].count,
            rows: result
        }
        return system.getResult(data);
    }

    //根据合同号，获取子订单
    async getOrderListByOrderServiceNo(pobj) {
        let sql = "select `orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`," +
            " `itemCode','invoiceApplyStatus`,`opNotes`,`notes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,`serviceItemSnapshot`,`orderSnapshot`,created_at" +
            " from v_order where uapp_id =:uapp_id and orderServiceNo =:orderServiceNo"
        let paramWhere = {
            uapp_id: pobj.appInfo.uapp_id,
            orderServiceNo: pobj.orderNo ? pobj.orderNo : pobj.actionBody.orderServiceNo
        }
        let list = await this.customQuery(sql, paramWhere);
        if (!list || list.length == 0) {
            return system.getResult(null, "订单数据为空，30200");
        }
        var result = system.getResultSuccess(list);
        return result;
    }

    async getOrderServiceNoByOrderNo(pobj, actionBody) {//根据订单号获取订单信息
        var sql = "select `orderNo`,orderServiceNo from v_order where orderNo=:orderNo  LIMIT 1";
        var paramWhere = {orderNo: actionBody.orderNo};
        var list = await this.customQuery(sql, paramWhere);
        if (!list || list.length == 0) {
            return system.getResult(null, "订单数据为空，30200");
        }
        var result = system.getResultSuccess(list[0]);
        return result;
    }

    async getOrderDetails(pobj, actionBody) {//获取订单详情信息
        var sql = "select `orderNo`,`channelServiceNo`,`channelOrderNo`,`channelUserId`,`ownerUserId`,`payTime`,`quantity`,`serviceQuantity`,`orderStatusName`,`orderStatus`,`totalSum`,`payTotalSum`,`refundSum`," +
            " `invoiceApplyStatus`,`opNotes`,`notes`,`channelItemCode`,`channelItemName`,`price`,priceDesc,priceTypeName,channelItemAppendName,`serviceItemCode`,`picUrl`,`serviceItemSnapshot`,`orderSnapshot`,created_at from " +
            " v_order where uapp_id=:uapp_id and orderNo=:orderNo  LIMIT 1";
        var paramWhere = {uapp_id: pobj.appInfo.uapp_id, orderNo: actionBody.orderNo};
        var list = await this.customQuery(sql, paramWhere);
        if (!list || list.length == 0) {
            return system.getResult(null, "订单数据为空，30200");
        }
        var result = system.getResultSuccess(list[0]);
        return result;
    }

    async getOrderByOrderNo(pobj, actionBody) {//根据订单号获取订单详情信息
        let orderItem = await this.dao.getItemStatusByOrderNo(actionBody.orderNo);
        if (!orderItem) {
            return system.getResult(null, "order data is empty!");
        }
        let result = system.getResultSuccess(orderItem);
        return result;
    }

    async getOrderByChannelOrderNo(pobj, actionBody) {// 根据渠道订单号获取订单
        var app = pobj.appInfo;
        let orderItem = await this.findOne({channelOrderNo: actionBody.bizId, uapp_id: app.uapp_id});
        if (!orderItem) {
            return system.getResult(null, "order data is empty");
        }
        let result = system.getResultSuccess(orderItem);
        return result;
    }

    async getOrderDeliveryInfo(pobj, actionBody) {//获取订单交付信息
        var sql = "select * from c_order_delivery where sourceOrderNo=:sourceOrderNo";
        var paramWhere = {sourceOrderNo: actionBody.orderNo};
        var list = await this.customQuery(sql, paramWhere);
        var result = system.getResultSuccess();
        result.data = {};
        if (list && list.length > 0) {
            if (list[0].deliveryContent) {
                result.data = list[0].deliveryContent;
            }
        }
        result.data.orderContact = null;
        if (!actionBody.isGetContact) {
            var item = await this.ordercontactsDao.getItemByOrderNo(actionBody.orderNo);
            if (item) {
                result.data.orderContact = item;
            }
        }//是否获取联系人，isGetContact有值则不获取
        return result;
    }

    async getOrderDeliveryFlowInfo(pobj, actionBody) {//获取订单交付流程信息
        var sql = "select * from c_delivery_official_flow where sourceOrderNo=:sourceOrderNo";
        var paramWhere = {sourceOrderNo: actionBody.sourceOrderNo};
        var list = await this.customQuery(sql, paramWhere);
        var result = system.getResultSuccess();
        if (list && list.length > 0) {
            if (list[0].officialFlow) {
                result.data = list[0].officialFlow;
            }
        }
        return result;
    }

    async getOrderDeliveryFlowList(pobj, actionBody) {//获取订单交付流程列表信息
        var sql = "select * from c_delivery_official_flow where sourceOrderNo IN(:sourceOrderNo)";
        var paramWhere = {sourceOrderNo: actionBody.sourceOrderNoList};
        var list = await this.customQuery(sql, paramWhere);
        var tmpList = [];
        if (list && list.length > 0) {
            for (let index = 0; index < list.length; index++) {
                const element = list[index];
                if (element.officialFlow) {
                    tmpList.push({
                        sourceOrderNo: element.sourceOrderNo,
                        flowList: element.officialFlow
                    });
                }
            }
        }
        return system.getResultSuccess(tmpList);
    }

    async getOrderLogInfo(pobj, actionBody) {//获取订单日志信息
        var list = await this.flowlogDao.getlogListBySourceOrderNo(actionBody.sourceOrderNo);
        return system.getResultSuccess(list);
    }

    //**************************************/获取订单信息**********end**************************************

    //-------------------------------服务商通知订单流程-------------start----------------
    async icOrderStatusNotify(pobj, actionBody) {//峰擎通知工商办理状态
        var item = await this.dao.getItemStatusByOrderNo(actionBody.orderNo);
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus == 1) {
            return system.getResult(null, "order status is unpay!");
        }
        var updateDeliveryInfo = {
            orderDeliveryStatus: actionBody.orderDeliveryStatus,
            orderDeliveryStatusName: actionBody.orderDeliveryStatusName,
            updated: actionBody.updated,
            flowList: []
        };
        pobj.actionBody.sourceOrderNo = actionBody.orderNo;
        var deliveryInfo = await this.getOrderDeliveryFlowInfo(pobj);
        var addi = 0;
        if (deliveryInfo.status == 0 && deliveryInfo.data && deliveryInfo.data.flowList.length > 0) {
            updateDeliveryInfo.flowList = deliveryInfo.data.flowList;
        } else {
            updateDeliveryInfo = {
                orderDeliveryStatus: "已下单",
                orderDeliveryStatusName: "已下单",
                updated: item.created_at,
                flowList: [{
                    orderDeliveryStatus: "已下单",
                    orderDeliveryStatusName: "已下单",
                    updated: item.created_at
                }]
            };
            addi = 1;
        }
        updateDeliveryInfo.updated = actionBody.updated;
        updateDeliveryInfo.orderDeliveryStatus = actionBody.orderDeliveryStatus;
        var tempList = actionBody.orderDeliveryStatusName.split('-');
        updateDeliveryInfo.orderDeliveryStatusName = tempList[tempList.length - 1];

        var dataIndex = updateDeliveryInfo.flowList.findIndex(f => f.orderDeliveryStatus == actionBody.orderDeliveryStatus);
        if (dataIndex > -1) {
            updateDeliveryInfo.flowList[dataIndex].orderDeliveryStatusName = actionBody.orderDeliveryStatusName;
            updateDeliveryInfo.flowList[dataIndex].updated = actionBody.updated;
        } else {
            updateDeliveryInfo.flowList.push({
                orderDeliveryStatus: actionBody.orderDeliveryStatus,
                orderDeliveryStatusName: actionBody.orderDeliveryStatusName,
                updated: actionBody.updated
            });
        }
        var orderLog = {
            uapp_id: item.uapp_id,
            sourceOrderNo: actionBody.orderNo,
            created_at: actionBody.updated,
            opContent: "您的订单办理流程更新为【" + updateDeliveryInfo.orderDeliveryStatusName + "】",
            isShow: 1
        };
        await this.flowlogDao.create(orderLog);
        var sql = null;
        if (addi > 0) {
            await this.dao.updateByWhere({orderStatus: 4}, {where: {id: item.id}});
            sql = "INSERT INTO  `c_delivery_official_flow` (`sourceOrderNo`,`officialFlow`) VALUE('" +
                actionBody.orderNo + "','" + JSON.stringify(updateDeliveryInfo) + "')";
        } else {
            if (updateDeliveryInfo.orderDeliveryStatusName == "证件邮寄环节") {
                await this.dao.updateByWhere({orderStatus: 8}, {where: {id: item.id}});
            }
            sql = "UPDATE `c_delivery_official_flow`  SET officialFlow ='" + JSON.stringify(updateDeliveryInfo) + "' where sourceOrderNo='" + actionBody.orderNo + "'";
            sql = sql.replace('\n', '');
        }
        this.customQuery(sql);
        return system.getResultSuccess();
    }

    async updateTmStatus(actionBody) {
        var self = this;
        if (!actionBody.tbCode) {
            return system.getResult(null, "处理失败，tbCode不能为空，30160");
        }
        if (!actionBody.tmStatus) {
            return system.getResult(null, "处理失败，tmStatus不能为空，30163");
        }
        if (!actionBody.tmStatusName) {
            actionBody.tmStatusName = uiconfig.config.pdict.official_type[actionBody.tmStatus]
            if (!actionBody.tmStatusName) {
                return system.getResult(null, "处理失败，tmStatusName不能为空，30165");
            }
        }
        var orderItem = await this.dao.getItemStatusByOrderNo(actionBody.orderNo);
        if (!orderItem) {
            return system.getResult(null, "修改失败，修改的数据为空，30170");
        }
        if (orderItem.orderStatus == 1) {
            return system.getResult(null, "修改失败，修改的订单数据未未付款数据为空，30175");
        }
        actionBody.orderContact = 1;
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, actionBody);
        if (deliveryInfoResult.status != 0 || !deliveryInfoResult.data) {
            return system.getResult(null, "修改失败，订单对应的产品数据为空，30180");
        }
        var deliveryInfo = deliveryInfoResult.data;
        var tbCodeIndex = deliveryInfo.nclones.findIndex(f => f.tbCode == actionBody.tbCode);
        if (tbCodeIndex < 0) {
            return system.getResult(null, "修改失败，订单对应的提报数据为空，30185");
        }
        deliveryInfo.nclones[tbCodeIndex].tmStatus = actionBody.tmStatus;
        deliveryInfo.nclones[tbCodeIndex].tmStatusName = actionBody.tmStatusName;
        var updateOrderFields = {};
        var orderLog = {
            uapp_id: orderItem.uapp_id,
            sourceOrderNo: actionBody.orderNo,
            created_at: new Date(),
            opContent: "尊敬的用户，您的商标：“" + deliveryInfo.tm.tmName + "”第" + deliveryInfo.nclones[tbCodeIndex].code + "类，办理状态更新为【" + actionBody.tmStatusName + "】",
            isShow: 1
        };
        var oldDeliveryStatus = deliveryInfo.deliveryStatus;
        if (actionBody.tmStatus == "WAITCOMMIT" || actionBody.tmStatus == "ddj") {
            updateOrderFields.orderStatus = 4;
            deliveryInfo.deliveryStatus = "ddj";
            deliveryInfo.deliveryStatusName = "待递交";
            deliveryInfo.nclones[tbCodeIndex].tmStatus = "ddj";
            deliveryInfo.nclones[tbCodeIndex].tmStatusName = "待递交";
            orderLog.opContent = "尊敬的用户，您的商标：“" + deliveryInfo.tm.tmName + "”第" + deliveryInfo.nclones[tbCodeIndex].code + "类，办理状态更新为【待递交】";
        }//待提交
        else if (actionBody.tmStatus == "ROBOT" || actionBody.tmStatus == "ROBOTPAY") {
            deliveryInfo.deliveryStatus = "ydj";
            deliveryInfo.deliveryStatusName = "已递交";
            deliveryInfo.nclones[tbCodeIndex].tmStatus = "ydj";
            deliveryInfo.nclones[tbCodeIndex].tmStatusName = "已递交";
            orderLog.opContent = "尊敬的用户，您的商标：“" + deliveryInfo.tm.tmName + "”第" + deliveryInfo.nclones[tbCodeIndex].code + "类，办理状态更新为【已递交】";
        }//已提交--自己系统中存在此状态（升级后不存在，目前没有升级）
        else if (actionBody.tmStatus == "FILLEXCEPTION") {
            actionBody.submitTime = actionBody.submitTime || new Date();
            deliveryInfo.deliveryStatus = "djyc";
            deliveryInfo.deliveryStatusName = "递交异常";
            deliveryInfo.nclones[tbCodeIndex].tmStatusName = "递交异常";
            orderLog.opContent = "尊敬的用户，您的商标：“" + deliveryInfo.tm.tmName + "”第" + deliveryInfo.nclones[tbCodeIndex].code + "类，办理状态更新为【递交异常】";
        }//已收提交
        else if (actionBody.tmStatus == "RECVCOMMIT" || actionBody.tmStatus == "ydj") {
            actionBody.submitTime = actionBody.submitTime || new Date();
            updateOrderFields.orderStatus = 8;
            deliveryInfo.deliveryStatus = "ywc";
            deliveryInfo.deliveryStatusName = "已完成";
            deliveryInfo.nclones[tbCodeIndex].tmStatusName = "商标局已收提交";
            orderLog.opContent = "尊敬的用户，您的商标：“" + deliveryInfo.tm.tmName + "”第" + deliveryInfo.nclones[tbCodeIndex].code + "类，办理状态更新为【商标局已收提交】";
        }//已收提交

        if (deliveryInfo.deliveryStatus != oldDeliveryStatus) {
            var deliveryStatusList = deliveryInfo.deliveryStatusList;
            if (deliveryStatusList && deliveryStatusList.length > 0) {
                var deliveryStatusIndex = deliveryStatusList.findIndex(f => f.deliveryStatus == deliveryInfo.deliveryStatus);
                if (deliveryStatusIndex < 0) {
                    deliveryStatusList.push({
                        deliveryStatus: deliveryInfo.deliveryStatus,
                        deliveryStatusName: deliveryInfo.deliveryStatusName,
                        deliveryUpdated: new Date()
                    });
                    deliveryInfo.deliveryStatusList = deliveryStatusList;
                }
            }
        }//增加流程状态列表数据

        try {
            await self.db.transaction(async function (t) {
                if (Object.keys(updateOrderFields).length > 0) {
                    self.updateByWhere(updateOrderFields, {where: {orderNo: actionBody.orderNo}}, t);
                }
                await self.flowlogDao.create(orderLog, t);
            });
            if (actionBody.submitTime) {
                deliveryInfo.nclones[tbCodeIndex].submitTime = actionBody.submitTime;
            }//修改提报时间
            if (actionBody.registNumInfo && actionBody.registNumInfo.tmRegistNum) {
                deliveryInfo.nclones[tbCodeIndex].tmRegistNum = actionBody.registNumInfo.tmRegistNum;
            }//更新商标申请号
            if (actionBody.officialInfo) {
                this.updateTmOfficialInfo(actionBody);
            }//更新商标官文
            deliveryInfo.opNotes = actionBody.opNotes || "";
            this.putOrderDelivery(deliveryInfo, actionBody.orderNo);

            //商标状态推送 360
            if (orderItem.uapp_id == 50) {
                actionBody.deliveryInfo = deliveryInfo;
                this.push360Sve.pushTmStatus(actionBody);
                this.push360Sve.sendMessage(actionBody)
            }
        } catch (error) {
            console.log("error------------------------", e.stack);
        }
        return system.getResultSuccess();
    }

    async updateTmOfficialInfo(actionBody) {//更新商标官文信息
        var flowList = [];
        actionBody.sourceOrderNo = actionBody.officialInfo.tmRegistNum;
        var deliveryFlowInfo = await this.getOrderDeliveryFlowInfo(null, actionBody);
        var addi = 0;
        if (!deliveryFlowInfo.data) {
            flowList.push({
                updated: actionBody.officialInfo.updated,
                uploadFileName: actionBody.officialInfo.uploadFileName,
                returnReceiptUrl: actionBody.officialInfo.returnReceiptUrl,
                tmStatus: actionBody.tmStatus,
                tmStatusName: actionBody.tmStatusName
            });
            addi++;
        } else {
            flowList = deliveryFlowInfo.data;
        }
        var dataIndex = flowList.findIndex(f => f.tmStatus == actionBody.tmStatus);
        if (dataIndex < 0) {
            flowList.push({
                updated: actionBody.officialInfo.updated,
                uploadFileName: actionBody.officialInfo.uploadFileName,
                returnReceiptUrl: actionBody.officialInfo.returnReceiptUrl,
                tmStatus: actionBody.tmStatus,
                tmStatusName: actionBody.tmStatusName
            });
        }
        var sql = null;
        if (addi > 0) {
            sql = "INSERT INTO  `c_delivery_official_flow` (`sourceOrderNo`,`officialFlow`) VALUE('" +
                actionBody.officialInfo.tmRegistNum + "','" + JSON.stringify(flowList) + "')";
        } else {
            sql = "UPDATE `c_delivery_official_flow`  SET officialFlow ='" + JSON.stringify(flowList) + "' where sourceOrderNo='" + actionBody.officialInfo.tmRegistNum + "'";
            sql = sql.replace('\n', '');
        }
        this.customQuery(sql);
        return system.getResultSuccess();
    }

    async opOrderPayCallBackTl(parmas, appInfo) {//操作订单付款回调---通联
        var item = await this.dao.getItemStatusByOrderNo(parmas.orderNo)
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus > 1) {
            return system.getResult(null, "order status is pay!");
        }
        var self = this;
        await self.db.transaction(async function (t) {
            await self.dao.updateByWhere({orderStatus: 2, payTime: new Date()}, {where: {orderNo: parmas.orderNo}}, t);
            var putFields = {
                auditStatus: "tg",
                accountType: parmas.pay_type,
                passTradeNo: parmas.trxid || "",//通道的统一订单号
                payOrderNo: parmas.chnltrxid || "",//支付凭证流水单号，如：微信支付凭证单号
                busPayOrderCode: parmas.out_trade_no || "",//业务支付订单号
                buyerOpenId: parmas.openid || "",//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
                buyerAliLogonId: parmas.buyer_logon_id || "",//买家支付宝账号
                notes: parmas.paytime || ""//备注下支付时间
            };
            await self.orderReceiptVoucherDao.updateByWhere(putFields, {where: {sourceOrderNo: parmas.orderNo}}, t);
            var orderLog = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,
                opContent: "您成功支付了订单，请等待服务商服务",
                isShow: 1
            };
            await self.flowlogDao.create(orderLog, t);
            var moneyObj = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,   // 来源单号
                channelUserId: item.channelUserId,
                ownerUserId: item.ownerUserId,
                accountType: parmas.pay_type,//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: new Date(),//凭单时间
                recvAmount: item.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            var moneyJourney = await self.moneyJourneyDao.create(moneyObj, t);
        });
        item.orderStatus = 2;//已付款
        var resultParams = {
            order_info: item,
            delivery_content: null,//包含订单联系人orderContact
            product_info: null
        };
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, parmas);
        if (deliveryInfoResult && deliveryInfoResult.status == 0) {
            resultParams.delivery_content = deliveryInfoResult.data;
        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(parmas.orderNo);
        if (orderProductItem) {
            resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }
        return system.getResultSuccess(resultParams);
    }

    async opOrderPayCallBackAliDing(parmas, appInfo) {//操作订单付款回调---阿里钉钉-钉钉接入的搁浅
        var item = await this.dao.getItemStatusByOrderNo(parmas.orderNo)
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus > 1) {
            return system.getResult(null, "order status is pay!");
        }
        var self = this;
        await self.db.transaction(async function (t) {
            await self.dao.updateByWhere({
                orderStatus: 2,
                payTime: parmas.gmt_payment
            }, {where: {orderNo: parmas.orderNo}}, t);
            var putFields = {
                auditStatus: "tg",
                accountType: parmas.pay_type,
                passTradeNo: parmas.notify_id || "",//通知校验ID
                payOrderNo: parmas.trade_no || "",//支付凭证流水单号，如：微信支付凭证单号--该交易在支付宝系统中的交易流水号。最短16位，最长64位。
                busPayOrderCode: parmas.out_trade_no || "",//业务支付订单号
                buyerOpenId: parmas.buyer_id || "",//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
                buyerAliLogonId: parmas.buyer_email || "",//买家支付宝账号
                updated_at: parmas.gmt_payment,//该笔交易的买家付款时间。格式为yyyy-MM-dd HH:mm:ss。
                notes: parmas.gmt_create || ""//该笔交易创建的时间。格式为yyyy-MM-dd HH:mm:ss。
            };
            await self.orderReceiptVoucherDao.updateByWhere(putFields, {where: {sourceOrderNo: parmas.orderNo}}, t);
            var orderLog = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,
                opContent: "您成功支付了订单，请等待服务商服务",
                isShow: 1
            };
            await self.flowlogDao.create(orderLog, t);
            var moneyObj = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,   // 来源单号
                channelUserId: item.channelUserId,
                ownerUserId: item.ownerUserId,
                accountType: parmas.pay_type,//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: parmas.gmt_payment,//new Date(),//凭单时间
                recvAmount: item.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            await self.moneyJourneyDao.create(moneyObj, t);
        });
        // 2020 0717 lin新增 在回调处增加客户销售分布地区统计
        item.orderStatus = 2;//已付款
        var resultParams = {
            order_info: item,
            delivery_content: null,//包含订单联系人orderContact
            product_info: null
        };
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, parmas);
        if (deliveryInfoResult && deliveryInfoResult.status == 0) {
            resultParams.delivery_content = deliveryInfoResult.data;
            // 2020 0717 lin新增 在回调处增加客户销售分布地区统计
            if (deliveryInfoResult.data.apply) {
                if (deliveryInfoResult.data.apply.applyAddr) {
                    var applyAddr = deliveryInfoResult.data.apply.applyAddr
                    // 获取地址数组 该setting数组 与orderRegion province相同
                    var addArr = settings.addArr();
                    for (var i = 0; i < addArr.length; i++) {
                        if (applyAddr.indexOf(addArr[i]) >= 0) {
                            var sql = "update c_order_region set count=count+1 where province=:province";
                            // 修改条件 省名字相同，appid相同
                            var paramWhere = {where: {province: addArr[i], uapp_id: item.uapp_id}};
                            var updateFields = {
                                count: sequelize.literal('count+1')
                            }
                            await this.orderRegionDao.updateByWhere(updateFields, paramWhere)
                        }
                    }
                }
            }

        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(parmas.orderNo);
        if (orderProductItem) {
            resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }
        return system.getResultSuccess(resultParams);
    }

    async opOrderPayCallBackWX(parmas, appInfo) {//操作订单付款回调---微信
        var item = await this.dao.getItemStatusByOrderNo(parmas.orderNo)
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus > 1) {
            return system.getResult(null, "order status is pay!");
        }
        var self = this;
        await self.db.transaction(async function (t) {
            await self.dao.updateByWhere({
                orderStatus: 2,
                payTime: parmas.time_end
            }, {where: {orderNo: parmas.orderNo}}, t);
            var putFields = {
                auditStatus: "tg",
                accountType: parmas.pay_type,
                passTradeNo: parmas.transaction_id || "",//通知校验ID
                payOrderNo: parmas.transaction_id || "",//支付凭证流水单号，如：微信支付凭证单号--该交易在支付宝系统中的交易流水号。最短16位，最长64位。
                busPayOrderCode: parmas.out_trade_no || "",//业务支付订单号
                buyerOpenId: parmas.appid || "",//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
                buyerAliLogonId: parmas.mch_id || "",//买家支付宝账号
                updated_at: parmas.time_end,//该笔交易的买家付款时间。格式为yyyy-MM-dd HH:mm:ss。
                notes: parmas.gmt_create || ""//该笔交易创建的时间。格式为yyyy-MM-dd HH:mm:ss。
            };
            await self.orderReceiptVoucherDao.updateByWhere(putFields, {where: {sourceOrderNo: parmas.orderNo}}, t);
            var orderLog = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,
                opContent: "您成功支付了订单，请等待服务商服务",
                isShow: 1
            };
            await self.flowlogDao.create(orderLog, t);
            var moneyObj = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,   // 来源单号
                channelUserId: item.channelUserId,
                ownerUserId: item.ownerUserId,
                accountType: parmas.pay_type,//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: parmas.time_end,//new Date(),//凭单时间
                recvAmount: item.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            await self.moneyJourneyDao.create(moneyObj, t);
        });
        item.orderStatus = 2;//已付款
        var resultParams = {
            order_info: item,
            delivery_content: null,//包含订单联系人orderContact
            product_info: null
        };
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, parmas);
        if (deliveryInfoResult && deliveryInfoResult.status == 0) {
            resultParams.delivery_content = deliveryInfoResult.data;
        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(parmas.orderNo);
        if (orderProductItem) {
            resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }
        return system.getResultSuccess(resultParams);
    }

    async opOrderPayCallBackChannel(parmas, appInfo) {//操作订单付款回调
        var item = await this.dao.getItemStatusByOrderNo(parmas.orderNo)
        if (!item) {
            return system.getResult(null, "order data is empty!");
        }
        if (item.orderStatus > 1) {
            return system.getResultSuccess(null, "order status is pay!");
        }
        if (item.payTotalSum > parmas.payTotalSum) {
            return system.getResultFail(-1, '支付金额有误！')
        }
        var self = this;
        await self.db.transaction(async function (t) {
            await self.dao.updateByWhere({
                orderStatus: 2,
                payTime: parmas.time_end
            }, {where: {orderNo: parmas.orderNo}}, t);
            var putFields = {
                auditStatus: "tg",
                accountType: parmas.pay_type,
                passTradeNo: parmas.transaction_id || "",//通知校验ID
                payOrderNo: parmas.payOrderNo || "",//支付凭证流水单号，如：微信支付凭证单号--该交易在支付宝系统中的交易流水号。最短16位，最长64位。
                busPayOrderCode: parmas.out_trade_no || "",//业务支付订单号
                buyerOpenId: parmas.appid || "",//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
                buyerAliLogonId: parmas.mch_id || "",//买家支付宝账号
                updated_at: new Date(),//该笔交易的买家付款时间。格式为yyyy-MM-dd HH:mm:ss。
                notes: parmas.gmt_create || ""//该笔交易创建的时间。格式为yyyy-MM-dd HH:mm:ss。
            };
            await self.orderReceiptVoucherDao.updateByWhere(putFields, {where: {sourceOrderNo: parmas.orderNo}}, t);
            var orderLog = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,
                opContent: "您成功支付了订单，请等待服务商服务",
                isShow: 1
            };
            await self.flowlogDao.create(orderLog, t);
            var moneyObj = {
                uapp_id: appInfo.uapp_id,
                sourceOrderNo: parmas.orderNo,   // 来源单号
                channelUserId: item.channelUserId,
                ownerUserId: item.ownerUserId,
                accountType: parmas.pay_type,//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
                directionType: "sr",//凭单类型,"sr": "收","zc": "支"
                voucherDate: parmas.time_end || new Date(),//new Date(),//凭单时间
                recvAmount: item.totalSum,//收总额
                sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
                auditStatus: "tg",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
            };
            await self.moneyJourneyDao.create(moneyObj, t);
        });
        item.orderStatus = 2;//已付款
        var resultParams = {
            order_info: item,
            delivery_content: null,//包含订单联系人orderContact
            product_info: null
        };
        var deliveryInfoResult = await this.getOrderDeliveryInfo(null, parmas);
        if (deliveryInfoResult && deliveryInfoResult.status == 0) {
            resultParams.delivery_content = deliveryInfoResult.data;
        }
        var orderProductItem = await this.orderproductDao.getItemInfoByOrderNo(parmas.orderNo);
        if (orderProductItem) {
            resultParams.product_info = JSON.parse(orderProductItem.serviceItemSnapshot);
        }
        return system.getResultSuccess(resultParams);
    }

    //-------------------------------服务商通知订单流程-------------end----------------
    //商标方案确认
    async tmConfirm(pobj) {
        var ab = pobj.actionBody;
        var self = this;
        var user = pobj.userInfo;
        var app = pobj.appInfo;
        if (!user || !user.id) {
            return system.getResultFail(-100, "未知用户");
        }
        if (!app || !app.id) {
            return system.getResultFail(-100, "未知渠道");
        }
        var channelUserId = user.channel_userid;
        var orderNo = ab.orderNo;
        var isConfirm = ab.isConfirm;
        if (!channelUserId) {
            return system.getResultFail(-101, "渠道用户id不能为空");
        }
        if (!orderNo) {
            return system.getResultFail(-102, "订单号不能为空");
        }
        if (!isConfirm) {
            return system.getResultFail(-103, "确认码不能为空");
        }
        //获取订单信息
        var orderinfo = await this.dao.model.findOne({
            where: {orderNo: orderNo, uapp_id: app.uapp_id}, raw: true
        });
        if (!orderinfo || !orderinfo.id) {
            return system.getResultFail(-110, "未知订单信息");
        }
        if (orderinfo.isSolution != 1) {
            return system.getResultFail(-111, "该订单无方案，不能执行此操作");
        }
        //获取交付单信息
        var orderdeliveryRes = await this.getOrderDelivery(orderNo);
        if (!orderdeliveryRes || orderdeliveryRes.length < 1) {
            return system.getResultFail(-104, "未知订单交付信息");
        }
        var orderdelivery = orderdeliveryRes[0];
        var deliveryContent = orderdelivery.deliveryContent;
        // if (!deliveryContent || !deliveryContent.deliveryStatus || deliveryContent.deliveryStatus != "dqrfa") {
        //   return system.getResultFail(-105, "方案确认失败，方案交付状态错误");
        // }
        if (!deliveryContent.deliveryStatusList) {
            deliveryContent.deliveryStatusList = [];
        }
        return await self.db.transaction(async function (t) {
            var orderLog = {
                uapp_id: app.uapp_id,
                sourceOrderNo: orderNo,
                opContent: "商标方案确认",
                isShow: 1
            };
            var orderInfoObj = {
                id: orderinfo.id
            };
            if (ab.notes) {
                orderInfoObj["opNotes"] = ab.notes;
            }
            if (isConfirm == "0") {
                if (!ab.notes) {
                    return system.getResultFail(-106, "方案确认失败，不通过原因不能为空");
                }
                deliveryContent["deliveryStatus"] = "fabtg";
                deliveryContent["deliveryStatusName"] = "方案不通过";
                deliveryContent["opNotes"] = ab.notes;
                orderLog["opContent"] = "商标方案不通过";
                deliveryContent.deliveryStatusList.push({
                    deliveryStatus: "fabtg",
                    deliveryStatusName: "方案不通过",
                    deliveryUpdated: new Date()
                });
                orderInfoObj["isSolution"] = 0;
            }
            if (isConfirm == "1") {
                deliveryContent["deliveryStatus"] = "dsh";
                deliveryContent["deliveryStatusName"] = "待审核";
                deliveryContent["opNotes"] = ab.notes || "";
                orderLog["opContent"] = "商标方案确认通过";
                deliveryContent.deliveryStatusList.push({
                    deliveryStatus: "dsh",
                    deliveryStatusName: "待审核",
                    deliveryUpdated: new Date()
                });
                orderInfoObj["isSolution"] = 0;

            }
            self.putOrderDelivery(deliveryContent, orderNo);//修改订单交付信息
            await self.dao.update(orderInfoObj, t);//修改订单信息
            await self.flowlogDao.create(orderLog, t);//添加流程信息
            // var pushObj = {//推送参数
            //   serviceNo:deliveryContent.serviceNo,
            //   isConfirm:isConfirm,
            //   channelCode:deliveryContent.channelCode,
            //   notes:ab.notes || ""
            // };
            orderdeliveryRes = await self.getOrderDelivery(orderNo);
            if (orderdeliveryRes && orderdeliveryRes.length > 0) {
                return system.getResultSuccess(orderdeliveryRes[0]);
            }
            return system.getResultSuccess();
        })
    }

    // 2020 0828 lin 新增 ali商标交易 关闭订单接口
    async tmRefuse(pobj) {
        var ab = pobj.actionBody;
        var app = pobj.appInfo;
        var orderinfo = await this.findOne({channelOrderNo: ab.bizId, uapp_id: app.uapp_id});
        if (!orderinfo) {
            return system.getResultFail(-6001, "订单不存在");
        }
        if (orderinfo.orderStatus != 1) {
            return system.getResultFail(-6002, "订单状态不符合关闭需求");
        }
        orderinfo.orderStatus = 32;
        var self = this;
        await self.update(orderinfo.dataValues);
        // 注意这里 如果没有返回值 则会在api.base报错，拿不到requestId
        return system.getResultSuccess();
    }

    //智能选择 尼斯类获取
    async getNclByCode(pobj) {
        var sql = "select `business_code`,`ncl_content` from b_business_ncl where business_code=:business_code  LIMIT 1";
        var paramWhere = {business_code: pobj.actionBody.businessCode};
        var result = await this.customQuery(sql, paramWhere);
        if (Object.keys(result).length == 0) {
            return system.getResultFail(-1, 'find err');
        }
        return system.getResult(result[0].ncl_content);
    }

    //智能选择 尼斯类获取
    async getAllNcl(pobj) {
        var sql = "select `ncl_content` from b_business_ncl where business_code like '%类%'";
        var result = await this.customQuery(sql);
        if (Object.keys(result).length == 0) {
            return system.getResultFail(-1, 'find err');
        }
        let ret = []
        result.forEach(item => {
            let Arr = item.ncl_content.nclThree;
            let arrNew = [];

            for (var i = 0; i < 10; i++) {
                var _num = Math.floor(Math.random() * Arr.length)
                var mm = Arr[_num];
                Arr.splice(_num, 1)
                arrNew.push(mm)
            }
            item.ncl_content.nclThree = arrNew;
            ret.push(item.ncl_content);
        })
        return system.getResult(ret);
    }

    //修改订单信息 更新IC订单号
    async updateOrderById(pobj, actionBody) {
        if (!actionBody.orderNo) {
            return system.getResultFail(-1, '订单号不能为空');
        }
        let sql = `update c_order_info set orderServiceNo = :orderServiceNo,channelOrderNo = :channelOrderNo,channelServiceNo=:channelServiceNo where orderNo = :orderNo`
        let updateParams = {
            orderNo: actionBody.orderNo,
            orderServiceNo: actionBody.orderServiceNo,
            channelOrderNo: actionBody.channelOrderNo,
            channelServiceNo: actionBody.channelServiceNo
        }
        let result = await this.customQuery(sql, updateParams)
        return system.getResult(result);
    }

    //获取支付记录
    async getPayRecords(pobj) {
        const userInfo = pobj.userInfo;
        let sql = `select m.sourceOrderNo orderNo,json_extract(o.serviceItemSnapshot,'$.channel_item_name') productName,m.recvAmount totalSum,m.directionType directionType,m.updated_at payTime
                from 
                c_moneyjourney m left join v_order o
                on m.sourceOrderNo = o.orderNo
                where 
                m.channelUserId = :channelUserId and m.uapp_id = :uapp_id`
        const searchWhere = {
            channelUserId: userInfo.channel_userid,
            uapp_id: pobj.appInfo.uapp_id
        }
        let seRet = await this.customQuery(sql, searchWhere);
        return system.getResultSuccess(seRet)
    }

    /**
     * 腾讯平台订单导入
     * @param pobj
     * @returns {Promise<void>}
     */
    async bulkCreateOrders(pobj, req) {
        let ordersArr = [];
        let contactsArr = [];
        let productsArr = [];
        const tx_product = platformConfig.config.pdict.tx_product;
        let arr = pobj.actionBody.ordersArr;
        let uapp_id = pobj.actionBody.uapp_id;
        /*{
          number:"N202102251259eaduJjc",需求号 || 订单号
          status:"待处理,提交方案，已成单等" //单子状态
          companyName:"公司名称",//公司名称
              createdAt:"2021-02-25 10:30:11",创建时间
          area:"扬州",//区域
              productType:"公司注册",//产品名称
            personName:"联系人",
            personMobile:"联系人电话",
            price:"8.80" //价格 ps: 订单会有这个字段
        }*/
        let sql = 'select channelOrderNo from c_order_info where uapp_id = :uapp_id';
        let whereParam = {
            uapp_id: uapp_id
        }
        let ret = await this.customQuery(sql, whereParam);
        let existIds = ret.map(item => {
            return item.channelOrderNo;
        })
        for (let i = 0; i < arr.length; i++) {
            let order = arr[i];
            if (existIds.includes(order.number)) continue;
            let orderObj = {
                uapp_id: uapp_id,
                orderNo: order.number,//订单号
                channelServiceNo: order.number,//渠道服务单号
                channelOrderNo: order.number,//渠道订单号列表，多个以,隔开
                quantity: 1,//项目订单数量（即服务项目的倍数，默认值为1）
                orderStatus: 2,//订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
                totalSum: order.price, //订单总额(产品价格×优惠费率×订单件数)
                payTotalSum: order.price,
                created_at: order.createdAt
            }
            if (order.status == '已签收' || order.status == '服务已完成') {
                orderObj['orderStatus'] = 8;
            }
            if (order.status == '已关闭') {
                orderObj['orderStatus'] = 32;
            }
            ordersArr.push(orderObj);
            if (order.personName && order.personMobile) {
                let customerContactObj = {
                    uapp_id: uapp_id,
                    sourceOrderNo: order.number,
                    contactName: order.personName || "",
                    mobile: order.personMobile,
                    created_at: order.createdAt
                };
                contactsArr.push(customerContactObj);
            }
            /*let whereParams = {uapp_id:uapp_id,item_name:order.productType};
            pobj.actionType = 'getProductByWhere';
            pobj.actionBody = {
              whereParams
            }
            let url = settings.centerAppUrl() + 'action/opProduct/springBoard';
            let result = await this.execClientNew.execPostTimeOutByBusiness('orderinfoSve.js',pobj,url,null,null,60,req);
            if (result.status != 0) {
              return result;
            }
            if (result.data.status != 0) {
              return result.data;
            }
            let product = result.data.data;*/
            let orderProductObj = {
                uapp_id: uapp_id,
                sourceOrderNo: order.number,   // 来源单号
                itemCode: tx_product[order.productType],//产品编码
                itemName: order.productType,//产品名称
                channelItemCode: tx_product[order.productType],//  渠道产品编码
                channelItemName: order.productType,//  渠道产品名称
                price: order.price,//定价
                quantity: 1,//  订单数量（即产品的倍数，默认值为1）
                opPayType: "10",//  操作付款类型:00: 创建订单, 10: 补单
                created_at: order.createdAt
            };
            productsArr.push(orderProductObj);
        }
        let orRet = null;
        if (ordersArr.length > 0) {
            orRet = await this.dao.bulkCreate(ordersArr);
            if (orRet.length == 0) {
                return system.getResultFail(-1, '保存订单失败');
            }
        }
        if (contactsArr.length > 0) {
            this.ordercontactsDao.bulkCreate(contactsArr);
        }
        if (productsArr.length > 0) {
            this.orderproductDao.bulkCreate(productsArr);
        }
        return system.getResultSuccess(orRet);
    }

    /**
     * 同步蜂擎订单商机
     * @returns {Promise<void>}
     */
    async syncOrderBusiness() {
        //获取 need_info_fq 未处理的需求
        let fqOrders = await this.orderinfofqDao.getAllOrders()
        let ids = [];
        let orderDict = {};
        for (let i = 0; i < fqOrders.length; i++) {
            ids.push(fqOrders[i].channelOrderNo);
            orderDict[fqOrders[i].channelOrderNo] = fqOrders[i].orderStatus;
        }
        //根据ids 获取企服通需求
        let orders = await this.orderinfoDao.getOrdersByIds(ids);
        let setObj = [];
        let existIds = [];
        let ids1 = [];
        let ids2 = [];
        let ids3 = [];
        let ids4 = [];
        let ids5 = [];
        let ids6 = [];
        let ids7 = [];
        //已经存在的需求，更改状态
        for (let i = 0; i < orders.length; i++) {
            let order = orders[i];
            let obj = {
                id: order.id,
            }
            if (orderDict[order.channelOrderNo] == 1) {
                ids1.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 2) {
                ids2.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 4) {
                ids3.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 8) {
                ids4.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 16) {
                ids5.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 32) {
                ids6.push(order.channelOrderNo);
            }
            if (orderDict[order.channelOrderNo] == 64) {
                ids7.push(order.channelOrderNo);
            }
            setObj.push(obj);
            existIds.push(order.channelOrderNo);
        }
        // 不存在的订单 添加到企服通
        let createObj = [];
        let setFqObj1 = [];
        let setFqObj2 = [];
        for (let i = 0; i < fqOrders.length; i++) {
            let fqOrder = fqOrders[i].dataValues;
            if (!existIds.includes(fqOrder.channelOrderNo)) {
                fqOrder.orderNo = fqOrder.channelOrderNo;
                if (['360_icp ', '360_edi', '360_sbzc'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 50;
                }
                if (['baidu_edi', 'baidu_gsreg', 'baidu_icp', 'baidu_radiotv', 'baidu_wangwen'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 44;
                }
                if (['edi_ali', 'ic_ali', 'icp_ali', 'tm_ali', 'tmd_ali'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 18;
                }
                if (['youke'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 40;
                }
                if (['tm_jdyun'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 31;
                }
                if (['tm_bw'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 35;
                }
                if (['tm_1688'].includes(fqOrder.source_code)) {
                    fqOrder.uapp_id = 0;
                }
                delete fqOrder.sourceName;
                delete fqOrder.source_code;
                delete fqOrder.handleStatus;
                delete fqOrder.id;
                if (!setFqObj2.includes(fqOrder.channelOrderNo)) {
                    createObj.push(fqOrder);
                    setFqObj2.push(fqOrder.channelOrderNo);
                }
            } else {
                setFqObj1.push(fqOrder.channelOrderNo);
            }
        }

        //企服通 批量更新状态
        let updateRet = [];
        if (setObj.length > 0) {
            // updateRet = await this.needinfoDao.bulkUpdate(setObj);
            // 1: 待付款, 2: 已付款, 4: 服务中, 8: 已完成, 16: 已退款, 32: 已作废, 64: 已付部分款
            if (ids1.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(1, '待付款', ids1);
            }
            if (ids2.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(2, '已付款', ids2);
            }
            if (ids3.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(4, '服务中', ids3);
            }
            if (ids4.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(8, '已完成', ids4);
            }
            if (ids5.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(16, '已退款', ids5);
            }
            if (ids6.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(32, '已作废', ids6);
            }
            if (ids7.length > 0) {
                updateRet = await this.orderinfoDao.bulkUpdateStatus(64, '已付部分款', ids7);
            }
            if (updateRet.length > 0) {
                updateRet = await this.orderinfofqDao.bulkUpdate(setFqObj1);
            }
        }
        //企服通 批量添加
        if (createObj.length > 0) {
            updateRet = await this.orderinfoDao.bulkCreate(createObj);
            if (updateRet.length > 0) {
                updateRet = await this.orderinfofqDao.bulkUpdate(setFqObj2);
            }
        }
        return system.getResult(updateRet)
    }


    /**
     * 接收阿里云商标订单信息
     * @param {*} pobj
     */
    async receiveAliTmOrder(pobj) {
        var res = await this.checkAndPackageAliTmOrderParams(pobj);
        if (!res || res.status != 0) {
            return res;
        }
        var orderNo = await this.getBusUid("tm" + pobj.appInfo.uapp_id);
        var ab = pobj.actionBody;
        var productInfo = pobj.productInfo;
        ab.orderNo = orderNo;
        //订单产品
        var orderProductObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            productType_id: productInfo.productType_id,//产品类型Id
            pathCode: productInfo.path_code,//产品路径
            itemCode: productInfo.item_code,//产品编码
            itemName: productInfo.item_name,//产品名称
            channelItemCode: productInfo.channel_item_code,//  渠道产品编码
            channelItemName: productInfo.channel_item_name,//  渠道产品名称
            channelItemAppendName: ab.channelItemAppendName || "",//服务商产品附加名称
            serviceItemCode: productInfo.service_item_code,//  服务商产品编码
            payAfterJumpH5Url: productInfo.pay_after_jump_h5url || "",
            payAfterJumpPcUrl: productInfo.pay_after_jump_pcurl || "",
            picUrl: productInfo.pic_url,//  产品图片地址
            price: productInfo.price_item.price,//定价
            priceDesc: productInfo.price_item.price_desc,//定价描述
            priceTypeName: productInfo.price_item.price_type_name,//定价类型名称
            quantity: ab.quantity,//  订单数量（即产品的倍数，默认值为1）
            opPayType: "00",//  操作付款类型:00: 创建订单, 10: 补单
            serviceItemSnapshot: JSON.stringify(productInfo),      //产品快照
            orderSnapshot: JSON.stringify(ab)// 2020 1110 lin 新增 增加订单快照
        };
        var self = this;
        return await self.db.transaction(async function (t) {
            var o = await self.dao.create(ab, t);
            var orderProduct = await self.orderproductDao.create(orderProductObj, t);//订单产品
            return system.getResultSuccess(o);
        })

    }

    /**
     * 检查封装阿里商标订单参数
     * @param {*} pobj
     */
    async checkAndPackageAliTmOrderParams(pobj) {
        if (!pobj || !pobj.actionBody) {
            return system.getResult(null, "订单参数不能为空，100100");
        }
        if (!pobj.appInfo) {
            return system.getResult(null, "未知用应信息，100200");
        }
        if (!pobj.userInfo) {
            return system.getResult(null, "未知用户信息，100300");
        }
        if (!pobj.productInfo) {
            return system.getResult(null, "未知用户信息，100500");
        }
        if (!pobj.actionBody.channelOrderNo) {
            return system.getResult(null, "阿里订单号不能为空，100110");
        }
        if (!pobj.actionBody.serviceOrderNo) {
            return system.getResult(null, "蜂擎订单号不能为空，100120");
        }
        if (!pobj.actionBody.serviceNo) {
            return system.getResult(null, "服务单号不能为空，100130");
        }
        if (!pobj.actionBody.needNo) {
            return system.getResult(null, "阿里需求号不能为空，100110");
        }
        var orderInfo = await this.dao.model.findOne({
            where: {channelOrderNo: pobj.actionBody.channelOrderNo, uapp_id: pobj.appInfo.uapp_id}, raw: true
        });
        if (orderInfo && orderInfo.id) {
            return system.getResult(null, "阿里订单号：" + pobj.actionBody.channelOrderNo + "的订单已存在，100140");
        }
        var ab = pobj.actionBody;
        var appInfo = pobj.appInfo;
        var userInfo = pobj.userInfo;
        ab.uapp_id = appInfo.uapp_id;
        ab.channelNeedNo = ab.needNo;
        ab.channelUserId = userInfo.channel_userid;
        ab.ownerUserId = userInfo.channel_userid;
        ab.payTime = ab.payTime || new Date();
        ab.orderStatus = 2;
        ab.totalSum = ab.price;
        ab.payTotalSum = ab.price;
        return system.getResultSuccess();
    }

    /**
     * 接收阿里商标订单退款信息
     * @param {*} pobj
     */
    async receiveAliTmOrderRefund(pobj) {
        if (!pobj || !pobj.actionBody) {
            return system.getResult(null, "订单参数不能为空，100100");
        }
        if (!pobj.appInfo) {
            return system.getResult(null, "未知用应信息，100200");
        }
        if (!pobj.userInfo) {
            return system.getResult(null, "未知用户信息，100300");
        }
        if (!pobj.actionBody.channelOrderNo) {
            return system.getResult(null, "阿里订单号不能为空，100110");
        }
        var orderInfo = await this.dao.model.findOne({
            attributes: ["id", "channelOrderNo", "payTotalSum"],
            where: {channelOrderNo: pobj.actionBody.channelOrderNo, uapp_id: pobj.appInfo.uapp_id}, raw: true
        });
        if (!orderInfo || !orderInfo.id) {
            return system.getResult(null, "阿里订单号：" + pobj.actionBody.channelOrderNo + "的订单不存在，100140");
        }
        orderInfo.refundSum = pobj.actionBody.refundSum || orderInfo.payTotalSum;
        orderInfo.orderStatus = 16;
        orderInfo.refundTime = pobj.actionBody.refundTime || new Date();
        await this.dao.update(orderInfo);
        return system.getResultSuccess();

    }

    /***
     * 处理渠道退款
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: *, data: (*|null), status: number}>}
     */
    async channeldelOrder(pobj, actionBody) {
        let status = actionBody.status || 16;
        let statusName = actionBody.statusName || "已退款";
        await this.dao.updateStatus(status, statusName, actionBody.orderNo, pobj.appInfo.uapp_id);
        return system.getResultSuccess();
    }
}

module.exports = OrderInfoService;
