const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
var moment = require('moment')
const uiconfig = require("../../../db/metadata/apps/platform");

class NeedinfoService extends ServiceBase {
  constructor() {
    super("dbneed", ServiceBase.getDaoName(NeedinfoService));
    this.execlient = system.getObject("util.execClient");
    this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
  }
  async getItemByNeedNo(pobj) {
    var item = await this.dao.getItemByNeedNo(pobj.actionBody.needNo);
    // console.log(system.getResultSuccess(item));
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  async getItemByChannelNeedNo(pobj) {
    var item = await this.dao.getItemByChannelNeedNo(pobj.actionBody.needNo);
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  async getSolutionByChannelSolutionNo(pobj) {
    var item = await this.needsolutionDao.model.findOne({
      where:{channelSolutionNo: pobj.actionBody.bizId}
    });
    if (!item) {
      return system.getResult(null, "方案数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  async needinfo2fq(pobj) {
    pobj.actionBody.needNo = await this.getBusUid("n");
    pobj.actionBody.uapp_id = pobj.appInfo.id;
    var needinfo = await this.dao.create(pobj.actionBody);
    var pobj = {
      "idempotentId": needinfo.needNo,
      "idempotentSource": needinfo.chanceType_code,
      "idempotentSourceName": pobj.appInfo.app_name + "_" + pobj.actionBody.chanceTypeName,
      "phone": needinfo.publishMobile,
      "remark": needinfo.notes,
      "customerName": needinfo.publishName
    };

    var rc = system.getObject("util.aliyunClient");
    var rtn = await rc.post("https://yunfuapi.gongsibao.com/crm/opportunity/submit", pobj);
    console.log(rtn)
    return system.getResultSuccess();
    // var opResultstr = await this.execlient.execPost(pobj, "https://yunfuapi-dev.gongsibao.com/crm/opportunity/submit");
    // opResult = JSON.parse(opResultstr.stdout)
    // if (opResultstr) {
    //   return system.getResultSuccess();
    // }
  }

  // intentionBizId
  // mobile
  // userName
  // description
  // area
  // type
  // ext
  async submitNeed(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5001, "intentionBizId不能为空");
    }
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    if (!actionBody.type) {
      return system.getResultFail(-5003, "type不能为空");
    }
    var ninfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (ninfo) {
      return system.getResultSuccess(ninfo);
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: actionBody.intentionBizId,
      needNo: needNo,
      channelUserId: actionBody.mobile,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      city: actionBody.area,
      // disposeNotes: actionBody.ext,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      status: "wts",
      level: actionBody.level || "",
      probability: actionBody.probability || "",
      appName: actionBody.appName,
      serviceProductId: actionBody.service_product_id,
      notes: actionBody.notes
    }
    if (nobj.channelTypeCode == 7 || nobj.channelTypeCode == 5) {
      nobj.province = nobj.city,
        nobj.city = "";
    }
    var needInfo = await this.dao.create(nobj);
    return system.getResultSuccess(needInfo);
  }

  /**
   * 工商H5 免费咨询
   * @param pobj
   * @param actionBody
   * @param req
   * @returns {Promise<{msg: *, data: *, status: *}|{msg: *, data: (*|null), status: number}>}
   */
  async submitNeedH5(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    var channelNeedNo = await this.getBusUid("i");
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    if (!actionBody.type) {
      return system.getResultFail(-5003, "type不能为空");
    }
    var ninfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (ninfo) {
      return system.getResultSuccess();
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: channelNeedNo,
      needNo: needNo,
      channelUserId: actionBody.mobile,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      city: actionBody.area,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      appName: actionBody.appName,
      serviceProductId: actionBody.service_product_id,
      status: "wts"
    }
    if (nobj.channelTypeCode == 7 || nobj.channelTypeCode == 5) {
      nobj.province = nobj.city,
        nobj.city = "";
    }
    await this.dao.create(nobj);
    return system.getResultSuccess();
  }

  async needClose(pobj, actionBody, req) {
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5005, "intentionBizId不能为空");
    }
    var needinfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (!needinfo) {
      return system.getResultFail(-5004, "需求不存在");
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultSuccess();
    } else {
      needinfo.status = "ygb";
      // 2020 0821 lin 新增 修改增加 跟进者唯一码（非必填),跟进者手机号(必填)
      needinfo.followManMobile = actionBody.followManMobile;
      needinfo.followManUserId = actionBody.followManUserId;
      var self = this;
      await self.update(needinfo.dataValues);
      await self.needsolutionSve.abolishProgrammeByNeed(pobj);
      return system.getResultSuccess();
    }
  }

  async flowinfo(obj) {

  }

  async getItemByChannelSolutionNo(pobj) {
    var solutionitem = await this.needsolutionDao.findOne({ channelSolutionNo: pobj.actionBody.bizId });
    if (!solutionitem) {
      return system.getResult(null, "方案数据为空，30210");
    }
    var item = await this.dao.getItemByNeedNo(solutionitem.needNo);
    if (!item) {
      return system.getResult(null, "需求数据为空，30210");
    }
    // fixme 阿里直购需要更改
    if (!pobj.actionBody.bizId.startsWith("TM_")) {//商标不需要
      item.solutionProvince = solutionitem.solutionContent.solution.Area || solutionitem.solutionContent.solution.area;
      //item.solutionProvince = solutionitem.solutionContent.solution.Area + `（${solutionitem.solutionContent.solution.actionType}）`//北京（新办）;
      item.solutionContent = solutionitem.solutionContent
      item.channelSolutionNo = solutionitem.channelSolutionNo
    }
    return system.getResultSuccess(item);
  }

  async getSolutionByChannelOrderNo(pobj){
    var orderinfo = await this.orderinfoDao.findOne({ channelOrderNo: pobj.actionBody.orderNo });
    if (!orderinfo || !orderinfo.orderNo) {
      return system.getResult(null, "订单数据为空，30210");
    }
    var item = await this.needsolutionDao.model.findOne({
      where:{orderNo:orderinfo.orderNo}
    });
    if (!item) {
      return system.getResult(null, "方案数据为空，30210");
    }
    return system.getResultSuccess(item);
  }

  async writeCommunicationLog(pobj, actionBody) {
    // 查询需求沟通记录
    // 2020 0820 lin 修改channel传过来的参数 为 note/intentionBizId
    actionBody.Note = ["noteTime", moment().format("YYYY-MM-DD HH:mm:ss"), "note", actionBody.note];
    let needRes = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    // 没有需求单直接返回
    if (!needRes) {
      return system.getResult("没有这个需求单");
    }
    // 如果未推送/以推送 修改为已跟进
    if (needRes.status == "wts" || needRes.status == "yts") {
      var sql = "update n_need_info set status=:status, statusName=:statusName where channelNeedNo=:BizId"
      var paramWhere = {
        statusName: '已跟进',
        status: 'ygj',
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
    }
    // 有需求单但没有沟通记录 直接set
    if (!needRes.followContent) {
      var sql = "update n_need_info set followContent=JSON_OBJECT(:followContent) where channelNeedNo=:BizId"
      var paramWhere = {
        followContent: actionBody.Note,
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
      if (updateRes[1]) {
        return system.getResultSuccess();
      }
      return system.getResult("添加记录失败");
      // 有需求单有沟通记录 json_array_append
    } else {
      var sql = "update n_need_info set followContent=json_array_append(followContent, '$', JSON_OBJECT(:Note)) where channelNeedNo=:BizId"
      // var sql = "update n_need_info set followContent=json_array_append(followContent, '$', "+ "\"" + JSON.stringify(actionBody.Note) + "\""+") where channelNeedNo="+ "\"" +actionBody.BizId +"\"" +"  "
      var paramWhere = {
        Note: actionBody.Note,
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
      if (updateRes[1]) {
        return system.getResultSuccess();
      }
      return system.getResult("添加记录失败");
    }
  }

  async submitIcpIntention(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      needNo: needNo,
      channelUserId: pobj.userInfo.channel_userid,
      publishName: actionBody.UserName,
      publishContent: actionBody.Description,
      publishMobile: actionBody.Mobile,
      city: actionBody.Area,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code,
      channelTypeName: actionBody.channel_type_name,
      status: "wts"
    }
    if (nobj.channelTypeCode == 7 || nobj.channelTypeCode == 5) {
      nobj.province = nobj.city,
        nobj.city = "";
    }
    await this.dao.create(nobj);
    return system.getResultSuccess();
  }

  async queryIntentionList(pobj, actionBody, req) {
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5005, "intentionBizId不能为空");
    }
    var needinfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (!needinfo) {
      return system.getResultFail(-5004, "需求不存在");
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultSuccess();
    } else {
      needinfo.status = "ygb";
      // 2020 0821 lin 新增 修改增加 跟进者唯一码（非必填),跟进者手机号(必填)
      needinfo.followManMobile = actionBody.followManMobile;
      needinfo.followManUserId = actionBody.followManUserId;
      var self = this;
      await self.update(needinfo.dataValues);
      await self.needsolutionSve.abolishProgrammeByNeed(pobj);
      return system.getResultSuccess();
    }
  }

  async confirmIcpIntention(pobj, actionBody, req) {
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5005, "intentionBizId不能为空");
    }
    var needinfo = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    if (!needinfo) {
      return system.getResultFail(-5004, "需求不存在");
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultSuccess();
    } else {
      needinfo.status = "ygb";
      // 2020 0821 lin 新增 修改增加 跟进者唯一码（非必填),跟进者手机号(必填)
      needinfo.followManMobile = actionBody.followManMobile;
      needinfo.followManUserId = actionBody.followManUserId;
      var self = this;
      await self.update(needinfo.dataValues);
      await self.needsolutionSve.abolishProgrammeByNeed(pobj);
      return system.getResultSuccess();
    }
  }
  async getUnCreated (pobj, data, req) {
      let stdate = new Date(pobj.actionBody.Begin);
      let enddate = new Date(pobj.actionBody.End );
      let query = {where:{}};
      query.where["created_at"] = { [this.db.Op.between]: [stdate, enddate] };
      try {
          let res = await this.dao.model.findAndCountAll(query);
          res = res.rows.map(n=>n.channelNeedNo);
          res = pobj.actionBody.data.filter(ali=>!res.includes(ali.BizId));
          return system.getResultSuccess(res)
      } catch (error) {
          return system.getResultFail(-1, error.message)
      }
  }

  async produceNoticeAliEsp (pobj, actionBody) {
    switch (actionBody.operationType) {
      case "USER_PAY_PRODUCE": 

        break;
      case "USER_PAY_PRODUCE": 
        break;
      case "USER_PAY_PRODUCE": 
        break;
      case "USER_PAY_PRODUCE": 
        break;
      case "USER_PAY_PRODUCE": 
        break;
      default:
        return system.getResult(null, "operationType参数错误");
    }
  }

  /**
   * 批量需求导入
   * @param pobj
   * @returns {Promise<void>}
   */
  async bulkCreateNeeds(pobj){
    const tx_product = uiconfig.config.pdict.tx_product;
    const tx_need_status = uiconfig.config.pdict.tx_need_status;
    const tx_need_status_name = uiconfig.config.pdict.tx_need_status_name;
    let needsArr = [];
    let arr = pobj.actionBody.needsArr;
    let uapp_id = pobj.actionBody.uapp_id;
    let sql = 'select channelNeedNo from n_need_info where uapp_id = :uapp_id';
    let whereParam = {
      uapp_id:uapp_id
    }
    let ret = await this.customQuery(sql,whereParam);
    let existIds = ret.map(item =>{
        return item.channelNeedNo;
    })
    for(let i=0;i<arr.length;i++){
      let item = arr[i];
      let typeCode = tx_product[item.productType];
      let obj = {
        "uapp_id": uapp_id,
        "needNo": "",
        "channelNeedNo":item.number,
        "publishContent": item.companyName,
        "publishName": item.personName,
        "publishMobile": item.personMobile,
        "statusName": tx_need_status_name[item.status],
        "status": tx_need_status[item.status],
        "typeCode": typeCode,
        "typeName": item.productType,
        "created_at": item.createdAt
      };
      if(["icp","edi","icp年报","edi年报"].includes(item.productType)){
        obj.province = item.area || "";
      }else{
        obj.city = item.area || "";
      }
      if(!existIds.includes(item.number)){
        needsArr.push(obj);
      }
    }
    let result = await this.dao.bulkCreate(needsArr);
    return system.getResult(result);
  }


}
module.exports = NeedinfoService;

// var a=new NeedinfoService();
// var b=a.getItemByChannelSolutionNo({actionBody:{bizId:"1593141330846"}});