const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class NeedsolutionService extends ServiceBase {
  constructor() {
    super("dbneed", ServiceBase.getDaoName(NeedsolutionService));
    this.execlient = system.getObject("util.execClient");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    // this.push2aliSve = system.getObject("service.common.push2aliSve");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.icpSolutionStatusReference = {
      SOLUTION_SUBMIT: "提交服务单",
      UN_PAID: "未支付", PAID: "用户支付", USER_UPLOADED: "用户上传资料", MATERIAL_UNCONFIRM: "服务商递交⽂件"
      , USER_CONFIRMED: "⽤户已确认递交⽂件", ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
      GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
      , CLOSE: "方案关闭"
    };
  }
  //---------------------公司注册-start-----------------------------------------------------------------
  //提交方案
  async submitProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求号不能为空");
    }
    if (!ab.solutionContent) {
      return system.getResultFail(-102, "方案信息有误");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    var bizType = ab.solutionContent.bizType;//业务类型
    if (!bizType || !needinfo.typeCode || bizType != needinfo.typeCode) {
      return system.getResultFail(-205, "方案类型错误");
    }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-206, "渠道方案类型错误");
    }
    ab.solutionContent.bizType = needinfo.channelTypeCode;
    bizType = needinfo.channelTypeCode;
    // bizType取值如下：
    // 商标交易：esp.trademark_trade
    // 财税代账：esp.bookkeeping
    // 普通公司注册：esp.companyreg
    // 云上公司注册：esp.companyreg_cloud
    if (!ab.solutionContent.solution) {
      return system.getResultFail(-104, "业务方案信息不能为空");
    }
    var solution = ab.solutionContent.solution;
    if (bizType == "esp.companyreg") {//普通公司注册
      if (!solution.companyName) {
        return system.getResultFail(-105, "公司名称不能为空");
      }
      if (!solution.city) {
        return system.getResultFail(-106, "注册城市不能为空");
      }
      if (!solution.area) {
        return system.getResultFail(-107, "注册区域不能为空");
      }
      if (!solution.companyCategory) {
        return system.getResultFail(-108, "纳税人类型不能为空");
      }
      // if(!solution.companyType){
      //   return system.getResultFail(-109,"公司性质不能为空");
      // }
      if (!solution.orgType) {
        return system.getResultFail(-110, "组织类型不能为空");
      }
      if (!solution.industryType) {
        return system.getResultFail(-111, "从事行业不能为空");
      }
      if (!solution.scope) {
        return system.getResultFail(-112, "经营范围不能为空");
      }
    }
    if (bizType == "esp.companyreg_cloud") {//云上公司注册
      if (!solution.park) {
        return system.getResultFail(-113, "注册园区不能为空");
      }
      if (!solution.registerType) {
        return system.getResultFail(-114, "注册类型不能为空");
      }
      if (!solution.productType) {
        return system.getResultFail(-115, "产品类型不能为空");
      }
    }

    ab["channelNeedNo"] = needinfo.channelNeedNo;
    var solutionNo = await this.getBusUid("ns");
    ab["solutionNo"] = solutionNo;
    ab["status"] = "dqr";
    ab.solutionContent["notes"] = "";
    ab.solutionContent["totalSum"] = "";
    ab.solutionContent = JSON.stringify(ab.solutionContent);
    var self = this;
    return await this.db.transaction(async function (t) {
      ab["needNo"] = needinfo.needNo;
      var od = await self.dao.create(ab, t);
      if (od && od.id) {
        var pushflag = 0;//推送标志 值为1推送小记
        var needObj = {
          id: needinfo.id
        };
        if (!needinfo.followManUserId) {
          needObj = {
            id: needinfo.id,
            followManUserId: user.id,//跟进人id
            followManName: user.channel_username,//跟进人姓名
            followManMobile: user.mobile,//跟进人手机号（合伙人）
            followManOnlyCode: user.channel_userid
          };
        }
        if (!needinfo.followContent) {
          var followContent = {
            followDate: new Date(),
            content: "提交到方案"
          };
          followContent = JSON.stringify(followContent);
          needObj["followContent"] = followContent;
          pushflag = 1;
        }
        await self.needinfoDao.update(needObj, t);
        needinfo = await self.needinfoDao.model.findOne({
          where: { id: needinfo.id }, raw: true
        });
        needinfo["pushflag"] = pushflag;
        return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
      } else {
        return system.getResultFail(-202, "提交方案失败");
      }
    })

  }
  //接收方案编号(方案推送至阿里后,接收保存方案信息)
  async receiveProgrammeNo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.solutionBizId) {
      return system.getResultFail(-101, "渠道方案业务编号不能为空");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-102, "方案业务编号不能为空");
    }
    var ns = await this.dao.model.findOne({
      where: { solutionNo: ab.solutionNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    await this.dao.model.update({ channelSolutionNo: ab.solutionBizId }, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }
  //根据需求查看方案列表
  async getProgrammeInfoByNeedNo(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    // followManMobile: DataTypes.STRING,//跟进人手机号（合伙人）
    // followManOnlyCode: DataTypes.STRING(50),//跟进者唯一码
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求号不能为空");
    }
    // if(!ab.followManMobile){
    //   return system.getResultFail(-102,"跟进人手机号不能为空");
    // }
    // if(!ab.followManOnlyCode){
    //   return system.getResultFail(-103,"跟进人唯一码不能为空");
    // }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-102, "未知需求信息");
    }
    var ns = await this.dao.model.findAll({
      where: { needNo: needinfo.needNo, createUserId: user.id }, raw: true,
      attributes: ["needNo", "solutionNo", "channelSolutionNo", "orderNo", "solutionContent", "status", "statusName"]
    });
    return system.getResultSuccess(ns);
  }

  // 2020 1017 lin 新增 根据渠道方案号查看方案
  async getProgrammeInfoByChannelSolutionNo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.channelSolutionNo) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    //获取需求信息
    var needsolutioninfo = await this.dao.model.findOne({
      attributes:["id","solutionContent","status","orderNo"],
      where: { channelSolutionNo: ab.channelSolutionNo,isInvalid:0 }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-102, "未知方案信息");
    }
    return system.getResultSuccess(needsolutioninfo);
  }

  //获取方案列表（获取用户所有方案）
  async getProgrammeListByUser(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    var pageSize = Number(ab.pageSize || 20);
    if (pageSize > 500) {
      pageSize = 500;
    }
    var bizType = ab.bizType;// || "esp.companyreg";// esp.companyreg_cloud
    var pageIndex = Number(ab.pageIndex || 1);
    var from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);
    //select  * from log where data->'$.id' = 142;
    var sql = "select id,needNo,channelNeedNo,solutionNo,channelSolutionNo,orderNo,solutionContent,status,statusName,created_at from n_need_solution where 1=1 ";
    var sqlCount = "select count(1) as dataCount from n_need_solution where 1=1 ";
    sql = sql + " and createUserId=" + user.id;
    sqlCount = sqlCount + " and createUserId=" + user.id;
    if (bizType) {
      sql = sql + " and solutionContent->'$.bizType' = '" + bizType + "'";
      sqlCount = sqlCount + " and solutionContent->'$.bizType' = '" + bizType + "'";
    }
    var paramWhere = {};
    if (ab.solutionNo) {//方案号
      sql += " and solutionNo = :solutionNo";
      sqlCount += " and solutionNo = :solutionNo";
      paramWhere.solutionNo = ab.solutionNo;
    }
    if (ab.orderNo) {//服务单号
      sql += " and orderNo = :orderNo";
      sqlCount += " and orderNo = :orderNo";
      paramWhere.orderNo = ab.orderNo;
    }
    if (ab.status) {//方案状态
      sql += " and status = :status";
      sqlCount += " and status = :status";
      paramWhere.status = ab.status;
    }
    if (bizType == "esp.companyreg") {//普通公司注册
      if (ab.companyName) {//企业名称
        sql = sql + " and solutionContent->'$.solution.companyName' = :companyName";
        sqlCount = sqlCount + " and solutionContent->'$.solution.companyName' = :companyName";
        paramWhere.companyName = ab.companyName;
      }//
      if (ab.orgType) {//组织类型
        sql = sql + " and solutionContent->'$.solution.orgType' = :orgType";
        sqlCount = sqlCount + " and solutionContent->'$.solution.orgType' = :orgType";
        paramWhere.orgType = ab.orgType;
      }
      if (ab.companyType) {//公司性质
        sql = sql + " and solutionContent->'$.solution.companyType' = :companyType";
        sqlCount = sqlCount + " and solutionContent->'$.solution.companyType' = :companyType";
        paramWhere.companyType = ab.companyType;
      }
      if (ab.city) {//城市
        sql = sql + " and solutionContent->'$.solution.city' = :city";
        sqlCount = sqlCount + " and solutionContent->'$.solution.city' = :city";
        paramWhere.city = ab.city;
      }
      if (ab.area) {//区域
        sql = sql + " and solutionContent->'$.solution.area' = :area";
        sqlCount = sqlCount + " and solutionContent->'$.solution.area' = :area";
        paramWhere.area = ab.area;
      }
      if (ab.companyCategory) {//纳税人类型
        sql = sql + " and solutionContent->'$.solution.companyCategory' = :companyCategory";
        sqlCount = sqlCount + " and solutionContent->'$.solution.companyCategory' = :companyCategory";
        paramWhere.companyCategory = ab.companyCategory;
      }
    }
    if (bizType == "esp.companyreg_cloud") {//云上公司注册
      if (ab.park) {//注册园区
        sql = sql + " and solutionContent->'$.solution.park' = :park";
        sqlCount = sqlCount + " and solutionContent->'$.solution.park' = :park";
        paramWhere.park = ab.park;
      }
      if (ab.productType) {//产品类型
        sql = sql + " and solutionContent->'$.solution.productType' = :productType";
        sqlCount = sqlCount + " and solutionContent->'$.solution.productType' = :productType";
        paramWhere.productType = ab.productType;
      }
    }
    sql += " order by id desc LIMIT " + pageSize + " OFFSET " + from;

    var list = await this.customQuery(sql, paramWhere);
    var result = system.getResultSuccess(list);

    var tmpResultCount = await this.customQuery(sqlCount, paramWhere);

    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

    return result;

  }
  //接收方案反馈信息(即方案作废)
  async receiveFeedback(pobj) {
    var ab = pobj.actionBody;
    if (!ab.solutionBizId) {
      return system.getResultFail(-101, "方案业务编号不能为空");
    }
    if (!ab.operateType) {
      return system.getResultFail(-102, "操作类型不能为空");
    }
    var ns = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.solutionBizId }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var solutionContent = ns.solutionContent;
    var status = "";
    if (ab.operateType == "INVALID") {// INVALID：作废
      status = "yzf";
    } else if (ab.operateType == "REFUND") {// REFUND：退款
      status = "yzf";
    } else if (ab.operateType == "PAID") {// PAID：支付
      status = "ywc";
    } else {
      return system.getResultFail(-104, "操作类型有误");
    }
    // var solution_status={"dqr":"待确认","ywc":"已完成","yzf":"已作废"};
    // solutionContent["deliveryStatus"] = status;
    // solutionContent["deliveryStatusName"] = solution_status[status];
    // solutionContent["updated"] = new Date();
    if (ab.note) {
      solutionContent["notes"] = ab.note;
    }
    solutionContent = JSON.stringify(solutionContent);
    var reqObj = {
      status: status, solutionContent: solutionContent
    };
    await this.dao.model.update(reqObj, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }
  //服务商方案作废
  async abolishProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-101, "方案号不能为空");
    }
    //获取方案信息
    var ns = await this.dao.model.findOne({
      where: { solutionNo: ab.solutionNo, createUserId: user.id }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    if (ns.status != "dqr") {
      return system.getResultFail(-103, "方案状态错误，只能废弃待确认方案");
    }
    await this.dao.update({ id: ns.id, status: "yzf" });//方案废弃
    //获取方案信息
    ns = await this.dao.model.findOne({
      where: { solutionNo: ab.solutionNo, createUserId: user.id }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //根据需求关闭方案（关闭需求后调用）
  async abolishProgrammeByNeed(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.intentionBizId) {
      return system.getResultFail(-101, "需求编号不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.dao.model.findAll({
      where: { needNo: needinfo.needNo }, raw: true
    });
    for (var i = 0; i < ns.length; i++) {
      var fa = ns[i];
      if (fa.status == "ywc") {
        return system.getResultFail(-103, "方案状态错误，不能废弃已完成方案");
      }
    }
    await this.dao.model.update({ status: "yzf",isInvalid:1 }, { where: { needNo: needinfo.needNo } });//方案废弃
    return system.getResultSuccess();
  }

  //立即支付下单保存方案
  async createSolutionByOrder(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    var solution = "";
    var bizType = "esp.companyreg";
    if (ab.companyName) {
      solution = {
        "companyName": ab.companyName,
        "area": ab.area,
        "city": ab.city || "",
        "companyCategory": ab.companyCategory,
        "companyType": ab.companyType,
        "orgType": ab.orgType,
        "industryType": ab.industryType,
        "scope": ab.scope,
        "remark": ab.remark
      };
    } else if (ab.park) {
      solution = {
        "park": ab.park,
        "productType": ab.productType,
        "remark": ab.remark
      };
      bizType = "esp.companyreg_cloud";
    }
    var solutionContent = {
      "bizType": bizType,
      "solution": solution
    };
    solutionContent = JSON.stringify(solutionContent);
    // ab["channelNeedNo"] = needinfo.channelNeedNo;
    // ab["solutionNo"] = solutionNo;
    var solutionNo = await this.getBusUid("ns");
    var reqObj = {
      solutionContent: solutionContent, solutionNo: solutionNo, status: "ywc", orderNo: ab.orderNo
    };
    var ns = await this.dao.create(reqObj);
    return system.getResultSuccess(ns);
  }
  //接收方案状态及支付信息
  async receiveSolutionPayInfo(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    var ns
    // 2020 1021 lin 修改  if (ab.isDirectBuy 为 ==true 原因 实际传的是字符串不是布尔
    if (ab.isDirectBuy === "true"){//直购先创建空方案
      var solutionNo = await this.getBusUid("ns");
      var oldNs = await this.dao.model.findOne({
        where: { orderNo: ab.orderNo }
      });
      var solutionContent = {
        "status": "PAID",
        "bizType": ab.product_info && ab.product_info.item_code?ab.product_info.item_code:"",
        "solution": {
          "Area": ab.area || "",
          "IcpType": ab.bizId.startsWith("EDI")?7:5,
          "CompanyName": ab.companyName || "",
          "CompanyAddress": ab.area || "",
          actionType:ab.actionType,
          Source:ab.source
        },
        "totalSum": ab.totalSum || Number(ab.orderPrice || "0"),
        "typeCode": ab.product_info && ab.product_info.item_code?ab.product_info.item_code:"",
        "typeName": ab.product_info && ab.product_info.item_name?ab.product_info.item_name:"",
        "needStatus": "3",
        "statusName": "用户支付",
        "customerInfo": {
          "publishName": pobj.userInfo.channel_nickname || "",
          "publishMobile": pobj.userInfo.mobile || ""
        },
        "customerRemark": "",
        "needStatusName": "处理中",
        "customerMaterial": {},
        "solutionFlowList": [
          {
            "status": "PAID",
            "statusName": "用户支付",
            "updated_at": new Date()
          }
        ]
      };
      if (oldNs && oldNs.id ){
        oldNs.solutionContent = JSON.stringify(solutionContent)
        ns = await oldNs.save();
      }else {
        ns = await this.create({
          solutionNo,
          ...ab,
          status: "ywc",
          solutionContent: JSON.stringify(solutionContent)
        })
      }
    }else {
      if (!ab.channelSolutionNo) {
        return system.getResultFail(-101, "渠道方案编号不能为空");
      }
      // if(!ab.status){
      //   return system.getResultFail(-102,"状态不能为空");
      // }
      var needsolutioninfo = await this.dao.model.findOne({
        attributes: ["id", "solutionContent", "status", "orderNo"],
        where: {channelSolutionNo: ab.channelSolutionNo, isInvalid: 0}, raw: true
      });
      if (!needsolutioninfo || !needsolutioninfo.id) {
        return system.getResultFail(-400, "未知方案");
      }
      var solutionContent = needsolutioninfo.solutionContent;
      if (ab.orderPrice) {
        // solutionContent = JSON.parse(solutionContent);
        solutionContent["totalSum"] = Number(ab.orderPrice || "0");
      }
      // 2020 1017 lin 新增去掉status的判断，生成订单这个方案才算完成，所以没必要再判断，另一个原因网文2.3每个状态都有不同status，所以不能以来有没有status来决定方案完成情况。
      // if (ab.status) {
      //   needsolutioninfo.status = "ywc";
      // }
      if (ab.orderNo) {
        needsolutioninfo.orderNo = ab.orderNo;
        needsolutioninfo.status = "ywc";
      }
      needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
      await this.dao.update(needsolutioninfo);
      ns = await this.dao.model.findOne({
        where: { id: needsolutioninfo.id }, raw: true
      });
    }
    return system.getResultSuccess(ns);
  }

  //修改退款方案状态
  async updateStausByRefundOrder(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    var orderns = await this.orderinfoDao.model.findOne({
      where: { channelOrderNo: ab.orderNo }, raw: true
    });
    if (!orderns) {
      return system.getResultFail(-102, "订单不存在");
    }
    var ns = await this.dao.model.findOne({
      where: { orderNo: orderns.orderNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var status = "yzf";
    var reqObj = {
      status: status, id: ns.id
    };
    await this.dao.model.update(reqObj, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }
  //---------------------公司注册-end-----------------------------------------------------------------

  //---------------------icp注册-start-----------------------------------------------------------------
  //根据需求查看方案列表
  async getProgrammeInfoByChannelNeedNo(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    // followManMobile: DataTypes.STRING,//跟进人手机号（合伙人）
    // followManOnlyCode: DataTypes.STRING(50),//跟进者唯一码
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求号不能为空");
    }
    // if(!ab.followManMobile){
    //   return system.getResultFail(-102,"跟进人手机号不能为空");
    // }
    // if(!ab.followManOnlyCode){
    //   return system.getResultFail(-103,"跟进人唯一码不能为空");
    // }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-102, "未知需求信息");
    }
    var ns = await this.dao.model.findAll({
      where: { needNo: needinfo.needNo}, raw: true,
      attributes: ["needNo", "solutionNo", "channelSolutionNo", "orderNo", "solutionContent", "status", "statusName"]
    });
    return system.getResultSuccess(ns);
  }
  //提交方案
  async submitIcpProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "渠道需求号不能为空");
    }
    if (!ab.solutionContent) {
      return system.getResultFail(-102, "方案信息有误");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    var bizType = ab.solutionContent.bizType;//icp业务类型
    if (!bizType || !needinfo.typeCode || bizType != needinfo.typeCode) {
      return system.getResultFail(-205, "方案类型错误");
    }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-206, "渠道方案类型错误");
    }
    ab.solutionContent.typeCode = needinfo.typeCode;
    ab.solutionContent.typeName = needinfo.typeName;
    var ns = await this.dao.model.findAll({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    for (var i = 0; i < ns.length; i++) {
      var fa = ns[i];
      if (fa.status != "yzf") {
        return system.getResultFail(-207, "需求方案已存在，不能重复提交");
      }
    }
    // ab.solutionContent.bizType=needinfo.channelTypeCode;
    // bizType =needinfo.channelTypeCode;
    if (!ab.solutionContent.solution) {
      return system.getResultFail(-104, "业务方案信息不能为空");
    }
    var solution = ab.solutionContent.solution;
    if (!solution) {
      return system.getResultFail(-103, "方案交付信息有误");
    }
    if (needinfo.channelTypeCode == "7") {//edi
      ab.solutionContent.solution.IcpType = 2;
    }
    if (needinfo.channelTypeCode == "5") {//icp
      ab.solutionContent.solution.IcpType = 1;
    }
    ab.solutionContent.applicationStatusList = [{
      "OfficialFileURL": "",
      "ApplicationStatus": "submitIcpProgramme",
      "ApplicationStatusName": "提交方案",
      "created_at": new Date()
    }];
    if (!solution.CompanyName) {
      return system.getResultFail(-105, "公司名不能为空");
    }
    if (!solution.CompanyAddress) {
      return system.getResultFail(-106, "公司地址不能为空");
    }
    if (!solution.Area) {
      return system.getResultFail(-107, "区域不能为空");
    }
    var solutionFlowList = ab.solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "SOLUTION_SUBMIT", statusName: this.icpSolutionStatusReference.SOLUTION_SUBMIT, updated_at: new Date()
    });
    ab.solutionContent.status = "SOLUTION_SUBMIT";
    ab.solutionContent.statusName = this.icpSolutionStatusReference.SOLUTION_SUBMIT;
    ab.solutionContent.solutionFlowList = solutionFlowList;
    ab["channelNeedNo"] = needinfo.channelNeedNo;
    var solutionNo = await this.getBusUid("ns");
    ab["solutionNo"] = solutionNo;
    ab["status"] = "dqr";
    ab.solutionContent["notes"] = "";
    ab.solutionContent["totalSum"] = "";
    ab.solutionContent = JSON.stringify(ab.solutionContent);
    var self = this;
    return await this.db.transaction(async function (t) {
      ab["needNo"] = needinfo.needNo;
      var od = await self.dao.create(ab, t);
      if (od && od.id) {
        var pushflag = 0;//推送标志 值为1推送小记
        var needObj = {
          id: needinfo.id
        };
        if (!needinfo.followManUserId) {
          needObj = {
            id: needinfo.id,
            followManUserId: user.id,//跟进人id
            followManName: user.channel_username,//跟进人姓名
            followManMobile: user.mobile,//跟进人手机号（合伙人）
            followManOnlyCode: user.channel_userid
          };
        }
        if (!needinfo.followContent) {
          var followContent = {
            followDate: new Date(),
            content: "icp提交到方案"
          };
          followContent = JSON.stringify(followContent);
          needObj["followContent"] = followContent;
          pushflag = 1;
        }
        await self.needinfoDao.update(needObj, t);
        needinfo = await self.needinfoDao.model.findOne({
          where: { id: needinfo.id }, raw: true
        });
        needinfo["pushflag"] = pushflag;
        return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
      } else {
        return system.getResultFail(-202, "提交方案失败");
      }
    })

  }
  //修改icp方案-- 无效
  async updateIcpProgramme(pobj) {

  }
  //提交icp材料信息
  async submitIcpMaterial(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.BizId) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    if (!ab.material) {
      return system.getResultFail(-102, "材料信息有误");
    }
    //获取方案信息
    var needsolutioninfo = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.BizId }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    var solutionContent = needsolutioninfo.solutionContent;
    if (!solutionContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
    if (solutionContent.status != "USER_UPLOADED") {
      return system.getResultFail(-403, "用户未上传材料，不能执行此操作");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: needsolutioninfo.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var material = ab.material;
    if (!material.Domain) {
      return system.getResultFail(-101, "备案域名不能为空");
    }
    if (!material.hasOwnProperty("IncludeForeignInvestment")) {
      return system.getResultFail(-102, "包含外贸参数不能为空");
    }
    if (!material.PartnerBusinessLicense) {
      return system.getResultFail(-103, "营业执照不能为空");
    }
    if (!material.PartnerIdCardList || material.PartnerIdCardList.length < 1) {
      return system.getResultFail(-105, "相关人员身份证不能为空");
    }
    if (!material.PartnerDomainCertificate) {
      return system.getResultFail(-106, "域名证书不能为空");
    }
    // if(!material.PartnerPreviewOtherList || material.PartnerPreviewOtherList.length<1){
    //   return system.getResultFail(-107,"合作方递交其他供预览文件不能为空");
    // }
    solutionContent.material = ab.material;
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "MATERIAL_UNCONFIRM", statusName: this.icpSolutionStatusReference.MATERIAL_UNCONFIRM, updated_at: new Date()
    });
    solutionContent.status = "MATERIAL_UNCONFIRM";
    solutionContent.statusName = this.icpSolutionStatusReference.MATERIAL_UNCONFIRM;
    needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
    var self = this;
    return await this.db.transaction(async function (t) {
      await self.dao.update(needsolutioninfo, t);
      needsolutioninfo = await self.dao.model.findOne({
        where: { channelSolutionNo: ab.BizId }, raw: true
      });
      return system.getResultSuccess(needsolutioninfo);

    })
  }
  //服务商通知状态变更
  async acceptIcpPartnerNotification(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.BizId) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    if (!ab.ApplicationStatus) {
      return system.getResultFail(-102, "通知状态不能为空");
    }
    //获取方案信息
    var needsolutioninfo = await this.dao.model.findOne({
      attributes:["id","needNo","solutionContent","status"],
      where: { channelSolutionNo: ab.BizId }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    var solutionContent = needsolutioninfo.solutionContent;
    if (!solutionContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: needsolutioninfo.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var applicationStatusList = solutionContent.applicationStatusList || [];
    var solutionFlowList = solutionContent.solutionFlowList || [];
    var statusObj = {
      "OfficialFileURL": ab.OfficialFileURL || "",
      "ApplicationStatus": ab.ApplicationStatus,
      "ApplicationStatusName": ab.ApplicationStatus,
      "created_at": new Date()
    };
    applicationStatusList.push(statusObj);
    solutionContent.applicationStatusList = applicationStatusList;
    if (ab.ApplicationStatus == 507) {//完成账户注册
      solutionFlowList.push({
        status: "ACCOUNT_REGISTERED", statusName: this.icpSolutionStatusReference.ACCOUNT_REGISTERED, updated_at: new Date()
      });
      solutionContent.status = "ACCOUNT_REGISTERED";
      solutionContent.statusName = this.icpSolutionStatusReference.ACCOUNT_REGISTERED;
      // this.icpSolutionStatusReference={
      //   UN_PAID:"未支付",PAID:"用户支付",USER_UPLOADED:"用户上传资料",MATERIAL_UNCONFIRM:"服务商递交⽂件"
      //   ,USER_CONFIRMED:"⽤户已确认递交⽂件",ACCOUNT_REGISTERED:"完成账户注册",MATERIAL_SUBMITTED:"完成资料递交",
      //   GXB_ACCEPT:"⼯信部已受理",GXB_REFUSE:"⼯信部不予受理",GXB_FAIL:"⼯信部未通过"
      //   ,CLOSE:"方案关闭"
      // };
    }
    if (ab.ApplicationStatus == 508) {//"服务商完成提交资料到⼯信部
      solutionFlowList.push({
        status: "MATERIAL_SUBMITTED", statusName: this.icpSolutionStatusReference.MATERIAL_SUBMITTED, updated_at: new Date()
      });
      solutionContent.status = "MATERIAL_SUBMITTED";
      solutionContent.statusName = this.icpSolutionStatusReference.MATERIAL_SUBMITTED;
    }
    if (ab.ApplicationStatus == 509) {//⼯商部已受理
      solutionFlowList.push({
        status: "GXB_ACCEPT", statusName: this.icpSolutionStatusReference.GXB_ACCEPT, updated_at: new Date()
      });
      solutionContent.status = "GXB_ACCEPT";
      solutionContent.statusName = this.icpSolutionStatusReference.GXB_ACCEPT;
    }
    if (ab.ApplicationStatus == 510) {//⼯商部不予受理
      solutionFlowList.push({
        status: "GXB_REFUSE", statusName: this.icpSolutionStatusReference.GXB_REFUSE, updated_at: new Date()
      });
      solutionContent.status = "GXB_REFUSE";
      needsolutioninfo.status = "yzf";
      solutionContent.statusName = this.icpSolutionStatusReference.GXB_REFUSE;
    }
    if (ab.ApplicationStatus == 511) {//⼯商部通过
      solutionFlowList.push({
        status: "GXB_SUCCESS", statusName: this.icpSolutionStatusReference.GXB_SUCCESS, updated_at: new Date()
      });
      needsolutioninfo.status = "ywc";
      needsolutioninfo.status = "ywc";
      solutionContent.status = "GXB_SUCCESS";
      solutionContent.statusName = this.icpSolutionStatusReference.GXB_SUCCESS;
    }
    if (ab.ApplicationStatus == 512) {//⼯信部未通过
      solutionFlowList.push({
        status: "GXB_FAIL", statusName: this.icpSolutionStatusReference.GXB_FAIL, updated_at: new Date()
      });
      solutionContent.status = "GXB_FAIL";
      needsolutioninfo.status = "yzf";
      solutionContent.statusName = this.icpSolutionStatusReference.GXB_FAIL;
    }
    solutionContent.solutionFlowList = solutionFlowList;
    needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
    var self = this;
    return await this.db.transaction(async function (t) {
      await self.dao.update(needsolutioninfo, t);
      // needsolutioninfo = await self.dao.model.findOne({
      //   where: { channelSolutionNo: ab.BizId }, raw: true
      // });
      statusObj["BizId"] = ab.BizId;
      return system.getResultSuccess(statusObj);
    })
  }
  //服务商方案作废 -- abolishIcpProgramme
  async abolishIcpProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.Note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    }
    //获取方案信息
    var ns = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.BizId, createUserId: user.id }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    if (ns.status != "dqr") {
      return system.getResultFail(-103, "方案状态错误，只能废弃待确认方案");
    }
    var solutionContent = ns.solutionContent;
    if (!solutionContent.status || ["USER_UPLOADED", "MATERIAL_UNCONFIRM", "USER_CONFIRMED", "ACCOUNT_REGISTERED", "MATERIAL_SUBMITTED"].indexOf(solutionContent.status) < 0) {
      return system.getResultFail(-108, "方案流程状态错误，不能执行此操作");
    }
    solutionContent.solution.Note = ab.Note;
    solutionContent = JSON.stringify(solutionContent);
    await this.dao.update({ id: ns.id, status: "yzf", solutionContent: solutionContent });//方案废弃
    //获取方案信息
    ns = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.BizId, createUserId: user.id }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //确认方案
  async confirmIcpIntention(pobj) {
    return system.getResultFail();
  }
  //接收渠道方案状态变更通知
  async receiveIcpStatusNotify(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "方案状态不能为空");
    }
    //获取方案信息
    var ns = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.BizId }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    if (ns.status != "dqr" && ns.status != "yzf") {
      return system.getResultFail(-103, "方案状态错误，不能作废已完成方案");
    }
    var solutionContent = ns.solutionContent;
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    if (ab.status == "2") {//⽤户已上传
      solutionFlowList.push({
        status: "USER_UPLOADED", statusName: this.icpSolutionStatusReference.USER_UPLOADED, updated_at: new Date()
      });
      solutionContent.status = "USER_UPLOADED";
      solutionContent.statusName = this.icpSolutionStatusReference.USER_UPLOADED;
    }
    if (ab.status == "4") {//⽤户已确认
      solutionFlowList.push({
        status: "USER_CONFIRMED", statusName: this.icpSolutionStatusReference.USER_CONFIRMED, updated_at: new Date()
      });
      solutionContent.status = "USER_CONFIRMED";
      solutionContent.statusName = this.icpSolutionStatusReference.USER_CONFIRMED;
    }
    if (ab.status == "11") {//⽅案已关闭
      solutionFlowList.push({
        status: "CLOSE", statusName: this.icpSolutionStatusReference.CLOSE, updated_at: new Date()
      });
      solutionContent.status = "CLOSE";
      solutionContent.statusName = this.icpSolutionStatusReference.CLOSE;
    }
    solutionContent.solutionFlowList = solutionFlowList;

    var material = solutionContent.material || {};
    if (ab.remark) {
      solutionContent.notes = ab.remark;
    }
    if (ab.newbusinessLicense) {
      material.PartnerBusinessLicense = ab.newbusinessLicense;
      material.aliPartnerBusinessLicense = ab.businessLicense;
    }
    if (ab.newidCardUrlList && ab.newidCardUrlList.length > 0) {
      material.PartnerIdCardList = ab.newidCardUrlList;
      material.aliPartnerIdCardList = ab.idCardUrlList;
    }
    if (ab.newuserPlan) {
      material.PartnerPlan = ab.newuserPlan;
      material.aliPartnerPlan = ab.userPlan;
    }
    if (ab.newuserForeig) {
      material.PartnerForeignInvestment = ab.newuserForeig;
      material.aliPartnerForeignInvestment = ab.userForeig;
    }
    if (ab.newuserLaw) {
      material.PartnerLaw = ab.newuserLaw;
      material.aliPartnerLaw = ab.userLaw;
    }
    if (ab.newuserOtherList && ab.newuserOtherList.length > 0) {
      material.PartnerSignAndStampOtherList = ab.newuserOtherList;
      material.aliPartnerSignAndStampOtherList = ab.userOtherList;
    }
    solutionContent.material = material;
    solutionContent = JSON.stringify(solutionContent);
    var updateObj = {
      id: ns.id, solutionContent: solutionContent
    };
    if (ab.status == "11") {//⽅案已关闭
      updateObj["status"] = "yzf";
    }
    // else if(ab.status == "2" || ab.status == "4"){ //2, "⽤户已上传"  4, "⽤户已确认"
    //   updateObj["status"]="dqr";
    // }
    await this.dao.update(updateObj);//方案状态修改
    ns = await this.dao.model.findOne({
      where: { channelSolutionNo: ab.BizId }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //接收icp用户方案反馈
  async receiveIcpFeedback(pobj) {
    var ab = pobj.actionBody;
    if (!ab.intentionBizId) {
      return system.getResultFail(-101, "渠道需求编号错误");
    }
    if (!ab.description) {
      return system.getResultFail(-102, "问题描述不能为空");
    }
    if (!ab.hasOwnProperty("intentionStatus")) {
      return system.getResultFail(-103, "需求当前状态不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.dao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId, status: "dqr" }, raw: true
    });
    if (!ns) {
      return system.getResultFail(-106, "未知方案");
    }
    var intentionStatusList = ["未知", "⽅案待服务商确认", "⽅案待⽤户确认", "处理中", "已完成", "已关闭"];
    var updateObj = {
      id: ns.id
    };
    var solutionContent = ns.solutionContent;
    solutionContent.notes = ab.description;
    solutionContent.needStatus = ab.intentionStatus;
    if (ab.intentionStatus == 1 || ab.intentionStatus == 2 || ab.intentionStatus == 3) {
      updateObj["status"] = "dqr";
    } else if (ab.intentionStatus == 4) {
      updateObj["status"] = "ywc";
    } else if (ab.intentionStatus == 5) {
      updateObj["status"] = "yzf";
    } else {
      return system.getResultFail(-107, "需求当前状态错误--" + ab.intentionStatus);
    }
    solutionContent.needStatusName = intentionStatusList[ab.intentionStatus];
    solutionContent = JSON.stringify(solutionContent);
    updateObj["solutionContent"] = solutionContent;
    await this.dao.update(updateObj);//方案状态修改
    return system.getResultSuccess();
  }
  //获取方案详情（内部调用）
  async getIcpProgrammeDetail(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    //获取方案信息
    var ns = await this.dao.model.findAll({
      where: { channelSolutionNo: ab.BizId }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //获取方案详情（前端调用）
  async getNeedSolutionDetailByUser(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    // ab["createUserId"]=user.id;
    if (!ab.solutionNo) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    //获取方案信息
    var ns = await this.dao.model.findOne({
      where: { solutionNo: ab.solutionNo, createUserId: user.id }, raw: true
    });
    if (ns && ns.needNo) {
      var needinfo = await this.needinfoDao.model.findOne({
        where: { needNo: ns.needNo }, raw: true,
        attributes: ["publishName", "publishMobile", "channelUserId"]
      });
      ns.needinfo = needinfo;
    }
    return system.getResultSuccess(ns);
  }
  //---------------------icp注册-end-----------------------------------------------------------------
  // --------------庄冰2020.10.23-------百度Icp接入使用--------start------------------
  //接收方案状态及支付信息
  async receiveSolutionPayInfoNew(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.channelSolutionNo) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    if(ab.isDirectBuy && ab.isDirectBuy==1){//直接下单
      var oldNs = await this.dao.model.findOne({
        where: { orderNo: ab.orderNo }, raw: true
      });
      var newNsObj={
        orderNo:ab.orderNo,channelSolutionNo:ab.channelSolutionNo,solutionNo:ab.channelSolutionNo,
        needNo:ab.bizId,channelNeedNo:ab.bizId,status:"ywc"
      };
      var newSolutionCount = {
          "status": "PAID",
          "bizType": ab.product_info && ab.product_info.item_code?ab.product_info.item_code:"",
          "solution": {
              "Area": ab.area || "",
              "IcpType": ab.consultType,
              "CompanyName": ab.companyName || "",
              "CompanyAddress": ab.area || ""
          },
          "totalSum": ab.totalSum || "",
          "typeCode": ab.product_info && ab.product_info.item_code?ab.product_info.item_code:"",
          "typeName": ab.product_info && ab.product_info.item_name?ab.product_info.item_name:"",
          "needStatus": "3",
          "statusName": "用户支付",
          "customerInfo": {
              "publishName": pobj.userInfo.channel_nickname || "",
              "publishMobile": pobj.userInfo.mobile || ""
          },
          "customerRemark": "",
          "needStatusName": "处理中",
          "customerMaterial": {},
          "solutionFlowList": [
              {
                  "status": "PAID",
                  "statusName": "用户支付",
                  "updated_at": new Date()
              }
          ]
      };
      newNsObj.solutionContent = JSON.stringify(newSolutionCount);
      var ns = null;
      if(oldNs && oldNs.id){
        ns = oldNs;
      }else{
        ns = await this.dao.create(newNsObj);
      }
      var ns2 = await this.dao.model.findOne({
        where: { id: ns.id }, raw: true
      });
      return system.getResultSuccess(ns2);
    }else{
      var needsolutioninfo = await this.dao.model.findOne({
        attributes:["id","solutionContent","status","orderNo"],
        where: { channelSolutionNo: ab.channelSolutionNo,isInvalid:0 }, raw: true
      });
      if (!needsolutioninfo || !needsolutioninfo.id) {
        return system.getResultFail(-400, "未知方案");
      }
      var solutionContent = needsolutioninfo.solutionContent;
      if (ab.orderPrice) {
        // solutionContent = JSON.parse(solutionContent);
        solutionContent["totalSum"] = Number(ab.orderPrice || "0");
      }
      // 2020 1017 lin 新增去掉status的判断，生成订单这个方案才算完成，所以没必要再判断，另一个原因网文2.3每个状态都有不同status，所以不能以来有没有status来决定方案完成情况。
      // if (ab.status) {
      //   needsolutioninfo.status = "ywc";
      // }
      if (ab.orderNo) {
        needsolutioninfo.orderNo = ab.orderNo;
        needsolutioninfo.status = "ywc";
      }
      needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
      await this.dao.update(needsolutioninfo);
      var ns = await this.dao.model.findOne({
        where: { id: needsolutioninfo.id }, raw: true
      });
      return system.getResultSuccess(ns);
    }
    
  }
  // --------------庄冰2020.10.23-------百度Icp接入使用--------end------------------

  //创建方案信息
  async createNewSolution(pobj){
    let ab = pobj.actionBody;
    let app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.channelSolutionNo) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    let newNsObj={
      orderNo:ab.orderNo,channelSolutionNo:ab.channelSolutionNo,solutionNo:ab.channelSolutionNo,
      needNo:ab.bizId,channelNeedNo:ab.bizId,status:"ywc"
    };
    let newSolutionCount = {
      "status": "USER_UPLOADED",
      "bizType": ab.product_info && ab.product_info.channel_item_code?ab.product_info.channel_item_code:"",
      "solution": {
        "Area": ab.product_info.price_item.price_desc || "",
        "IcpType": '',
        "CompanyName": ab.companyName || "",
        "CompanyAddress": ab.area || ""
      },
      "totalSum": ab.order_info.totalSum || "",
      "typeCode": ab.product_info && ab.product_info.channel_item_code?ab.product_info.channel_item_code:"",
      "typeName": ab.product_info && ab.product_info.channel_item_name?ab.product_info.channel_item_name:"",
      "needStatus": "3",
      "statusName": "用户支付",
      "customerInfo": {
        "publishName":  "",
        "publishMobile":  ""
      },
      "customerRemark": "",
      "needStatusName": "处理中",
      "customerMaterial": {},
      "solutionFlowList": [
        {
          "status": "PAID",
          "statusName": "用户支付",
          "updated_at": new Date()
        }
      ]
    };
    newNsObj.solutionContent = JSON.stringify(newSolutionCount);
    let ns = await this.dao.create(newNsObj);
    return system.getResultSuccess(ns)
  }
  async addOrderDelivery(pobj){
    let ab = pobj.actionBody;
    let app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.bizId }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-102, "未知需求信息");
    }
    let newNsObj={
      orderNo:ab.serviceOrderNo,
      channelSolutionNo:ab.BizId,
      solutionNo:ab.BizId,
      needNo:needinfo.needNo,
      channelNeedNo:ab.IntentionBizId,
      status:"ywc"
    };
    newNsObj.solutionContent = JSON.stringify(ab);
    let ns = await this.dao.create(newNsObj);
    return system.getResultSuccess(ns)
  }
}
module.exports = NeedsolutionService;
// var task = new NeedsolutionService();
// task.dao.model.findOne({
//   where:{solutionNo: "NS202003181420k00Oec"},raw:true
// }).then(needsolutioninfo=>{
//   console.log(needsolutioninfo,"1111111111111111111111111");
//   var solutionContent = needsolutioninfo.solutionContent;
//   console.log(typeof(solutionContent),"222222222222222222222");
//   // var so = JSON.parse(solutionContent);
//   console.log(solutionContent.bizType,"333333333333333333333");
// });


