const system = require("../../../system");
const moment = require('moment')
/**
 * 百度增值电信相关接口（ICP、EDI）
 * created by zhuangbing
 * created at 2020.07.27
 */
class BaiduQcService {
  constructor() {
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.icpSolutionStatusReference = {
      SOLUTION_SUBMIT: "提交服务单",
      UN_PAID: "未支付", PAID: "用户支付", USER_UPLOADED: "用户上传资料", MATERIAL_UNCONFIRM: "服务商递交⽂件"
      , USER_CONFIRMED: "⽤户已确认递交⽂件", ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
      GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
      , CLOSE: "方案关闭"
    };
    this.ediSolutionStatusReference = {
      SOLUTION_SUBMIT: "服务单通知服务商",
      USER_PAY_PRODUCE: "⽤户⽀付",
      USER_CONFIRM_PRODUCE: "⽤户确认资料",
      USER_REFUSE_PRODUCE: "资料退回修改",
      ABC_CLOSE_PRODUCE: "⼩⼆后台关闭服务单",
      USER_UPLOAD_PRODUCE: "⽤户补充基本资料"
    };
    this.ediProduceStatus = {
      110: "⽤户⽀付",
      30: "待⽤户确认",
      105: "账户已注册",
      35: "待提交审核",
      109: "管局已通过",
      106: "材料已递交⼯信部",
      10: "已⽀付",
      108: "管局不予受理",
      0: "初始状态",
      50: "订单关闭",
      25: "待⽤户提交材料",
      107: "管局已受理"
    };
    this.icpApplicationStatusReference = {
      507: "完成账户注册",
      508: "服务商完成提交资料到⼯信部",
      509: "⼯商部已受理",
      510: "⼯商部不予受理",
      511: "⼯商部通过",
      512: "⼯商部未通过"
    };
    //(文网文状态2020-9-26)
    this.wangwenStatusReference = {
      601: "服务商提交资料",
      602: "完成账户注册",
      603: "服务商完成提交资料到⼯信部",
      604: "⼯商部已受理",
      605: "⼯商部不予受理",
      606: "⼯商部通过",
      607: "⼯商部未通过",
      608: "用户驳回"
    };
    //(文网文状态2020-9-26)
    this.wangwenSolutionStatusReference = {
      "SOLUTION_SUBMIT": "提交服务单",
      "PARTNER_SUBMIT_MATERIAL": "服务商提交资料",
      "CERT_ACCOUNT_REGISTERED": "完成账户注册",
      "CERT_MATERIAL_SUBMITTED": "服务商完成提交资料到⼯信部",
      "CERT_GXB_ACCEPT": "⼯商部已受理",
      "CERT_GXB_SUCCESS": "⼯商部通过",
      "CERT_GXB_FAIL": "⼯商部未通过",
      "CERT_GXB_REFUSE": "⼯商部不予受理"
    };
  }

  //接收渠道方案状态变更通知
  async receiveOrderStatusNotify(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "方案状态不能为空");
    }
    if(ab.isDirectBuy && ab.isDirectBuy==1 && ab.status==1){//直接下单，无方案 直接返回
      return system.getResultSuccess();
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.BizId, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var solutionContent = ns.solutionContent;
    var checkStatus = {
      ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
      GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
      , CLOSE: "方案关闭"
    };
    if (solutionContent.status && checkStatus[solutionContent.status]) {
      return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
    }
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    if (ab.status == "1") {//⽤户已支付
      var afterStatusList=[//用户支付后的流程状态
        "USER_UPLOADED", "MATERIAL_UNCONFIRM", "USER_CONFIRMED", "ACCOUNT_REGISTERED",
        "MATERIAL_SUBMITTED","GXB_ACCEPT","GXB_REFUSE","GXB_FAIL","GXB_SUCCESS","CLOSE"
      ];
      if(!solutionContent.status || afterStatusList.indexOf(solutionContent.status)<0){
        solutionFlowList.push({
          status: "PAID", statusName: this.icpSolutionStatusReference.PAID, updated_at: new Date()
        });
        solutionContent.status = "PAID";
        solutionContent.statusName = this.icpSolutionStatusReference.PAID;
      }
      // 2020 0826 lin修改 n_need_info status为ycd 已成单
      let needObj = {
        id: needinfo.id, status: "ycd"
      }
      await this.needinfoDao.update(needObj);//关闭需求
    } else if (ab.status == "2") {//⽤户已上传
      if (solutionContent.status == "USER_CONFIRMED") {//防止用户确认后又否决
        return system.getResultFail(-112, "操作失败，⽤户已确认递交⽂件");
      }
      solutionFlowList.push({
        status: "USER_UPLOADED", statusName: this.icpSolutionStatusReference.USER_UPLOADED, updated_at: new Date()
      });
      solutionContent.status = "USER_UPLOADED";
      solutionContent.statusName = this.icpSolutionStatusReference.USER_UPLOADED;
    } else if (ab.status == "4") {//⽤户已确认
      if (solutionContent.status != "MATERIAL_UNCONFIRM") {
        return system.getResultFail(-113, "操作失败，服务商递交⽂件后才能执行此操作");
      }
      solutionFlowList.push({
        status: "USER_CONFIRMED", statusName: this.icpSolutionStatusReference.USER_CONFIRMED, updated_at: new Date()
      });
      solutionContent.status = "USER_CONFIRMED";
      solutionContent.statusName = this.icpSolutionStatusReference.USER_CONFIRMED;
    } else if (ab.status == "11") {//⽅案已关闭
      solutionFlowList.push({
        status: "CLOSE", statusName: this.icpSolutionStatusReference.CLOSE, updated_at: new Date()
      });
      solutionContent.status = "CLOSE";
      solutionContent.statusName = this.icpSolutionStatusReference.CLOSE;
    } else {
      return system.getResultFail(-110, "状态错误");
    }
    solutionContent.solutionFlowList = solutionFlowList;

    var material = solutionContent.customerMaterial || {};
    if (ab.remark) {
      solutionContent.customerRemark = ab.remark;
    }
    if (ab.newbusinessLicense) {
      material.businessLicense = ab.newbusinessLicense;
      material.aliBusinessLicense = ab.businessLicense;
    }
    if (ab.newidCardUrlList && ab.newidCardUrlList.length > 0) {
      material.idCardUrlList = ab.newidCardUrlList;
      material.aliIdCardUrlList = ab.idCardUrlList;
    }
    if (ab.newuserPlan) {
      material.userPlan = ab.newuserPlan;
      material.aliUserPlan = ab.userPlan;
    }
    if (ab.newuserForeig) {
      material.userForeig = ab.newuserForeig;
      material.aliUserForeig = ab.userForeig;
    }
    if (ab.newuserLaw) {
      material.userLaw = ab.newuserLaw;
      material.aliUserLaw = ab.userLaw;
    }
    if (ab.newuserOtherList && ab.newuserOtherList.length > 0) {
      material.userOtherList = ab.newuserOtherList;
      material.aliUserOtherList = ab.userOtherList;
    }
    solutionContent.customerMaterial = material;
    solutionContent = JSON.stringify(solutionContent);
    var updateObj = {
      id: ns.id, solutionContent: solutionContent
    };
    if (ab.status == "11") {//⽅案已关闭
      updateObj["status"] = "yzf";
      updateObj["isInvalid"] = 1;
    }
    await this.needsolutionDao.update(updateObj);//方案状态修改
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    return system.getResultSuccess(ns);
  }
  //关闭ICP订单 百度icp 2.4
  async icpOrderClose(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "渠道订单号不能为空");
    }
    var orderInfo = await this.orderinfoDao.model.findOne({
      where:{channelOrderNo:ab.orderNo},raw:true
    });
    if (!orderInfo || !orderInfo.id) {
      return system.getResultFail(-103, "未知订单");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: orderInfo.orderNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    var solutionContent = ns.solutionContent;
    var checkStatus = {
      MATERIAL_UNCONFIRM:"服务商递交文件",
      ACCOUNT_REGISTERED: "完成账户注册", MATERIAL_SUBMITTED: "完成资料递交",
      GXB_ACCEPT: "⼯信部已受理", GXB_REFUSE: "⼯信部不予受理", GXB_FAIL: "⼯信部未通过", GXB_SUCCESS: "工信部通过"
    };
    if (solutionContent.status && checkStatus[solutionContent.status]) {
      return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
    }
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "CLOSE", statusName: this.icpSolutionStatusReference.CLOSE, updated_at: new Date()
    });
    solutionContent.status = "CLOSE";
    solutionContent.statusName = this.icpSolutionStatusReference.CLOSE;
    solutionContent.solutionFlowList = solutionFlowList;
    if (ab.remark) {
      solutionContent.customerRemark = ab.remark;
    }
    solutionContent = JSON.stringify(solutionContent);
    var updateObj = {
      id: ns.id, solutionContent: solutionContent,status:"yzf",isInvalid:1
    };
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      await self.needsolutionDao.update(updateObj);//方案状态修改
      // await this.orderinfoDao.update({id:orderInfo.id,orderStatus:16});//订单状态修改
      var new_ns = await self.needsolutionDao.model.findOne({
        where: { id: ns.id }, raw: true
      });
      return system.getResultSuccess(new_ns);
    })
    
  }
  //添加业务员信息，用于直接下单的icp订单
  async addIcpSalesmanInfo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    var salesmanObj = ab.salesmanInfo;
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var solutionContent = ns.solutionContent;
    solutionContent.salesmanInfo=salesmanObj;
    var updateObj = {id:ns.id,solutionContent:JSON.stringify(solutionContent)}
    await this.needsolutionDao.update(updateObj);//方案状态修改
    return system.getResultSuccess(solutionContent);
  }
  
  // //易名退款2021-3-23
  // async eNameCloseOrder(pobj){
  //   console.log('order----eNameCloseOrder',pobj)
  //   let orderNo
  //   let note 
  //   orderNo = pobj.actionBody.orderNo
  //   note = pobj.actionBody.note
  //   if(!orderNo){
  //     return system.getResultFail(-1011, "订单号不能为空");
  //   }
  //   if(!note){
  //     return system.getResultFail(-1012, "订单关闭理由不能为空");
  //   }
  //   let orderInfo = await this.orderinfoDao.model.findOne({
  //     where: { channelOrderNo: orderNo }, raw: true
  //   });

  //   let UpdateObj = {
  //     id: orderInfo.id, 
  //     orderStatus: 16,
  //     orderStatusName:"已退款"
  //   }
  //   let res = await this.orderinfoDao.update(UpdateObj);//更新订单
  // }
}
module.exports = BaiduQcService;
