const system = require("../../../system");
const moment = require('moment');
/**
 * 网文相关接口（NC）
 * laolan
 * 2020.11.11
 */
class NcService {
  constructor() {
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.orderdeliveryDao = system.getObject("db.dbcorder.orderdeliveryDao");
    this.db = system.getObject("db.common.connection").getCon()
    this.ncStatusReference = {
      507: "完成账户注册",
      508: "服务商完成提交资料到⼯信部",
      509: "⼯商部已受理",
      510: "⼯商部不予受理",
      511: "⼯商部通过",
      512: "⼯商部未通过"
    };
    //网文状态2020-11-11 baidu
    this.ncSolutionStatus = {
      "SOLUTION_SUBMIT": "提交服务单",
      "MATERIAL_UNCONFIRM": "服务商递交⽂件",
      "REGISTRATION": "完成账户注册",
      "SUBMITTED": "服务商完成提交资料到⼯信部",
      "ACCEPTED": "⼯商部已受理",
      "NOT_ACCEPTED": "⼯商部不予受理",
      "APPROVED": "⼯商部通过",
      "NOT_APPROVED": "⼯商部未通过",
      "CLOSE": "方案关闭"
    };

    //网文状态2020-11-11 baidu
    this.ncSNumberStatus = {
      // "SOLUTION_SUBMIT": "提交服务单",
      "MATERIAL_UNCONFIRM": 506,
      "REGISTRATION": 507,
      "SUBMITTED": 508,
      "ACCEPTED": 509,
      "NOT_ACCEPTED": 510,
      "APPROVED": 511,
      "NOT_APPROVED": 512
      // "CLOSE": "方案关闭"
    };
  }
  

  //交付商提交材料信息
  async ncSubmitMaterial(pobj) {
    var ab = pobj.actionBody;
    console.log('ab++',ab)
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-301, "未知方案");
    }
    ab["bizId"] = ns.channelSolutionNo;
    pobj.actionBody = ab;
    return this.submitNcMaterial(pobj);
  }
  //提交材料信息
  async submitNcMaterial(pobj) {
    var ab = pobj.actionBody;
    console.log('ababab++',ab)
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.bizId) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    if (!ab.material) {
      return system.getResultFail(-102, "材料信息有误");
    }
    //获取方案信息
    var needsolutioninfo = await this.needsolutionDao.model.findOne({
      attributes: ["id", "needNo", "orderNo", "solutionContent"],
      where: { channelSolutionNo: ab.bizId, isInvalid: 0 }, raw: true
    });
    console.log('needsolutioninfo+++',needsolutioninfo)
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    var solutionContent = needsolutioninfo.solutionContent;
    if (!solutionContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
     //----
     var productType = solutionContent.solution;
     if(productType &&  productType.IcpType){
       productType = productType.IcpType
     }
     //----
    var orderInfo = await this.orderinfoDao.model.findOne({
      where: {orderNo: needsolutioninfo.orderNo}, raw: true
    })
    if(orderInfo){
      var uappId = orderInfo.uapp_id
    }
    if (!ab.material.businessLicense.name) {
      return system.getResultFail(-101, "公司名称不能为空");
    }
    if (!ab.material.partnerBusinessLicense) {
      return system.getResultFail(-103, "营业执照不能为空");
    }
    console.log('solutionContent++++++---------------',solutionContent)
    solutionContent.material = ab.material;
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "MATERIAL_UNCONFIRM", statusName: this.ncSolutionStatus.MATERIAL_UNCONFIRM, updated_at: new Date()
    });
    solutionContent.status = "MATERIAL_UNCONFIRM";
    solutionContent.statusName = this.ncSolutionStatus.MATERIAL_UNCONFIRM;
    needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
    let deliveryContent = needsolutioninfo.solutionContent;
    let orderdeliveryData = {
      sourceOrderNo : ab.orderNo,
      deliveryContent : deliveryContent,
    }
    let orderdeliverySqlData = {
      sourceOrderNo:ab.orderNo
    }
    let orderdeliverySql = "SELECT * FROM `c_order_delivery` WHERE sourceOrderNo = :sourceOrderNo  ORDER BY id DESC limit 1";
    let orderdeliveryInfo = await this.orderdeliveryDao.customQuery(orderdeliverySql,orderdeliverySqlData)
    if(!orderdeliveryInfo[0]){
      let sql = "INSERT INTO `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUES (:sourceOrderNo,:deliveryContent)";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql, orderdeliveryData);
    }else{
      let sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + deliveryContent + "' where sourceOrderNo='" + ab.orderNo + "'";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql);
    }
    needsolutioninfo['orderChannelNo'] = orderInfo.channelOrderNo;
    needsolutioninfo['uapp_id'] = uappId;
    needsolutioninfo['productType'] = productType;
    console.log('nc orderdelivery+++',needsolutioninfo)
    return system.getResultSuccess(needsolutioninfo);
  }

  //提交方案
  async ncSubmitSolution(pobj) {
    console.log("pobj++++",pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "渠道需求号不能为空");
    }
    if (!ab.solutionContent) {
      return system.getResultFail(-102, "方案信息有误");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    var bizType = needinfo.typeCode;//ab.solutionContent.bizType;//业务类型
    ab.solutionContent.bizType = bizType;
    if (!bizType) {
      return system.getResultFail(-205, "方案类型错误");
    }
    
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-206, "渠道方案类型错误");
    }
    ab.solutionContent.typeCode = needinfo.typeCode;
    ab.solutionContent.typeName = needinfo.typeName;
    var ns = await this.needsolutionDao.model.findAll({
      where: { channelNeedNo: ab.needNo }, raw: true, order: [["id", 'asc']]
    });
    for (var i = 0; i < ns.length; i++) {
      var fa = ns[i];
      if (fa.status == "dqr" || fa.status == "ywc") {
        return system.getResultFail(-207, "需求方案已存在，不能重复提交");
      }
      if (fa.status == "ybh") {
        ab.channelSolutionNo = fa.channelSolutionNo;
      }
      if (fa.status == "yzf") {
        ab.channelSolutionNo = "";
      }
    }
    var solution = ab.solutionContent.solution;
    if (!solution) {
      return system.getResultFail(-103, "方案交付信息有误");
    }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-104, "需求业务类型有误");
    }
    if (!solution.CompanyName) {
      return system.getResultFail(-105, "公司名不能为空");
    }
    if (!solution.LicenseType) {
      return system.getResultFail(-106, "业务类型不能为空");
    }
    if (!solution.Area) {
      return system.getResultFail(-107, "区域不能为空");
    }
    if (!solution.ActionType) {
      return system.getResultFail(-108, "办理类型不能为空");
    }
    var solutionFlowList = ab.solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "SOLUTION_SUBMIT", statusName: this.ncSolutionStatus.SOLUTION_SUBMIT, updated_at: new Date()
    });
    ab.solutionContent.status = "SOLUTION_SUBMIT";
    ab.solutionContent.statusName = this.ncSolutionStatus.SOLUTION_SUBMIT;
    ab.solutionContent.solutionFlowList = solutionFlowList;
    ab["channelNeedNo"] = needinfo.channelNeedNo;
    var solutionNo = await this.getBusUid("ns");
    ab["solutionNo"] = solutionNo;
    ab["status"] = "dqr";
    var customerInfo = {//客户信息
      "publishName": needinfo.publishName,
      "publishMobile": needinfo.publishMobile
    };
    var salesmanInfo = {//业务员信息
      "salesmanName": user.channel_username,
      "salesmanMobile": user.mobile,
      "salesmanId": user.id,
      "salesmanChannelId": user.channel_userid
    };
    ab.solutionContent["customerInfo"] = customerInfo;
    ab.solutionContent["salesmanInfo"] = salesmanInfo;
    ab.solutionContent.solution.SolutionPrice = (ab.solutionContent.solution.SolutionPrice) / 100 || "";//分转元
    ab.solutionContent = JSON.stringify(ab.solutionContent);
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      ab["needNo"] = needinfo.needNo;
      var od = await self.needsolutionDao.create(ab, t);
      if (od && od.id) {
        var needObj = {
          id: needinfo.id
        };
        if (!needinfo.followManUserId) {
          needObj = {
            id: needinfo.id,
            followManUserId: user.id,//跟进人id
            followManName: user.channel_username,//跟进人姓名
            followManMobile: user.mobile,//跟进人手机号（合伙人）
            followManOnlyCode: user.channel_userid
          };
        }
        if (!needinfo.followContent) {
          var followContent = [{
            followDate: new Date(),
            content: "nc提交方案"
          }];
          followContent = JSON.stringify(followContent);
          needObj["followContent"] = followContent;
        }
        await self.needinfoDao.update(needObj, t);
        needinfo = await self.needinfoDao.model.findOne({
          where: { id: needinfo.id }, raw: true
        });
        return system.getResultSuccess({ needinfo: needinfo, needsolution: od });
      } else {
        return system.getResultFail(-302, "提交方案失败");
      }
    })
  }
  
  //交付商通知状态变更
  async ncNotification(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "交付状态不能为空");
    } else {
      ab["ApplicationStatus"] = ab.status;
    }
    if (ab.officialFileURL) {
      ab["OfficialFileURL"] = ab.officialFileURL;
    }

    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-301, "未知方案");
    }
    ab["bizId"] = ns.channelSolutionNo;
    ab["solutionNo"] = ns.solutionNo;
    pobj.actionBody = ab;
    return this.ncAcceptPartnerNotification(pobj);
  }
  //服务商通知状态变更
  async ncAcceptPartnerNotification(pobj) {
    console.log('服务商通知状态变更pobj++++',pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    if (!ab.ApplicationStatus) {
      return system.getResultFail(-102, "通知状态不能为空");
    }
    //获取方案信息
    var needsolutioninfo = await this.needsolutionDao.model.findOne({
      attributes: ["id", "status", "solutionContent", "needNo"],
      where: { solutionNo: ab.solutionNo }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    //获取jiaofu信息
    let orderdeliverySqlData = {
      sourceOrderNo:ab.orderNo
    }
    let orderdeliverySql = "SELECT * FROM `c_order_delivery` WHERE sourceOrderNo = :sourceOrderNo  ORDER BY id DESC limit 1";
    let orderdeliveryInfo = await this.orderdeliveryDao.customQuery(orderdeliverySql,orderdeliverySqlData)
    if(orderdeliveryInfo[0] && orderdeliveryInfo[0].deliveryContent){
      var deliveryContent = orderdeliveryInfo[0].deliveryContent;
    }
    console.log('nc +++ deliveryContent+++',deliveryContent)
    if (!deliveryContent) {
      return system.getResultFail(-402, "方案交付信息有误");
    }
    if (this.ncSNumberStatus[deliveryContent.status] && this.ncSNumberStatus[deliveryContent.status] > ab.ApplicationStatus) {
      return system.getResultFail(-403, "操作失败，交付流程未按顺序执行");
    }
    if (this.ncSNumberStatus[deliveryContent.ApplicationStatus] && this.ncSNumberStatus[deliveryContent.ApplicationStatus] == ab.ApplicationStatus) {
      return system.getResultFail(-405, "操作失败，该流程状态已提交，不能重复提交");
    }
    
    var solutionFlowList = deliveryContent.solutionFlowList || [];
    var orderInfo = await this.orderinfoDao.model.findOne({
      attributes:["uapp_id","channelOrderNo"],
      where: {orderNo: ab.orderNo}, raw: true
    })
    console.log("orderInfo+++",orderInfo)
    if(orderInfo){
      var uappId = orderInfo.uapp_id;
      var channelOrderNo = orderInfo.channelOrderNo
    }
    if (ab.ApplicationStatus == 507) {//完成账户注册
      if(uappId == '18'){
        if (deliveryContent.status != "USER_CONFIRMED") {
          return system.getResultFail(-507, "交付流程错误，用户确认递交⽂件后才能执行此操作");
        }
      }
      deliveryContent['ApplicationStatus'] = 507;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "REGISTRATION", statusName: this.ncSolutionStatus.REGISTRATION, updated_at: new Date()
      });
      deliveryContent.status = "REGISTRATION";
      deliveryContent.statusName = this.ncSolutionStatus.REGISTRATION;
    }
    if (ab.ApplicationStatus == 508) {//"服务商完成提交资料到⼯信部
      if (deliveryContent.status != "REGISTRATION") {
        return system.getResultFail(-508, "交付流程错误，请先完成账户注册");
      }
      deliveryContent['ApplicationStatus'] = 508;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "SUBMITTED", statusName: this.ncSolutionStatus.SUBMITTED, updated_at: new Date()
      });
      deliveryContent.status = "SUBMITTED";
      deliveryContent.statusName = this.ncSolutionStatus.SUBMITTED;
    }
    if (ab.ApplicationStatus == 509) {//⼯商部已受理
      if (deliveryContent.status != "SUBMITTED") {
        return system.getResultFail(-509, "交付流程错误，请先完成资料递交");
      }
      deliveryContent['ApplicationStatus'] = 509;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "ACCEPTED", statusName: this.ncSolutionStatus.ACCEPTED, updated_at: new Date()
      });
      deliveryContent.status = "ACCEPTED";
      deliveryContent.statusName = this.ncSolutionStatus.ACCEPTED;
    }
    if (ab.ApplicationStatus == 510) {//⼯商部不予受理
      if (deliveryContent.status != "SUBMITTED") {
        return system.getResultFail(-510, "交付流程错误，请先完成资料递交");
      }
      deliveryContent['ApplicationStatus'] = 510;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "NOT_ACCEPTED", statusName: this.ncSolutionStatus.NOT_ACCEPTED, updated_at: new Date()
      });
      deliveryContent.status = "NOT_ACCEPTED";
      needsolutioninfo.status = "ywc";
      deliveryContent.statusName = this.ncSolutionStatus.NOT_ACCEPTED;
    }
    if (ab.ApplicationStatus == 511) {//⼯商部通过
      if (deliveryContent.status != "ACCEPTED") {
        return system.getResultFail(-511, "交付流程错误，⼯信部已受理后才能执行此操作");
      }
      deliveryContent['ApplicationStatus'] = 511;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "APPROVED", statusName: this.ncSolutionStatus.APPROVED, updated_at: new Date()
      });
      needsolutioninfo.status = "ywc";
      deliveryContent.status = "APPROVED";
      deliveryContent.statusName = this.ncSolutionStatus.APPROVED;
    }
    if (ab.ApplicationStatus == 512) {//⼯信部未通过
      if (deliveryContent.status != "ACCEPTED") {
        return system.getResultFail(-512, "交付流程错误，⼯信部已受理后才能执行此操作");
      }
      deliveryContent['ApplicationStatus'] = 512;
      solutionFlowList.push({
        file: ab.OfficialFileURL || "",
        status: "NOT_APPROVED", statusName: this.ncSolutionStatus.NOT_APPROVED, updated_at: new Date()
      });
      deliveryContent.status = "NOT_APPROVED";
      needsolutioninfo.status = "ywc";
      deliveryContent.statusName = this.ncSolutionStatus.NOT_APPROVED;
    }
    deliveryContent.solutionFlowList = solutionFlowList;
    var applicationStatusList = deliveryContent.applicationStatusList || [];
    var statusObj = {
      "OfficialFileURL": ab.OfficialFileURL || "",
      "ApplicationStatus": ab.ApplicationStatus,
      "ApplicationStatusName": this.ncSolutionStatus[ab.ApplicationStatus],
      "created_at": new Date()
    };
    applicationStatusList.push(statusObj);
    deliveryContent.applicationStatusList = applicationStatusList;
    deliveryContent["applicationStatus"] = ab.applicationStatus;
    deliveryContent = JSON.stringify(deliveryContent);
    let orderdeliveryData = {
      sourceOrderNo : ab.orderNo,
      deliveryContent : deliveryContent,
    }
    if(!orderdeliveryInfo[0]){
      let sql = "INSERT INTO `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUES (:sourceOrderNo,:deliveryContent)";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql, orderdeliveryData);
    }else{
      let sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + deliveryContent + "' where sourceOrderNo='" + ab.orderNo + "'";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql);
    }
    let orderdeliveryQuery = "SELECT * from `c_order_delivery` where sourceOrderNo='" + ab.orderNo + "'";
    let QueryDatas = {
      sourceOrderNo:ab.orderNo
    }
    orderdelivery = await this.orderdeliveryDao.customQuery(orderdeliveryQuery,QueryDatas)
    console.log('orderdelivery++orderdelivery++++++',orderdelivery)
    if(orderdelivery){
      orderdelivery = orderdelivery[0]
      orderdelivery["bizId"] = ab.bizId;
      orderdelivery['uapp_id'] = uappId;
      orderdelivery['channelOrderNo'] = channelOrderNo;
    }
    console.log('orderdelivery++',orderdelivery)
    return system.getResultSuccess(orderdelivery);
  }

  //接收方案编号(方案推送至yun后,接收保存方案信息)
  async ncReceiveProgrammeNo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.solutionBizId) {
      return system.getResultFail(-101, "渠道方案业务编号不能为空");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-102, "方案业务编号不能为空");
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { solutionNo: ab.solutionNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    await this.needsolutionDao.model.update({ channelSolutionNo: ab.solutionBizId }, { where: { id: ns.id } });//修改方案信息
    return system.getResultSuccess();
  }

  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }



  //根据需求关闭NC方案（关闭需求后调用）
  async ncClosePlan(pobj) {
    console.log("ncClosePlan+++",pobj)
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.needNo) {
      return system.getResultFail(-101, "需求编号不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      attributes: ["id", "status", "statusName", "needNo", "uapp_id"],//2020-10-29 laolan xinzeng uapp_id
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { needNo: needinfo.needNo, isInvalid: 0 }, raw: true
    });
    // var newFlowStatus = [];
    if (ns && ns.id) {
      if (ns.status == "ywc") {
        return system.getResultFail(-103, "方案状态错误，不能废弃已完成方案");
      }
      var flowStatus = ns.solutionContent && ns.solutionContent.status ? ns.solutionContent.status : "";
      if (flowStatus && ["NOT_ACCEPTED","CLOSE"].indexOf(flowStatus) < 0) {
        return system.getResultFail(-104, "⽅案状态为关闭或不予受理才可关闭需求");
      }
    }
    var self = this;
    return await self.needsolutionDao.db.transaction(async function (t) {
      var needObj = {
        id: needinfo.id, status: "ygb", notes: ab.note
      };
      await self.needinfoDao.update(needObj, t);//关闭需求
      if (ns && ns.id) {
        await self.needsolutionDao.model.update({ status: "yzf", isInvalid: 1 }, { where: { id: ns.id }, transaction: t });//方案废弃
        return system.getResultSuccess(ns.orderNo);
      }
      //2020-10-29 laolan
      var uappId = {};
      uappId['uapp_id'] = needinfo.uapp_id;
      ns = ns ? ns : {};
      ns = Object.assign(ns,uappId)
      console.log('guanbi ns +++',ns)
      return system.getResultSuccess(ns);
      // return system.getResultSuccess();
    })

  }
 
  //交付商关闭交付单
  async ncCloseOrderDelivery(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    } else {
      ab.note = ab.note;
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });

    if (!ns || !ns.id) {
      return system.getResultFail(-301, "未知方案");
    }
    ab["bizId"] = ns.channelSolutionNo;
    pobj.actionBody = ab;
    return this.ncAbolishProgramme(pobj);
  }
  //服务商作废方案-- ncAbolishProgramme
  async ncAbolishProgramme(pobj) {
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.bizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.note) {
      return system.getResultFail(-106, "关闭理由不能为空");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.bizId, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-300, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-400, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-401, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    // if (ns.status != "dqr") {
    //   return system.getResultFail(-301, "方案状态错误，只能废弃待确认方案");
    // }
    var solutionContent = ns.solutionContent;
    if (!solutionContent.status || ["MATERIAL_UNCONFIRM", "REGISTRATION", "SUBMITTED"].indexOf(solutionContent.status) < 0) {
      return system.getResultFail(-302, "方案流程状态错误，不能执行此操作");
    }
    solutionContent.serviceProviderNote = ab.note;
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "CLOSE", statusName: this.ncSolutionStatus.CLOSE, updated_at: new Date()
    });
    solutionContent.status = "CLOSE";
    solutionContent.statusName = this.ncSolutionStatus.CLOSE;
    solutionContent = JSON.stringify(solutionContent);
    await this.needsolutionDao.update({ id: ns.id, status: "yzf", isInvalid: 1, solutionContent: solutionContent });//方案废弃
    //获取方案信息
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    return system.getResultSuccess(new_ns);
  }
}
module.exports = NcService;
