var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.storderSve = system.getObject("service.trade.storderSve");
        this.storderitemSve = system.getObject("service.trade.storderitemSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        var result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);    
        } catch (error) {
            console.log(error);
        }
        
        return result;
    }

    async handleRequest(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {

            // 图片验证码
            case "test":
                opResult = await this.storderSve.test(action_body);
                break;
            case "orderPage":
                opResult = await this.storderSve.pageByCondition(action_body);
                break;
            case "orderAdd":
                opResult = await this.storderSve.saveOrder(action_body);
                break;
            case "orderInfo":
                opResult = await this.storderSve.info(action_body);
                break;
            case "orderPay":
                opResult = await this.storderSve.pay(action_body);
                break;
            case "orderAudit1":
                opResult = await this.storderSve.audit1(action_body);
                break;
            case "orderAudit2":
                opResult = await this.storderSve.audit2(action_body);
                break;
            case "orderTrade":
                opResult = await this.storderSve.trade(action_body);
                break;
                break;
            case "itemPage":
                opResult = await this.storderitemSve.pageByCondition(action_body);
                break;
            case "itemTradeOfflineCB":
                opResult = await this.storderitemSve.tradeOfflineCB(action_body);
                break;
            case "itemByIds":
                opResult = await this.storderitemSve.byIds(action_body);
                break;
            case "itemByInvoiceId":
                opResult = await this.storderitemSve.bySaasInvoiceId(action_body);
                break;
            case "updateItemInvoice":
                opResult = await this.storderitemSve.updateInvoice(action_body);
                break;
            case "cancelItemInvoice":
                opResult = await this.storderitemSve.cancelInvoice(action_body);
                break;


            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre><pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;