const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("storder", {
    saas_merchant_id: DataTypes.STRING,      //  saas商户id
    out_trade_no: DataTypes.STRING,          //  商户订单号
    service_rate: DataTypes.INTEGER,         //  商户订单号
    amt: DataTypes.BIGINT,                   //  请求打款金额
    actual_amt: DataTypes.BIGINT,            //  实发金额
    deduct_amt: DataTypes.BIGINT,            //  扣款金额
    service_tax: DataTypes.BIGINT,           //  服务费
    item_count: DataTypes.INTEGER,           //  打款笔数
    order_type: DataTypes.STRING,            //  订单类型 00未设置 10平台交易 20商户交易
    acc_type: DataTypes.STRING,              //  打款通道 00 银行 01 支付宝 02 微信
    trade_mode: DataTypes.STRING,            //  打款模式 00 未选择 01 系统打款 02 手工打款
    trade_status: DataTypes.STRING,          //  交易状态 00 成功 01 待处理 02 失败 03 部分成功
    check_status: DataTypes.STRING,          //  审核状态 00 一审 01 一审失败  02 二审 03 二审失败 04 二审通过
    check1_remark: DataTypes.STRING,         //  一审备注
    check2_remark: DataTypes.STRING,         //  二审备注
    pay_voucher: DataTypes.STRING,           //  付款凭证 暂用此字段，以后创建交易付款
    pay_bank_account: DataTypes.STRING,      //  订单付款账户名称
    pay_bank_name: DataTypes.STRING,         //  订单付款开户银行名称
    pay_bank_no: DataTypes.STRING,           //  订单付款银行账户

    order_file: DataTypes.STRING,            //  打款文件地址
    saas_id: DataTypes.STRING,               //  saas_id
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'st_order',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ],
  });
}