const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("storderitem", {

    trade_no: DataTypes.STRING,                    // 打款编号
    saas_merchant_id: DataTypes.STRING,            // saas商户id
    order_id: DataTypes.STRING,                    // 订单id
    order_type: DataTypes.STRING,                  // 订单类型 00未设置 10平台交易 20商户交易
    out_trade_no: DataTypes.STRING,                // 商户订单号
    acc_name: DataTypes.STRING,                    // 收款户名
    acc_no: DataTypes.STRING,                      // 收款账号
    credit_code: DataTypes.STRING,                 // 统一社会信用代码
    open_bank: DataTypes.STRING,                   // 开户银行全称
    amt: DataTypes.BIGINT,                         // 请求打款金额
    actual_amt: DataTypes.BIGINT,                  // 实发金额
    deduct_amt: DataTypes.BIGINT,                  // 扣款金额
    service_tax: DataTypes.BIGINT,                 // 服务费
    trade_status: DataTypes.STRING,                // 交易状态 00 成功 01 待处理 02 失败
    trade_time: DataTypes.DATE,                    // 交易时间
    trade_desc: DataTypes.STRING,                  // 交易描述
    trade_receipt: DataTypes.STRING,               // 回执
    remark: DataTypes.STRING,                      // 上传备注
    saas_id: DataTypes.STRING,                     // saas id
    saas_invoice_id: DataTypes.STRING,             // 发票id
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'st_order_item',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}