const system = require("../system");

class Dictionary {
  constructor() {
    // 交易字典
    this.ORDER = {
      order_type: {"00": "未设置", "10": "平台交易", "20": "商户交易"},
      acc_type: {"00": "银行", "01": "支付宝", "02": "微信"},
      trade_mode: {"00": "未设置", "01": "系统打款", "02": "手工打款"},
      trade_status: {"00": "成功", "01": "待处理", "02": "失败", "03": "部分成功"},
      check_status: {"00": "待处理", "01": "一审", "02": "一审失败", "03": "二审", "04": "二审失败", "05": "审核通过"},
    };
    this.ORDER_ITEM = {
      trade_status: {"00": "成功", "01": "待处理", "02": "失败"}
    }
  }

  getDict(module, field) {
    return (this[(module || "")] || {})[field] || {};
  }

  setRowName(module, row, fields, concat) {
    if(!module || !row || !fields || fields.length == 0) {
      return;
    }
    concat = concat || "_";
    for (let field of fields) {
      row[field + concat + "name"] = this.getDict(module, field)[row[field] || ""] || "";
    }
  }

  setRowsName(module, rows, fields, concat) {
    if(!module || !rows || !fields || fields.length == 0) {
      return;
    }
    for(let row of rows) {
      this.setRowName(module, row, fields, concat)
    }
  }
}

module.exports = Dictionary;
