var System = require("../../system");
const logCtl = System.getObject("web.oplogCtl");
class TmSub {
  constructor() {
    this.cacheManager = System.getObject("db.cacheManager");
    this.trademarkSve = System.getObject("service.trademarkSve");
    this.companySve = System.getObject("service.companySve");
    this.companyauthcodeSve = System.getObject("service.companyauthcodeSve");
  }
  async verifyData(obj) {
    if (obj.appKey != "95f167212a8146daac99feddffa6a9sy") {
      return { code: -100, message: "appKey参数有误", data: [] };
    }
    var code = obj.code || "";
    if (!code) {
      return { code: -101, message: "站点授权码信息不能为空", data: [] };
    }
    var mac_addr = obj.mac_addr || "";
    if (!mac_addr) {
      return { code: -102, message: "mac_addr信息不能为空", data: [] };
    }
    let codeListCache = await this.cacheManager["AuthCodeListCache"].getListByCache();
    if (!codeListCache || codeListCache == "undefined") {
      return { code: -103, message: "获取授权码缓存数据为空" };
    }
    let codeList = JSON.parse(codeListCache);
    if (!codeList || codeList.length == 0) {
      return { code: -104, message: "转换授权码缓存数据查询有误" };
    }
    var newList = codeList.filter(item => item.code == obj.code);
    if (newList == null || newList.length == 0 || !newList[0].company) {
      return { code: -105, message: "未找到站点授权码信息" };
    }
    if (newList[0].macAddr && newList[0].macAddr != mac_addr) {
      return { code: -106, message: "站点授权码只能授权在一台电脑上进行提报，要想换电脑请联系平台人员" };
    }
    if (!newList[0].macAddr) {
      //进行macaddr更新
      this.companyauthcodeSve.putMacAddrByCode(code, mac_addr);
    }
    return { code: 1, message: "success", code_item: newList[0], code_list: codeList };
  }
  async autosub(obj) {//提报数据
    try {
      var verifyResult = await this.verifyData(obj);
      if (verifyResult.code != 1) {
        return verifyResult;
      }
      var tmpResult = await this.trademarkSve.getAutoSubList(verifyResult.code_list, verifyResult.code_item);
      return tmpResult;
    } catch (e) {
      // console.log(e.stack, "error------------");
      //日志记录
      logCtl.error({
        optitle: "提报数据异常",
        op: "base/api/impl/tmsub/autosub",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "autosub异常", data: [] };
    }
  }
  //机器人提报更新提报错误--移出更新缓存中的数据--暂时不用此方法
  async updateErrorCount(obj) {
    try {
      var verifyResult = await this.verifyData(obj);
      if (verifyResult.code != 1) {
        return verifyResult;
      }
      //提报号
      var proxyCode = obj.proxyCode || "";
      if (proxyCode == "") {
        return { code: -1, message: "proxyCode不能为空", data: null };
      }
      //错误次数
      var errorCount = obj.errorCount || 1;
      var tmpResult = await this.trademarkSve.setUpdateErrorCount(proxyCode, errorCount, obj.code);
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "机器人提报更新提报错误异常",
        op: "base/api/impl/tmsub/updateErrorCount",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "updateErrorCount异常", data: null };
    }
  }
  //机器人提报更新商标信息
  async putCacheData(obj) {
    try {
      var verifyResult = await this.verifyData(obj);
      if (verifyResult.code != 1) {
        return verifyResult;
      }
      //提报号
      var proxyCode = obj.proxyCode || "";
      if (proxyCode == "") {
        return { code: -1, message: "proxyCode不能为空", data: null };
      }
      var tmpResult = await this.trademarkSve.updateTmCache(proxyCode, obj.code);
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "机器人提报更新商标缓存异常",
        op: "base/api/impl/tmsub/putCacheData",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "putCacheData异常", data: null };
    }
  }
  //机器人提报更新商标状态
  async updateState(obj) {
    try {
      var verifyResult = await this.verifyData(obj);
      if (verifyResult.code != 1) {
        return verifyResult;
      }
      //提报号
      var proxyCode = obj.proxyCode || "";
      if (proxyCode == "") {
        return { code: -1, message: "proxyCode不能为空", data: null };
      }
      var errorCount = obj.errorCount == null ? 0 : obj.errorCount;
      //商标状态枚举,传递枚举值
      var stateCode = obj.stateCode || "";
      if (stateCode == "") {
        return { code: -1, message: "stateCode不能为空", data: null };
      }
      var tmpResult = await this.trademarkSve.setUpdateState(proxyCode, errorCount, stateCode, obj.code, obj.errorMsg);
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "机器人提报更新商标状态异常",
        op: "base/api/impl/tmsub/updateState",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "updateState异常", data: null };
    }
  }
  //更新商标code和状态
  async updateTradeMarkCode(obj) {
    try {
      var verifyResult = await this.verifyData(obj);
      if (verifyResult.code != 1) {
        return verifyResult;
      }
      //提报号
      var proxyCode = obj.proxyCode || "";
      if (!proxyCode) {
        return { code: -1, message: "proxyCode不能为空", data: null };
      }
      //商标号
      var regCode = obj.regCode || "";
      if (!regCode) {
        return { code: -1, message: "code不能为空", data: null };
      }
      //商标状态枚举,传递枚举值
      var stateCode = obj.stateCode || "";
      if (!stateCode) {
        return { code: -1, message: "stateCode不能为空", data: null };
      }
      var tmpResult = await this.trademarkSve.setUpdateTradeMarkCode(proxyCode, regCode, stateCode);
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "更新商标code和状态异常",
        op: "base/api/impl/tmsub/updateTradeMarkCode",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "updateTradeMarkCode异常", data: null };
    }
  }
}
module.exports = TmSub;
