const system = require("../system");
const settings = require("../../config/settings");
class CtlBase {
  constructor(sname) {
    this.serviceName = sname;
    this.service = system.getObject("service." + sname);
    this.cacheManager = system.getObject("db.cacheManager");
    this.md5 = require("MD5");
    this.dataprivS = system.getObject("service.dataauthSve");
  }
  notify(req, msg) {
    if (req.session) {
      req.session.bizmsg = msg;
    }
  }
  //按照单据号查询出单据
  async findByCode(queryobj, qobj, req) {
    var rd = await this.service.findOne({ code: qobj.code, company_id: req.companyid });
    if (!rd) {
      var rd = await this.service.findOne({ id: qobj.code, company_id: req.companyid });
    }
    return system.getResult2(rd, null);
  }
  async findOne(queryobj, qobj) {
    var rd = await this.service.findOne(qobj);
    return system.getResult2(rd, null);
  }
  async findAndCountAll(queryobj, obj, req) {
    obj.codepath = req.codepath;
    if (req.session.user) {
      obj.uid = req.session.user.id;
    }
    if (req.codepath.indexOf("pmg") < 0 && req.companyid && req.companyid != "" && obj.search) {
      obj.search.company_id = req.companyid;
    }
    var apps = await this.service.findAndCountAll(obj);
    return system.getResult2(apps, null);
  }
  async refQuery(queryobj, qobj, req) {
    //不是超级管理员，参照需要添加公司查询条件
    // if(req.session && req.session.user && !req.session.user.isSuper){
    //判断是否考虑数据权限
    if (qobj.datapriv && req.session && req.session.user) {
      var uid = req.session.user.id;
      var authtmp = await this.dataprivS.findOne({ user_id: uid, modelname: this.service.dao.modelName });
      if (authtmp) {
        var auths = authtmp.auths;
        var arys = auths.split(",");
        qobj.datapriv = arys;
      }
    }
    if (this.serviceName.indexOf("company") < 0 && this.serviceName.indexOf("sitetheme") < 0) {
      qobj.refwhere["company_id"] = req.companyid;
    }
    //}
    var rd = await this.service.refQuery(qobj);
    return system.getResult2(rd, null);
  }
  async bulkDelete(queryobj, ids) {
    var rd = await this.service.bulkDelete(ids);
    return system.getResult2(rd, null);
  }
  async bulkCreate(queryobj, ids) {
    var rd = await this.service.bulkCreate(ids);
    return system.getResult2(rd, null);
  }
  async delete(queryobj, qobj, req) {
    this.clearProductCache(req.company_id, req.codepath, null);
    var rd = await this.service.delete(qobj);
    return system.getResult2(rd, null);
  }
  async audit(queryobj, qobj, req) {
    var audlist = qobj.audlist;
    var notes = qobj.notes;
    var status = qobj.status;
    var userinfo = req.session.user;
    var rd = await this.service.audit(userinfo, audlist, notes, status);
    return system.getResult2({}, null);
  }
  async create(queryobj, qobj, req) {
    if (req && req.codepath) {
      qobj.codepath = req.codepath;
    }
    if (req && req.companyid && req.companyid != "") {
      qobj.company_id = req.companyid;
    }
    if (req && req.session && req.session.user) {
      var userinfo = req.session.user;
      qobj.creator = userinfo.nickName;
      qobj.createuser_id = userinfo.id;
    }
    await this.clearProductCache(qobj.company_id, qobj.codepath, qobj);
    var rd = await this.service.create(qobj);
    return system.getResult2(rd, null);
  }
  async update(queryobj, qobj, req) {
    if (req.codepath) {
      qobj.codepath = req.codepath;
    }
    if (req && req.companyid && req.companyid != "") {
      qobj.company_id = req.companyid;
    }
    await this.clearProductCache(qobj.company_id, qobj.codepath, qobj);
    qobj.updator = qobj.nickName;
    qobj.updateuser_id = qobj.id;
    var rd = await this.service.update(qobj);
    return system.getResult2(rd, null);
  }

  async clearProductCache(company_id, code_path, qobj) {//清理首页展示的产品缓存
    if (!code_path || !company_id) {
      return;
    }
    if (code_path.indexOf("productmag/producttype") >= 0 || code_path.indexOf("productmag/productcrud") >= 0) {
      await this.cacheManager["ProductListCache"].delCache(company_id);
      if (qobj && code_path.indexOf("productmag/producttype") >= 0) {
        var count = await this.service.findCount({ where: { company_id: company_id, pid: 0, isPubed: 1 } });
        if (count > 6) {
          throw new Error("目前只支持6个启用的大类");
        }
        if (!qobj.pid) {
          if (!qobj.oneIconUrl) {
            throw new Error("添加的是产品大类，必须选择产品大类图标");
          }
        }
      }
    }
  }

  static getServiceName(ClassObj) {

    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Ctl")).toLowerCase() + "Sve";
  }
  async initNewInstance(queryobj, req) {
    return system.getResult2({}, null);
  }
  async findById(oid) {
    var rd = await this.service.findById(oid);
    return system.getResult2(rd, null);
  }
  encryptPasswd(passwd) {
    if (!passwd) {
      throw new Error("请输入密码");
    }
    var md5 = this.md5(passwd + "_" + settings.salt);
    return md5.toString().toLowerCase();
  }
  async doExecute(methodname, params) {
    var result = await this[methodname](params);
    return system.getResult2(result, null);
  }
}
module.exports = CtlBase;
