var System=require("../../system")
class xzsearchCtl{
  constructor(){
    this.tradeSve=System.getObject("service.tradeSve");
    this.accountSve=System.getObject("service.accountSve");
    this.appSve=System.getObject("service.appSve");
    this.productDao=System.getObject("db.productDao");
    this.gsbSearchApi=System.getObject("api.gsbtmsearch");
  }
  convertDate(time){
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  async findAndCountAll(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var pageSize=obj.pageInfo.pageSize;
    var currentPage=obj.pageInfo.pageNo;
    var companyName=obj.search.companyName==null?"":obj.search.companyName;
    var data={
      appKey:appkey,
      pageSize:pageSize,
      currentPage:currentPage,
      companyName:companyName
    };
    var that=this;
    var companys =await this.gsbSearchApi.byslSearch(data);
    if(companys.status == 0){
      result.count=companys.total;
      companys.data.forEach(function(c){
        var source={
          companyName:c.registrant_name,
          regNum:c.tm_regist_num,
          noAcceptDay:that.convertDate(c.no_accepted_day),
          noAccepyIssue:c.no_accepted_notice_issue,
          noAcceptPageNum:c.no_accepted_notice_page_num,
          file:c.link_url,
          companyAddr:c.registrant_addr,
          phone:c.tel_info,
          email:c.email_info,
        };
        sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async createTrade(qobj,pobj,req){
    var productId=pobj.productId;
    var product=await this.productDao.model.findOne({where:{id:productId}});
    var user=req.session.user;
    var tradeObj={username:user.nickName,tradeDate:new Date(),status:"settled",baoAmount:product.price,tradeType:"consume"};
    var trade=await this.tradeSve.create(user,tradeObj);
    var accountBalance = await this.accountSve.getAccountBalance(user.account_id,user.app_id);
    trade.dataValues["accountBalance"]=accountBalance;
    return trade;
  }
}
module.exports=xzsearchCtl;
