var System=require("../../system");
var settings=require("../../../config/settings");
var pinyin = require("pinyin");
var moment=require('moment');
class companyportraitCtl{
  constructor(){
    this.phoneApi=System.getObject("api.phonesearch");
    this.GsbMagicSearchApi=System.getObject("api.magicsearchapi");
    this.companyportraitSve = System.getObject("service.companyportraitSve");
    this.cacheManager=System.getObject("db.cacheManager");
    }

  async phonequery(query,obj){
    var result = {rows:[],count:""};
    var sources=[];
    var name=obj.name==null?"":obj.name;
    var number = /^\d+$/.test(name);
    if(number){
      console.log(result);
      var data ={
        phoneNum: name
      }
      var phoneresult=await this.phoneApi.phoneNumSearch(data);
      // console.log(phoneresult);
      if(phoneresult.status==0){
        if(phoneresult.data.list.length>0){
          for(var i = 0; i < phoneresult.data.list.length; i++){
            var companyname = phoneresult.data.list[i];
            // console.log(companyname);
            var ob ={
              company_name: companyname
            }
            var companyresult=await this.GsbMagicSearchApi.magiccompanyname(ob);
            // console.log(companyresult);
            if(companyresult.status==0){
              if(companyresult.data.length>0){
                for(var j =0;j<companyresult.data.length;j++){
                  var cpobj = companyresult.data[j];
                  if(cpobj.reg_number&&cpobj.reg_number!=null||cpobj.usc_code&&cpobj.usc_code!=null){
                    sources.push(cpobj);
                  }
                }
                // sources=sources.concat(companyresult.data);
              }
            }
          }
        }
      }
    }else if(name.indexOf("-")>-1){
      var data ={
        phoneNum: name
      }
      var phoneresult=await this.phoneApi.phoneNumSearch(data);
      console.log(phoneresult);
      if(phoneresult.status==0){
        if(phoneresult.data.list.length>0){
          for(var i = 0; i < phoneresult.data.list.length; i++){
            var companyname = phoneresult.data.list[i];
            console.log(companyname);
            var ob ={
              company_name: companyname
            }
            var companyresult=await this.GsbMagicSearchApi.magiccompanyname(ob);
            // console.log(companyresult);
            if(companyresult.status==0){
              if(companyresult.data.length>0){
                for(var j =0;j<companyresult.data.length;j++){
                  var cpobj = companyresult.data[j];
                  if(cpobj.reg_number&&cpobj.reg_number!=null||cpobj.usc_code&&cpobj.usc_code!=null){
                    sources.push(cpobj);
                  }
                }
              }
            }
          }
        }
      }
    }else{
      var data ={
        company_name: name
      }
      var companyresult=await this.GsbMagicSearchApi.magiccompanyname(data);
      console.log(companyresult);
      if(companyresult.status==0){
        if(companyresult.data.length>0){
          for(var i =0;i<companyresult.data.length;i++){
            var cpobj = companyresult.data[i];
            if(cpobj.reg_number&&cpobj.reg_number!=null||cpobj.usc_code&&cpobj.usc_code!=null){
              sources.push(cpobj);
            }
          }
        }
      }
    }
    result.rows=sources;
    result.count=sources.length;
    console.log(result);
    return System.getResult2(result,null);
  }

  async companynamequery(query,obj){
    var result = {wordcloud:[],tmstatuscount:[],tmyearcount:[],patenttypestatus:[],patentgrstatus:[],radarmap:[],visitcount:""};
    var sources=[];
    console.log(obj);
    var company_name=obj.company_name==null?"":obj.company_name;
    await this.cacheManager["companyportraitCache"].add();
    var visitcount = await this.cacheManager["companyportraitCache"].get();
    result.visitcount=visitcount;
    // var data ={
    //   company_name: company_name
    // }
    // var companyresult=await this.GsbMagicSearchApi.magiccompanyname(data);
    // console.log(companyresult);
    if(company_name!=null&&company_name!=""){
      var patent={
        applname:company_name
      }
      //专利查询统计
      var patentresult = await this.companyportraitSve.patentsearch(patent);

      result.patenttypestatus=patentresult.typestatus;//专利类型
      result.patentgrstatus=patentresult.grstatus;    //专利授权趋势
      //商标查询统计
      var tmresult = await this.companyportraitSve.tminfosearch(company_name);
      // console.log("---------------------------------------------------");
      // console.log(tmresult);
      if(tmresult.status==1){
        result.tmyearcount = tmresult.yearcount; //商标申请年份
        result.tmstatuscount = tmresult.statuscount;//商标申请状态
      }
      // console.log(tmresult);
      //词云
      var patentkeyword =[];
      if(patentresult.keyword.length>17){
        for(var i=0;i<16;i++){
          patentkeyword.push(patentresult.keyword[i]);
        } //专利词云
      }else{
        patentkeyword=patentresult.keyword;
      }
      if(patentkeyword.length>0){
        var company_cate_1 = obj.company_cate_1==null?"":obj.company_cate_1;
        if(company_cate_1!=null&&company_cate_1!=""){
          patentkeyword.push({name:company_cate_1,value:patentresult.keyword[0].value+22});
        }
        var company_cate_2 = obj.company_cate_2==null?"":obj.company_cate_2;
        if(company_cate_2!=null&&company_cate_2!=""){
          patentkeyword.push({name:company_cate_2,value:patentresult.keyword[0].value+12});
        }
        var company_cate_3 = obj.company_cate_3==null?"":obj.company_cate_3;
        if(company_cate_3!=null&&company_cate_3!=""){
          patentkeyword.push({name:company_cate_3,value:patentresult.keyword[0].value+6});
        }
        var company_city = obj.company_city==null?"":obj.company_city;
        if(company_city!=null&&company_city!=""){
          patentkeyword.push({name:company_city,value:patentresult.keyword[0].value+19});
        }
        var company_province = obj.company_province==null?"":obj.company_province;
        if(company_province!=null&&company_province!=""){
          patentkeyword.push({name:company_province,value:patentresult.keyword[0].value+16});
        }
        var companyname = obj.company_name==null?"":obj.company_name;
        if(companyname!=null&&companyname!=""){
          patentkeyword.push({name:companyname,value:patentresult.keyword[0].value+3});
        }
      }else{
        var company_cate_1 = obj.company_cate_1==null?"":obj.company_cate_1;
        if(company_cate_1!=null&&company_cate_1!=""){
          patentkeyword.push({name:company_cate_1,value:220+22});
        }
        var company_cate_2 = obj.company_cate_2==null?"":obj.company_cate_2;
        if(company_cate_2!=null&&company_cate_2!=""){
          patentkeyword.push({name:company_cate_2,value:160+12});
        }
        var company_cate_3 = obj.company_cate_3==null?"":obj.company_cate_3;
        if(company_cate_3!=null&&company_cate_3!=""){
          patentkeyword.push({name:company_cate_3,value:140+6});
        }
        var company_city = obj.company_city==null?"":obj.company_city;
        if(company_city!=null&&company_city!=""){
          patentkeyword.push({name:company_city,value:200+19});
        }
        var company_province = obj.company_province==null?"":obj.company_province;
        if(company_province!=null&&company_province!=""){
          patentkeyword.push({name:company_province,value:180+16});
        }
        var companyname = obj.company_name==null?"":obj.company_name;
        if(companyname!=null&&companyname!=""){
          patentkeyword.push({name:companyname,value:120});
        }
      }
      result.wordcloud=patentkeyword;
    }

    //雷达图
    var money = 0;
    var reg_capital = obj.reg_capital==null?"":obj.reg_capital;
    //人力资源
    var people = 0;
    if(reg_capital!=null&&reg_capital!=""){
      var reg = parseInt(reg_capital);
      if(reg>=10000){
        money=Math.floor(Math.random()*10+85);
        people=Math.floor(Math.random()*20+75);
      }
      if(reg>=5000&&reg<10000){
        money=Math.floor(Math.random()*10+75);
        people=Math.floor(Math.random()*20+65);
      }
      if(reg>=1000&&reg<5000){
        money=Math.floor(Math.random()*20+60);
        people=Math.floor(Math.random()*20+50);
      }
      if(reg>=500&&reg<1000){
        money=Math.floor(Math.random()*20+55);
        people=Math.floor(Math.random()*20+30);
      }
      if(reg>=100&&reg<500){
        money=Math.floor(Math.random()*20+40);
        people=Math.floor(Math.random()*10+20);
      }
      if(reg<100){
        money=Math.floor(Math.random()*30+10);
        people=Math.floor(Math.random()*30+10);
      }
    }else{
      money=Math.floor(Math.random()*30+10);
      people=Math.floor(Math.random()*30+10);
    }
    //企业信用
    var companycredit = 0;
    var reg_status = obj.reg_status==null?"":obj.reg_status;
    if(reg_status!=null&&reg_status!=""){
      if(reg_status=="存续"){
        companycredit=Math.floor(Math.random()*16+80);
      }
      if(reg_status=="在业"){
        companycredit=Math.floor(Math.random()*15+70);
      }
      if(reg_status=="其它" || reg_status=="迁出" || reg_status=="迁入"){
        companycredit=Math.floor(Math.random()*20+45);
      }
      if(reg_status=="注销" || reg_status=="吊销" ||reg_status=="停业" ||reg_status=="清算" ){
        companycredit=Math.floor(Math.random()*30+10);
      }
    }else{
      companycredit=Math.floor(Math.random()*30+10);
    }
    //影响力
    var influence = 0;
    var establish_time = obj.establish_time==null?"":obj.establish_time;
    if(establish_time!=null&&establish_time!=""){
      var nowdate = new Date();
      var nowyear = nowdate.getFullYear();
      var establish_year = moment(establish_time).format("YYYY");
      var cmp = parseInt((companycredit+money+people)/3);
      var year = nowyear - parseInt(establish_year);
      influence = cmp+year;
      if(influence>100){
        influence = Math.floor(Math.random()*15+80);
      }
    }else{
      influence=parseInt((companycredit+money+people)/3);
    }
    //知识产权
    var property = 0;
    if(result.patenttypestatus.length<=0&&result.tmstatuscount.length<=0){
      property = 0;
    }
    if(result.patenttypestatus.length<=0&&result.tmstatuscount.length>0){
      var effectivetm = result.tmstatuscount[0].value;
      var applicationtm = result.tmstatuscount[1].value;
      var othertm = result.tmstatuscount[3].value;
      var tmcount = effectivetm+applicationtm+othertm;
      if(tmcount>=5000){
        property = Math.floor(Math.random()*10+60);
      }
      if(tmcount>=1000&&tmcount<5000){
        property = Math.floor(Math.random()*10+50);
      }
      if(tmcount>=1000&&tmcount<5000){
        property = Math.floor(Math.random()*10+50);
      }
      if(tmcount>=500&&tmcount<1000){
        property = Math.floor(Math.random()*10+40);
      }
      if(tmcount>=100&&tmcount<500){
        property = Math.floor(Math.random()*10+30);
      }
      if(tmcount>=10&&tmcount<100){
        property = Math.floor(Math.random()*10+20);
      }
      if(tmcount>=1&&tmcount<10){
        property = Math.floor(Math.random()*10+10);
      }
      if(tmcount==0){
        property = 0;
      }
    }
    if(result.patenttypestatus.length>0&&result.tmstatuscount.length<=0){
      var patentcount = 0;
      for(var i=0;i<result.patenttypestatus.length;i++){
        patentcount+=result.patenttypestatus[i].value;
      }
      if(patentcount>=10000){
        property = Math.floor(Math.random()*10+86);
      }
      if(patentcount>=5000&&patentcount<10000){
        property = Math.floor(Math.random()*10+76);
      }
      if(patentcount>=1000&&patentcount<5000){
        property = Math.floor(Math.random()*10+66);
      }
      if(patentcount>=500&&patentcount<1000){
        property = Math.floor(Math.random()*10+56);
      }
      if(patentcount>=20&&patentcount<500){
        property = Math.floor(Math.random()*20+40);
      }
      if(patentcount>=1&&patentcount<20){
        property = Math.floor(Math.random()*20+30);
      }
      if(patentcount==0){
        property = 0;
      }
    }

    if(result.patenttypestatus.length>0&&result.tmstatuscount.length>0){
      var patentcount = 0;
      for(var i=0;i<result.patenttypestatus.length;i++){
        patentcount+=result.patenttypestatus[i].value;
      }
      var effectivetm = result.tmstatuscount[0].value;
      var applicationtm = result.tmstatuscount[1].value;
      var othertm = result.tmstatuscount[3].value;
      var tmcount = effectivetm+applicationtm+othertm;
      var count = parseInt(patentcount*0.8) + parseInt(tmcount*0.2);
      if(count>=10000){
        property = Math.floor(Math.random()*10+90);
      }
      if(count>=5000&&count<10000){
        property = Math.floor(Math.random()*10+85);
      }
      if(count>=1000&&count<5000){
        property = Math.floor(Math.random()*10+75);
      }
      if(count>=500&&count<1000){
        property = Math.floor(Math.random()*10+65);
      }
      if(count>=20&&count<500){
        property = Math.floor(Math.random()*20+45);
      }
      if(count>=1&&count<20){
        property = Math.floor(Math.random()*20+35);
      }
      if(count==0){
        property = 0;
      }
    }

    result.radarmap.push(money,companycredit,influence,property,people);
    console.log("hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh");
    console.log(result);
    console.log(result.radarmap);
    return System.getResult2(result,null);
  }

}
module.exports=companyportraitCtl;

// var task = new companyportraitCtl();
// var ob ={
//     name: "18809329088"
//     // name:"小米科技有限责任公司"
//     // name:"北京联大共享科技有限公司"
// };
// task.phonequery(ob).then(d=>{
//   console.log("ddddddddddddddddddddddddddddddddddddd");
//   console.log(d);
//   obj= d.data.rows[0];
//   // var obj ={
//   //     company_name: "小米科技有限责任公司"
//   // };
//   task.companynamequery(obj).then(d=>{
//     console.log("---------------------------------------");
//     console.log(d);
//     console.log(d.data.wordcloud);
//     console.log(d.data.tmstatuscount);
//     console.log(d.data.tmyearcount);
//     console.log(d.data.patenttypestatus);
//     console.log(d.data.patentgrstatus);
//   })
// })
