var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class TmOfficialCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(TmOfficialCtl));
  }
  async findAndCountAll(obj, pobj, req) {
    pobj["user"] = req.session.user;
    pobj.codepath = req.codepath;
    if (req.codepath.indexOf("pmg") < 0 && req.companyid && req.companyid != "" && pobj.search) {
      pobj.search.company_id = req.companyid;
    }
    var apps = await this.service.findAndCountAll(pobj);
    return system.getResult2(apps, null);
  }

  async putReturnReceip(queryobj, obj, req) {
    var user = req.session.user;
    var officialＴype = obj.officialＴype;
    var dataList = obj.urlList;
    if (user == null) {
      return { code: "-100", msg: "用户未登录" };
    }
    if (dataList == null || dataList.length == 0) {
      return { code: "-110", msg: "参数有误" };
    }
    if (dataList.length > 1000) {
      return { code: "-120", msg: "抱歉，一次只能选择1000个文件进行状态更新" };
    }
    return await this.service.setReturnReceip(user, dataList, officialＴype);
  }
  async batchDownload(queryobj, obj, req) {
    var user = req.session.user;
    var selectedRows = obj.selectedRows;
    if (user == null) {
      return { code: "-100", msg: "用户未登录" };
    }
    if (selectedRows == null || selectedRows.length == 0) {
      return { code: "-110", msg: "参数有误" };
    }
    if (selectedRows.length > 20) {
      return { code: "-120", msg: "抱歉，一次只能选择20个文件进行批量下载" };
    }
    try {
      return await this.service.batchDownload(user, selectedRows);
    } catch (e) {
      // console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "Ctl批量下载操作异常error",
        op: "/igirl-web/app/base/controller/impl/tmofficialCtl.js/opDownFileInfo",
        content: "异常信息error：" + e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "Ctl批量下载操作异常" }
    }
  }
  //官文列表检索
  async findAllOfficial(obj,req){
    var user = req.session.user;
    if(user){
      obj["user"]=user;
      try {
        return this.service.findAllOfficial(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "官文列表检索操作异常error",
          op: "/igirl-web/app/base/controller/impl/tmofficialCtl.js/findAllOfficial",
          content: e.stack,
          clientIp: ""
        });
        return { code: -200, msg: "操作失败" };
      }
    }else{
      return {code:-100,msg:"未知用户"};
    }
  }

  //官文邮寄申请
  async tmOfficialPostApply(pobj,obj,req){
    var user = req.session.user;
    if(user){
      obj["user"]=user;
      try {
        return this.service.tmOfficialPostApply(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "官文邮寄申请操作异常error",
          op: "/igirl-web/app/base/controller/impl/tmofficialCtl.js/tmOfficialPostApply",
          content: e.stack,
          clientIp: ""
        });
        return { code: -200, msg: "操作失败" };
      }
    }else{
      return {code:-100,msg:"未知用户"};
    }
  }

}
module.exports = TmOfficialCtl;
// var task = new TmOfficialCtl();
// task.findAllOfficial({},null).then(d=>{
//   console.log(d);
//   console.log(d.data.length);
// })

