const CacheBase = require("../cache.base");
const system = require("../../system");
class ZxPayLocker extends CacheBase {
    constructor() {
        super();
        this.prefix = "zxPayLocker:";
    }
    async init(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpushWithEx(key, "1", 1800);
    }
    async enter(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpop(key);
    }
    async release(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpushWithEx(key, "1", 1800);
    }
}
module.exports = ZxPayLocker;
