const CacheBase = require("../cache.base");
const system = require("../../system");
class ZxPayQrCodeCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "zxPayQrCode:";
    this.bytmresultDao = system.getObject("db.bytmresultDao");
  }
  async delCache(tradekey, comanyId, opType) {
    const key = this.prefix + tradekey + "_" + comanyId + "_" + opType;
    await this.redisClient.delete(key);
  }
  async setList(tradekey, comanyId, opType, values) {
    const key = this.prefix + tradekey + "_" + comanyId + "_" + opType;
    this.redisClient.setWithEx(key, values, 5400);//单位秒（此处为1个半小时）
  }
  async getListByCache(tradekey, comanyId, opType) {
    const key = this.prefix + tradekey + "_" + comanyId + "_" + opType;
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      return cachedVal;
    } else {
      return null;
    }
  }
}
module.exports = ZxPayQrCodeCache;
