const CacheBase = require("../cache.base");
const system = require("../../system");
//缓存首次登录的赠送的宝币数量
class ProductListCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "zqq_productList:";
    this.producttypeDao = system.getObject("db.producttypeDao");
    this.serviceitemDao = system.getObject("db.serviceitemDao");
  }
  async delCache(company_id) {
    const key = this.prefix + company_id;
    await this.redisClient.delete(key);
  }
  async getProductListByCache(company_id) {
    const key = this.prefix + company_id;
    var configValue = await this.redisClient.get(key);
    if (!configValue || configValue == "undefined" || true) {
      var typeList = await this.producttypeDao.model.findAll(
        {
          where: { company_id: company_id, isPubed: 1 },
          attributes: ["id", "code", "name", "iconUrl", "oneIconUrl", "oneMoblieIconUrl", "pid", "isSystem"],
          raw: true,
          order: [["orderNo", "asc"]]
        });
      if (!typeList || typeList.length == 0) {
        return "";
      }
      var productList = await this.serviceitemDao.model.findAll(
        {
          where: { company_id: company_id, isPubed: 1 },
          attributes: ["id", "code", "name", "shortDesc", "price", "mobilePic", "mobileContentImg", "mobileContentImg1", "mobileContentImg2", "mobileContentImg3", "mobileContentImg4", "mobileContentImg5", "mobileContentImg6", "mobileContentImg7", "mobileContentImg8", "producttype_id", "producttype_pid_id", "iconUrl", "serviceCharge", "publicExpense", "rateConfig", "discountsRateConfig", "isRecommend"],
          raw: true,
          order: [["sort", "asc"]]
        });
      if (!productList || productList.length == 0) {
        return "";
      }
      var pTypeList = typeList.filter(f => f.pid == 0);
      if (!pTypeList || pTypeList.length == 0) {
        return "";
      }
      var returnList = [];
      for (let index = 0; index < pTypeList.length; index++) {
        const element = pTypeList[index];
        var smallList = typeList.filter(j => j.pid == element.id);
        if (smallList && smallList.length > 0) {
          var twoList = [];
          for (let i = 0; i < smallList.length; i++) {//处理二级类
            const smallItem = smallList[i];
            if (smallItem) {
              var tmpProductList = productList.filter(k => k.producttype_id == smallItem.id);
              var tmpSmallItem = {
                producttype_id: smallItem.id,
                serviceSmallClassType: smallItem.code,
                serviceSmallClassTypeIconUrl: smallItem.iconUrl,
                serviceSmallClassTypeName: smallItem.name,
                productList: tmpProductList
              };
              if (tmpProductList.length > 0) {
                twoList.push(tmpSmallItem);
              }
            }
          }
          if (twoList.length > 0) {
            returnList.push({
              id: element.id,
              itemType: element.code,
              itemTypeName: element.name,
              oneIconUrl: element.oneIconUrl,
              oneMoblieIconUrl: element.oneMoblieIconUrl,
              smallList: twoList
            });
          }
        }
      }
      configValue = returnList;
      await this.redisClient.set(key, JSON.stringify(returnList));
    } else {
      configValue = JSON.parse(configValue);
    }
    return configValue;
  }
}
module.exports = ProductListCache;
