const CacheBase=require("../cache.base");
const system=require("../../system");
const wxFunc=require("../../service/wxsvr");
//缓存首次登录的赠送的宝币数量
class WxCache extends CacheBase{
   constructor(){
     super();
     this.prefix="wx_";
     this.accessTokenUrl="https://api.weixin.qq.com/cgi-bin/token";
     this.desc="缓存访问key,js票据";
     this.restClient=system.getObject("util.restClient");
   }
   async cacheAccessToken(appkey){
       const key=this.prefix+appkey+"_"+"accesskey";
       var configValue=await this.redisClient.get(key);
       if(!configValue || configValue=="undefined"){
         //x随便定义获取一个weixin
         var configData=wxFunc("x").getAccessConfig(appkey);
         console.log(configData);
         var akobjout=await this.restClient.execGet2(configData,this.accessTokenUrl);
         console.log(akobjout);
         var akobj=JSON.parse(akobjout.stdout);
         await this.redisClient.setWithEx(key,akobj.access_token,7000);
         return akobj.access_token;
       }else {
         console.log("cache already cache....");
       }
       return configValue;
   }
   async cacheJsConfigTicket(appkey){
       const key=this.prefix+appkey+"_"+"jsticket";
       var ticketUrl="https://api.weixin.qq.com/cgi-bin/ticket/getticket";
       var configValue=await this.redisClient.get(key);
       if(!configValue || configValue=="undefined"){
         var acck=await this.cacheAccessToken(appkey);
         var subdata={
           access_token:acck,
           type:"jsapi",
         };
         var ticketobjout=await this.restClient.execGet2(subdata,ticketUrl);
         var ticketobj=JSON.parse(ticketobjout.stdout);
         await this.redisClient.setWithEx(key,ticketobj.ticket,7000);
         return ticketobj.ticket;
       }else {
         console.log("cache already cache....");
       }
       return configValue;
   }
}
module.exports=WxCache;
// var wc=new WxCache();
// wc.cacheJsConfigTicket("wx4c91e81bbb6039cd").then(d=>{
//   console.log(d);
// });
// var configData=wx.getAccessConfig();
// wc.restClient.execGet2(configData,wc.accessTokenUrl).then(
//   d=>{
//     console.log(d.stdout);
//   }
// );
