const system = require("../../system");
const Dao = require("../dao.base");
class BusinessCompanyDao extends Dao {
  constructor() {
    super(Dao.getModelName(BusinessCompanyDao));
  }
  extraWhere(obj, where) {
    console.log(obj);
    console.log(where);
    if (obj.codepath && obj.codepath != "") {
      if (obj.codepath.indexOf("businesspool") >= 0) {//平台商机池 站点业务员访问(所有未认领商机)
        delete obj.search.company_id;
        delete where.company_id;
        where["business_status"] = 'wrl';
        where["check_mobile"] = 1;
      } else if (obj.codepath.indexOf("mybusiness") >= 0) {//我的商机 站点业务员访问
        delete obj.search.company_id;
        delete where.company_id;
        where["createuser_id"] = obj.uid;
        where[this.db.Op.or] = [
          { business_status: "yrl" }, { business_status: "bhz" }
        ];
        where["recovery_time"] = { [this.db.Op.gte]: new Date() };
      }
    }
    return where;
  }
  extraModelFilter() {
    return {
      "key": "include", "value": [
        {
          model: this.db.models.company, as: "company",
          attributes: ["id", "sitename", "onlyCode"]
        },
        {
          model: this.db.models.user, as: "createuser",
          attributes: ["id", "userName", "nickName", "headUrl", "mobile", "email", "freeBusNum", "company_id"]
        }
      ]
    };
  }
  async putItemByCustomFieldName(setFields, inArray, t) {//进行商机公司更新
    await this.updateByWhere(setFields, { where: { id: { [this.db.Op.in]: inArray } } }, t)
  }
}
module.exports = BusinessCompanyDao;
