const Sequelize = require('sequelize');
const settings = require("../../../config/settings")
const fs = require("fs")
const path = require("path");
class DbFactory {
  constructor() {
    const dbConfig = settings.database();
    this.db = new Sequelize(dbConfig.dbname,
      dbConfig.user,
      dbConfig.password,
      dbConfig.config);

    this.db.Sequelize = Sequelize;
    this.db.Op = Sequelize.Op;
    this.initModels();
    this.initRelations();
  }
  async initModels() {
    var self = this;
    var modelpath = path.normalize(path.join(__dirname, '..')) + "/models/";
    var models = fs.readdirSync(modelpath);
    models.forEach(function (m) {
      self.db.import(modelpath + m);
    });
    console.log("init models....");
  }
  async initRelations() {
    /**
      一个账户对应多个登陆用户
      一个账户对应一个commany
      一个APP对应多个登陆用户
      一个APP有多个角色
      登陆用户和角色多对多
    **/
    this.db.models.trademarktransaction.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//来源，默认1即平台
    this.db.models.trademarktransaction.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//
    this.db.models.trademarktransaction.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    this.db.models.trademarktransactionneed.belongsTo(this.db.models.company, { constraints: false, });//来源，默认1即平台
    this.db.models.trademarktransactionneed.belongsTo(this.db.models.user, { constraints: false, });
    this.db.models.trademarktransactionneed.belongsTo(this.db.models.trademarktransaction, { constraints: false, });
    this.db.models.trademarktransactionneed.belongsTo(this.db.models.user, { as: "tmowner", constraints: false, });
    /*建立商机和备注之间的关系*/
    this.db.models.buscompanynotes.belongsTo(this.db.models.businesscompany, { constraints: false, });
    // this.db.models.businesscompany.hasMany(this.db.models.buscompanynotes, { constraints: false, });
    /*建立公司和备注之间的关系*/
    this.db.models.buscompanynotes.belongsTo(this.db.models.company, { constraints: false, });
    // this.db.models.company.hasMany(this.db.models.buscompanynotes, { constraints: false, });
    /*建立用户和备注之间的关系*/
    this.db.models.buscompanynotes.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.user.hasMany(this.db.models.buscompanynotes, { constraints: false, });
    /*建立用户和角色之间的关系*/
    this.db.models.user.belongsToMany(this.db.models.role, { as: "Roles", through: 'p_userrole', constraints: false, });
    this.db.models.role.belongsToMany(this.db.models.user, { as: "Users", through: 'p_userrole', constraints: false, });
    /*建立频道和文章之间的关系*/
    this.db.models.article.belongsTo(this.db.models.newschannel, { constraints: false, });
    this.db.models.newschannel.hasMany(this.db.models.article, { constraints: false, });

    /*建立客户和联系人之间的关系*/
    this.db.models.customercontacts.belongsTo(this.db.models.customerinfo, { constraints: false, });
    this.db.models.customerinfo.hasMany(this.db.models.customercontacts, { constraints: false, });

    this.db.models.user.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.role.belongsTo(this.db.models.company, { constraints: false, });

    this.db.models.loopplay.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.article.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.newschannel.belongsTo(this.db.models.company, { constraints: false, });

    this.db.models.serviceitem.belongsTo(this.db.models.producttype, { as: 'producttype_pid', constraints: false, });
    this.db.models.serviceitem.belongsTo(this.db.models.producttype, { constraints: false, });
    this.db.models.auth.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.producttype.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.footerinfo.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.serviceitem.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.need.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.moneyaccount.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.order.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.orderflow.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.customerinfo.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.icpcustomerinfo.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.customercontacts.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.receiptvoucher.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.expensevoucher.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.moneyjourney.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.moneyjourney.belongsTo(this.db.models.moneyaccount, { constraints: false, });
    this.db.models.trademark.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.tmstuff.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.tmofficial.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.invoiceapply.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.useraddr.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.businesscompany.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.workcrsubmit.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.softwarecrsubmit.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.copyrightauthor.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.copyrightuserinfo.belongsTo(this.db.models.company, { constraints: false, });


    this.db.models.company.hasMany(this.db.models.moneyaccount, { constraints: false, });
    this.db.models.company.belongsTo(this.db.models.sitetheme, { constraints: false, });

    this.db.models.loopplay.belongsTo(this.db.models.sitetheme, { constraints: false, });
    //公司提报授权码
    this.db.models.companyauthcode.belongsTo(this.db.models.company, { constraints: false, });

    //数据权限
    this.db.models.dataauth.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.dataauth.belongsTo(this.db.models.user, { constraints: false, });

    //项目管理
    this.db.models.pmproduct.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.pmproject.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.pmfollow.belongsTo(this.db.models.company, { constraints: false, });
    this.db.models.pmquestion.belongsTo(this.db.models.company, { constraints: false, });

    this.db.models.pmproject.belongsTo(this.db.models.pmproduct, { constraints: false, });
    this.db.models.pmfollow.belongsTo(this.db.models.pmproject, { constraints: false, });
    this.db.models.pmquestion.belongsTo(this.db.models.pmproject, { constraints: false, });

    this.db.models.pmfollow.belongsTo(this.db.models.user, { as: 'follower', constraints: false, });
    this.db.models.pmquestion.belongsTo(this.db.models.user, { as: 'subber', constraints: false, });
    this.db.models.pmquestion.belongsTo(this.db.models.user, { as: 'exector', constraints: false, });

    //订单流程表引用用户信息
    this.db.models.orderflow.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });

    //商标材料引用用户表
    this.db.models.tmstuff.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.tmstuff.belongsTo(this.db.models.order, { constraints: false, });XXXXXXXXXXX删除引用
    //订单表引用用户信息
    this.db.models.order.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.order.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //订单
    this.db.models.order.belongsTo(this.db.models.expensevoucher, { as: 'pfsettleexpense', constraints: false, });
    this.db.models.order.belongsTo(this.db.models.customerinfo, { constraints: false, });
    this.db.models.order.belongsTo(this.db.models.icpcustomerinfo, { constraints: false, });
    this.db.models.order.belongsTo(this.db.models.receiptvoucher, { constraints: false, });
    // this.db.models.order.hasOne(this.db.models.invoiceapply, { constraints: false, });XXXXXXXXXXX删除引用
    // this.db.models.order.hasMany(this.db.models.tmstuff, { constraints: false, });XXXXXXXXXXX删除引用
    this.db.models.order.hasMany(this.db.models.trademark, { constraints: false, });
    this.db.models.order.belongsTo(this.db.models.invoiceapply, { constraints: false, });//发票信息


    // 客户联系人引用客户信息
    this.db.models.customercontacts.belongsTo(this.db.models.customerinfo, { constraints: false, });

    //发票申请引用用户表
    this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });
    this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //发票申请引用订单表
    this.db.models.invoiceapply.belongsTo(this.db.models.order, { constraints: false, });


    //收款单引用帐户信息
    this.db.models.receiptvoucher.belongsTo(this.db.models.moneyaccount, { constraints: false, });
    this.db.models.receiptvoucher.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//创建收款单的公司
    //收款单表引用用户信息
    this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'payuser', constraints: false, });
    this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });

    //费用表引用帐户信息
    this.db.models.expensevoucher.belongsTo(this.db.models.moneyaccount, { constraints: false, });
    //费用表引用用户信息
    this.db.models.expensevoucher.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.expensevoucher.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    this.db.models.expensevoucher.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });

    //订单流程表引用用户信息
    this.db.models.moneyjourney.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.moneyjourney.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//创建收款单的公司

    //商标表引用用户信息
    this.db.models.trademark.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.trademark.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    this.db.models.trademark.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });
    this.db.models.trademark.belongsTo(this.db.models.expensevoucher, { as: 'publicexpense', constraints: false, });
    this.db.models.trademark.belongsTo(this.db.models.order, { constraints: false, });
    this.db.models.trademark.hasMany(this.db.models.tmofficial, { constraints: false, });

    //商标官文引用用户表
    this.db.models.tmofficial.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    //商标官文引用商标表
    this.db.models.tmofficial.belongsTo(this.db.models.trademark, { constraints: false, });

    //用户地址引用用户表
    this.db.models.useraddr.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });

    //商机公司表
    this.db.models.businesscompany.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });
    this.db.models.businesscompany.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.businesscompany.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    //商机信息
    this.db.models.businessinfo.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//认领人公司
    this.db.models.businessinfo.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//认领人
    this.db.models.businessinfo.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //站点主题
    this.db.models.sitetheme.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.sitetheme.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    //公司参数
    this.db.models.companypayparam.belongsTo(this.db.models.company, { constraints: false, });

    this.db.models.transactionspecialperformance.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//来源，默认1即平台
    this.db.models.transactionspecialperformance.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//
    this.db.models.transactionspecialperformance.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    this.db.models.wxapp.belongsTo(this.db.models.company, { as: 'company', constraints: false, });
    // this.db.models.wxuser.belongsTo(this.db.models.company, { as: 'company', constraints: false, });  

    //作品著作权表引用用户信息
    this.db.models.workcrsubmit.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.workcrsubmit.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //软件著作权表引用用户信息
    this.db.models.softwarecrsubmit.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.softwarecrsubmit.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    // 版权作者表引用用户信息
    this.db.models.copyrightuserinfo.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.copyrightuserinfo.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    // 版权代理机构信息表引用用户信息
    this.db.models.copyrightauthor.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.copyrightauthor.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //商标业务操作表
    this.db.models.ordertmproduct.belongsTo(this.db.models.customerinfo, { constraints: false, });//申请人表（企业或个人）
    this.db.models.ordertmproduct.belongsTo(this.db.models.company, { constraints: false, });//公司
    this.db.models.ordertmproduct.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.ordertmproduct.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    //版权业务操作表
    this.db.models.ordercrproduct.belongsTo(this.db.models.company, { constraints: false, });//公司
    this.db.models.ordercrproduct.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    this.db.models.ordercrproduct.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    /*建立公司和网页链接之间的关系*/
    this.db.models.company.belongsToMany(this.db.models.weblink, { as: "weblinks", through: 'p_companyweblink', constraints: false, });
    this.db.models.weblink.belongsToMany(this.db.models.company, { as: "companys", through: 'p_companyweblink', constraints: false, });
    
  }
  //async getCon(){,用于使用替换table模型内字段数据使用
  getCon() {
    var that = this;
    // await this.db.authenticate().then(()=>{
    //   console.log('Connection has been established successfully.');
    // }).catch(err => {
    //   console.error('Unable to connect to the database:', err);
    //   throw err;
    // });
    //同步模型
    if (settings.env == "dev") {
    }
    return this.db;
  }
}
module.exports = DbFactory;