const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
const uuidv4 = require('uuid/v4');
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("company", Object.assign({
    sitename: DataTypes.STRING,//站点名称
    domainname: DataTypes.STRING,//域名
    subdomainname: DataTypes.STRING,//子域名名称
    contact: DataTypes.STRING,//联系人
    contactmobile: DataTypes.STRING,//联系人电话
    serviceqq: DataTypes.STRING,//服务QQ
    isEnabled: {
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },
    aboutus: {//关于我们
      type: DataTypes.TEXT('long'),
      allowNull: true,
    },
    logo: {
      type: DataTypes.STRING,
    },//需要在后台补充   
    tel: DataTypes.STRING(20),//座机
    fax: DataTypes.STRING(50),//传真
    zipCode: DataTypes.STRING(20),//邮政编码
    companyTypeName: {
      type: DataTypes.STRING,
      defaultValue: "独立运作"
    },
    companyType: {//公司类型，self独立运作，full为全委托，part部分委托
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.company_type),
      set: function (val) {
        this.setDataValue("companyType", val);
        this.setDataValue("companyTypeName", uiconfig.config.pdict.company_type[val]);
      }
    },
    onlyCode: {//公司唯一编码
      type: DataTypes.STRING,
      defaultValue: uuidv4()
    },
    siteTheme: {//站点主题
      type: DataTypes.STRING,
      defaultValue: "default"
    },
    agentPerson: {//提报key代理公司负责人
      type: DataTypes.STRING(50),
      defaultValue: "张飞龙"
    },
    appid:DataTypes.STRING(200),//绑定公众号appid
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_company',
      validate: {
      }
    });
}
