const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("customerinfo", Object.assign({
    //基类name为公司名称或个人名称
    //基类code为公司统一社会代码
    province: DataTypes.STRING,//省名称
    city: DataTypes.STRING,//市名称
    applyAddr: DataTypes.STRING,//申请地址
    applyArea: DataTypes.STRING,//申请区域-存储省市的编码
    customerTypeName: DataTypes.STRING,
    customerType: {// "ent": "企业", "person": "个人"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.customer_type),
      set: function (val) {
        this.setDataValue("customerType", val);
        this.setDataValue("customerTypeName", uiconfig.config.pdict.customer_type[val]);
      }
    },
    identityCardNo: DataTypes.STRING(50),//身份证号
    identityCardPic: DataTypes.STRING,//身份证图片
    businessLicensePic: DataTypes.STRING,//营业执照图片   
    notes: DataTypes.STRING,//备注
    isLastOp: {//是否最后的操作，0否，1是，默认为1
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    owner_id: DataTypes.INTEGER,
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_customerinfo',
      validate: {
      }
    });
}
