const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("moneyaccount", Object.assign({
    //基类 code: 帐号
    //基类 name:  帐户名称

    balance: {//余额
      type: DataTypes.DECIMAL(12, 3),
      defaultValue: 0.00,
    },
    description: DataTypes.STRING,//描述
    accountType: {
      //帐户类型:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.accountType),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.accountType[val]);
      },
      defaultValue: "wx",
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
      defaultValue: "微信",
    },
    payAppId: {
      type: DataTypes.STRING,
    },//支付服务号id
    paySecstr: {
      type: DataTypes.STRING,
    },//支付服务号密钥
    paySectoken: {
      type: DataTypes.STRING,
    },//支付服务号token
    paySeccert: {
      type: DataTypes.STRING,
    },//支付服务号cert
    mechantid: {
      type: DataTypes.STRING,
    },//商户id
    mechantkey: {
      type: DataTypes.STRING,
    },//商户key
    mechantcerturl: {
      type: DataTypes.STRING,
    },//商户证书     
    isOfflinePay: {//是否支持线下支付,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    isPlatformAutopay: {//是否供平台转账，0否，1是，默认为0
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    transferRate: {//商户收款费率,千分率，如：值为5，计算时除以1000（第三方公司收款账户有此值）
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 5.00,
    },
    bankToPtTransferRate: {//银行收平台费率,千分率，如：值为2.6，计算时除以1000（平台公司收款账户有此值）
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 0,
    },
    certificateNo: {
      type: DataTypes.STRING,
    },//证件号    
    payeeName: {
      type: DataTypes.STRING,
    },//收款人姓名     
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_moneyaccount',
      validate: {
      }
    });
}
