const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("need", {
    publisherEnt:DataTypes.STRING,//发布者公司
    publisherName:DataTypes.STRING,//发布者姓名
    publisherMobile:DataTypes.STRING,//发布者手机号
    servicecode:DataTypes.STRING,
    servicename:DataTypes.STRING,
    city:DataTypes.STRING(50), // 城市
    province:DataTypes.STRING(50), // 省份
    // itemType:{
    //   //项目类型:ip:商标,ic:版权,pa:专利,iso:海外业务,common:增值服务,icbc:工商注册,zscq:知识产权,cwfw:财务服务,hyzz:行业资质,gqzr:股权转让,xzsp:行政审批
    //   type:DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.productCata),
    //   set:function(val){
    //     this.setDataValue("itemType",val);
    //     this.setDataValue("itemTypeName",uiconfig.config.pdict.productCata[val]);
    //   },
    //   defaultValue:"ip",
    // },
    itemType: {
      type: DataTypes.STRING
    },
    itemTypeName:{//服务类型名称
      type:DataTypes.STRING,
      defaultValue:"商标",
    },
    notes:DataTypes.STRING,//备注
    opNotes:DataTypes.STRING(4000),//操作备注
    statusName:DataTypes.STRING,
    status:{
      // 商机："1":"待服务","2":"跟进中","4":"已完成"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.need_status),
      set:function(val){
        this.setDataValue("status",val);
        this.setDataValue("statusName",uiconfig.config.pdict.need_status[val]);
      }
    },
    customer_intention_name: DataTypes.STRING(50),//客户意向名称
    customer_intention: {//客户意向：yxyb: 意向一般, yxhg: 重要意向, wjt: 未接通
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.customer_intention),
      set: function (val) {
        this.setDataValue("customer_intention", val);
        this.setDataValue("customer_intention_name", uiconfig.config.pdict.customer_intention[val]);
      }
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 's_need',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
