const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/voucherbase")(db, DataTypes);
  return db.define("receiptvoucher", Object.assign({//收款单：
    // 引用表的信息:
    // //收款单引用帐户信息
    // this.db.models.receiptvoucher.belongsTo(this.db.models.moneyaccount, { constraints: false, });
    // //收款单表引用用户信息
    // this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    // this.db.models.receiptvoucher.belongsTo(this.db.models.user, { as: 'payuser', constraints: false, });
    // this.db.models.receiptvoucher.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//创建收款单的公司

    //基类 code: 收款单号（自动生成）
    //基类 name:  ---暂时没有用
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，"order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号（如：订单号等）
    busPayOrderCode: DataTypes.STRING(100),//业务支付订单号
    payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号
    receiptTypeName: DataTypes.STRING,
    receiptType: {//收款类型，"sk": "收款","tk": "退款","zz": "转账" ,"csrz": "初始入账" ,"ptdsk": "代收款","ptzz": "平台转账"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.receipt_type),
      set: function (val) {
        this.setDataValue("receiptType", val);
        this.setDataValue("receiptTypeName", uiconfig.config.pdict.receipt_type[val]);
      }
    },
    accountType: {
      //帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.accountType),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.accountType[val]);
      },
      defaultValue: "wx",
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
      defaultValue: "微信",
    },
    payDate: DataTypes.DATE,//支付时间
    payFlowType: DataTypes.INTEGER,//支付流类型,1为订单支付，2为转账，3为补单
    totalSum: DataTypes.DECIMAL(12, 3),//订单总额（平台费用+服务费+官费+发票税费+个人利润+平台利润）
    certifyFileUrl: DataTypes.STRING(500), //证明文件Url
    notes: DataTypes.STRING,//备注
    sveItemCode: DataTypes.STRING(100),//项目操作码
    sveItemName: DataTypes.STRING(100),//项目名称
    buyerOpenId: DataTypes.STRING,//用户在商户appid下的唯一标识或买家在支付宝的用户id
    passTradeNo: DataTypes.STRING,//通道的统一订单号
    buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_receiptvoucher',
      validate: {
      }
    });
}
