const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("trademarktransaction", {
    // 引用表的信息:
    // this.db.models.trademarktransaction.belongsTo(this.db.models.company, { as: 'createcompany',constraints: false, });//来源，默认1即平台
    // this.db.models.trademarktransaction.belongsTo(this.db.models.user, { as: 'createuser',constraints: false, });//
    // this.db.models.trademarktransaction.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    code: DataTypes.STRING(50),//唯一码 商标号
    name: DataTypes.STRING(1000),//商标名称
    excelName: DataTypes.STRING(1000),//上传时的商标名
    tm_applier: DataTypes.STRING(50),//商标申请主体
    ncl_one_code: DataTypes.STRING(50),//商标大类编码
    business_quoted_price: DataTypes.STRING(50),//商家报价
    platform_quoted_price: DataTypes.STRING(50),//平台售价
    tm_structure_name: DataTypes.STRING(50),//商标结构名称
    // tm_structure: {//商标结构：1:"纯中文",2:"中文+英文",3:"纯图形",4:"英文",5:"英文+图形",6:"中文+英文+图形",7:"纯数字"
    //   type: DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.tm_company_type),
    //   set: function (val) {
    //     this.setDataValue("tm_structure", val);
    //     this.setDataValue("tm_structure_name", uiconfig.config.pdict.tm_company_type[val]);
    //   }
    // },
    pic_url:DataTypes.STRING(50),//商标图样
    tm_status_name:DataTypes.STRING(50),//商标状态名称
    // tm_status:{
    //   type: DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.tm_company_type),
    //   set: function (val) {
    //     this.setDataValue("tm_status", val);
    //     this.setDataValue("tm_status_name", uiconfig.config.pdict.tm_company_type[val]);
    //   }
    // },
    publish_status_name:DataTypes.STRING(50),//商标发布状态名称
    publish_status:{
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_transaction_publish_status),
      defaultValue: "audit",
      set: function (val) {
        this.setDataValue("publish_status", val);
        this.setDataValue("publish_status_name", uiconfig.config.pdict.tm_transaction_publish_status[val]);
      }
    },
    tm_group:DataTypes.STRING(200),//当前群组
    tm_service_item:DataTypes.STRING(200),//商品/服务项
    tm_introduction:DataTypes.STRING(500),//商标简介
    tm_start_day:DataTypes.DATE,//商标生效时间
    tm_end_day:DataTypes.DATE,//商标截止时间
    contacts:DataTypes.STRING(50),//联系人
    mobile:DataTypes.STRING(50),//联系电话
    notes: DataTypes.STRING,//备注
    op_notes: DataTypes.STRING(50),//操作备注   
    trademark_type_name: DataTypes.STRING(50),// 商标类型
    trademark_type:{//{"ordinary":"普通商标","specialoffer":"特价","highquality":"精品","hot":"热门","recommended":"推荐"}
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_transaction_type),
      defaultValue: "ordinary",
      set: function (val) {
        this.setDataValue("trademark_type", val);
        this.setDataValue("trademark_type_name", uiconfig.config.pdict.tm_transaction_type[val]);
      }
    },
    tm_regist_day:DataTypes.STRING(200),
    tm_ncl_third:DataTypes.STRING(200),
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'bi_trademarktransaction',
      validate: {

      },
      indexes: [
      ]
    });
}
